package gov.va.med.mhv.liferay.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.med.mhv.liferay.model.LiferayService;

/**
 * The persistence interface for the liferay service service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LiferayServicePersistenceImpl
 * @see LiferayServiceUtil
 * @generated
 */
public interface LiferayServicePersistence extends BasePersistence<LiferayService> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link LiferayServiceUtil} to access the liferay service persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the liferay services where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the liferay services where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @return the range of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the liferay services where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findByUuid(
        java.lang.String uuid, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService findByUuid_First(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException;

    /**
    * Returns the first liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching liferay service, or <code>null</code> if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService fetchByUuid_First(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService findByUuid_Last(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException;

    /**
    * Returns the last liferay service in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching liferay service, or <code>null</code> if a matching liferay service could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService fetchByUuid_Last(
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the liferay services before and after the current liferay service in the ordered set where uuid = &#63;.
    *
    * @param sessionid the primary key of the current liferay service
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService[] findByUuid_PrevAndNext(
        long sessionid, java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException;

    /**
    * Removes all the liferay services where uuid = &#63; from the database.
    *
    * @param uuid the uuid
    * @throws SystemException if a system exception occurred
    */
    public void removeByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of liferay services where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the number of matching liferay services
    * @throws SystemException if a system exception occurred
    */
    public int countByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the liferay service in the entity cache if it is enabled.
    *
    * @param liferayService the liferay service
    */
    public void cacheResult(
        gov.va.med.mhv.liferay.model.LiferayService liferayService);

    /**
    * Caches the liferay services in the entity cache if it is enabled.
    *
    * @param liferayServices the liferay services
    */
    public void cacheResult(
        java.util.List<gov.va.med.mhv.liferay.model.LiferayService> liferayServices);

    /**
    * Creates a new liferay service with the primary key. Does not add the liferay service to the database.
    *
    * @param sessionid the primary key for the new liferay service
    * @return the new liferay service
    */
    public gov.va.med.mhv.liferay.model.LiferayService create(long sessionid);

    /**
    * Removes the liferay service with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service that was removed
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService remove(long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException;

    public gov.va.med.mhv.liferay.model.LiferayService updateImpl(
        gov.va.med.mhv.liferay.model.LiferayService liferayService)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the liferay service with the primary key or throws a {@link gov.va.med.mhv.liferay.NoSuchLiferayServiceException} if it could not be found.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service
    * @throws gov.va.med.mhv.liferay.NoSuchLiferayServiceException if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService findByPrimaryKey(
        long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.med.mhv.liferay.NoSuchLiferayServiceException;

    /**
    * Returns the liferay service with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param sessionid the primary key of the liferay service
    * @return the liferay service, or <code>null</code> if a liferay service with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.med.mhv.liferay.model.LiferayService fetchByPrimaryKey(
        long sessionid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the liferay services.
    *
    * @return the liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the liferay services.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @return the range of liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll(
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the liferay services.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.med.mhv.liferay.model.impl.LiferayServiceModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of liferay services
    * @param end the upper bound of the range of liferay services (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of liferay services
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.med.mhv.liferay.model.LiferayService> findAll(
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the liferay services from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of liferay services.
    *
    * @return the number of liferay services
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
