package gov.va.med.mhv.liferay.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.med.mhv.liferay.service.ClpSerializer;
import gov.va.med.mhv.liferay.service.LiferayServiceLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class LiferayServiceClp extends BaseModelImpl<LiferayService>
    implements LiferayService {
    private String _uuid;
    private long _sessionid;
    private BaseModel<?> _liferayServiceRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.med.mhv.liferay.service.ClpSerializer.class;

    public LiferayServiceClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return LiferayService.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayService.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _sessionid;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setSessionid(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _sessionid;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("uuid", getUuid());
        attributes.put("sessionid", getSessionid());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String uuid = (String) attributes.get("uuid");

        if (uuid != null) {
            setUuid(uuid);
        }

        Long sessionid = (Long) attributes.get("sessionid");

        if (sessionid != null) {
            setSessionid(sessionid);
        }
    }

    @Override
    public String getUuid() {
        return _uuid;
    }

    @Override
    public void setUuid(String uuid) {
        _uuid = uuid;

        if (_liferayServiceRemoteModel != null) {
            try {
                Class<?> clazz = _liferayServiceRemoteModel.getClass();

                Method method = clazz.getMethod("setUuid", String.class);

                method.invoke(_liferayServiceRemoteModel, uuid);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSessionid() {
        return _sessionid;
    }

    @Override
    public void setSessionid(long sessionid) {
        _sessionid = sessionid;

        if (_liferayServiceRemoteModel != null) {
            try {
                Class<?> clazz = _liferayServiceRemoteModel.getClass();

                Method method = clazz.getMethod("setSessionid", long.class);

                method.invoke(_liferayServiceRemoteModel, sessionid);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getLiferayServiceRemoteModel() {
        return _liferayServiceRemoteModel;
    }

    public void setLiferayServiceRemoteModel(
        BaseModel<?> liferayServiceRemoteModel) {
        _liferayServiceRemoteModel = liferayServiceRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _liferayServiceRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_liferayServiceRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            LiferayServiceLocalServiceUtil.addLiferayService(this);
        } else {
            LiferayServiceLocalServiceUtil.updateLiferayService(this);
        }
    }

    @Override
    public LiferayService toEscapedModel() {
        return (LiferayService) ProxyUtil.newProxyInstance(LiferayService.class.getClassLoader(),
            new Class[] { LiferayService.class },
            new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        LiferayServiceClp clone = new LiferayServiceClp();

        clone.setUuid(getUuid());
        clone.setSessionid(getSessionid());

        return clone;
    }

    @Override
    public int compareTo(LiferayService liferayService) {
        long primaryKey = liferayService.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof LiferayServiceClp)) {
            return false;
        }

        LiferayServiceClp liferayService = (LiferayServiceClp) obj;

        long primaryKey = liferayService.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(5);

        sb.append("{uuid=");
        sb.append(getUuid());
        sb.append(", sessionid=");
        sb.append(getSessionid());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(10);

        sb.append("<model><model-name>");
        sb.append("gov.va.med.mhv.liferay.model.LiferayService");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(getUuid());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sessionid</column-name><column-value><![CDATA[");
        sb.append(getSessionid());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
