package gov.va.med.mhv.journal.web.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.ResponseUtil;
import gov.va.med.mhv.journal.service.JournalWebService;

@PropertySources(value = { @PropertySource("classpath:/${MHV_ENV_PROPERTY}.journal.application.properties"),
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.journal.liferay.properties") })
@ManagedBean
@Component
@Scope("session")
public class JournalController implements Serializable {

	private static final long serialVersionUID = 9198298420202914159L;
	private static Logger log = LogManager.getLogger(JournalController.class);

	protected static final String ERR_PRCS_RQST = "Error Processing request";

	@Value("${logoutUrl}")
	private String logoutUrl;

	@Value("${appContextroot}")
	private String appContextRoot;

	@Value("${journalEndpointUrl}")
	private String journalEndpointUrl;

	@Autowired
	private JournalWebService journalWebService;

	protected String firstName;
	protected String lastName;
	protected Boolean saveMessage = false;
	protected Boolean deleteMessage = false;
	protected Boolean editMealItem = false;
	protected String foodJournalReturnPage = "foodJournalSummary";
	protected Boolean editActivityDetail = false;

	private DataTable foodJournalTable;

	private DataTable activityJournalTable;

	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;

	protected List<FoodJournalDTO> foodJournalList = null;
	private List<FoodJournalDTO> dashFoodJournalList = null;
	private List<ActivityJournalDTO> dashActivityJournalList = null;
	protected String activityJournalReturnPage = "activityJournalSummary";

	// TODO: load activityJournalList
	protected List<ActivityJournalDTO> activityJournalList = null;

	public void authorizeJournalsHome(ComponentSystemEvent event) throws IOException {

		log.info("=====authorizeJournalsHome()==========");
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			FacesContext context = FacesContext.getCurrentInstance();

			if (request.getUserPrincipal() == null) {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "journalUnauthorized.xhtml");
			} else {
				Long userProfileId = getUserProfileId();
				/*
				 * dashFoodJournalList =
				 * getFoodJournalsForDashBoard(userProfileId);
				 * dashActivityJournalList =
				 * getActivityJournalsForDashBoard(userProfileId);
				 */
				if (!context.isPostback()) {
					getJournalsForDashBoard(userProfileId);
				}
			}
		} catch (Exception e) {
			log.error("Error in authorizeJournalsHome", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		if (log.isDebugEnabled()) {
			log.debug("getMhvContext() : " + context);
		}
		return context;
	}

	public void initFoodJornals(ComponentSystemEvent event) throws IOException {
		log.info("=====authorizeJournalsHome()==========");
		try {
			foodJournalTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("foodJournalForm:foodJList");
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			FacesContext context = FacesContext.getCurrentInstance();

			if (request.getUserPrincipal() == null) {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "journalUnauthorized.xhtml");
			} else {

				if (!context.isPostback()) {
					resetMessages();
					setRowsPerPage(10);
				} else {
					if (sortColumn != null && sortBy != null) {
						foodJournalTable.setValueExpression("sortBy", sortColumn);
						foodJournalTable.setSortOrder(sortBy);
					}
				}

				findUser();
				Long userProfileId = getUserProfileId();
				if (!context.isPostback()) {
					foodJournalList = getFoodJournals(userProfileId);
				}
			}
		} catch (Exception e) {
			log.error("Error in initFoodJornals", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public List<FoodJournalDTO> getFoodJournals(Long userProfileId) {
		List<FoodJournalDTO> foodJournals = null;

		try {

			foodJournals = journalWebService.getFoodJournalsForUser(userProfileId);

		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return foodJournals;
	}

	public List<FoodJournalDTO> getFoodJournalsForDashBoard(Long userProfileId) {
		List<FoodJournalDTO> foodJournals = null;

		try {

			foodJournals = journalWebService.getFoodJournalsForDashBoard(userProfileId);

		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return foodJournals;
	}

	public List<ActivityJournalDTO> getActivityJournalsForDashBoard(Long userProfileId) {
		List<ActivityJournalDTO> activityJournals = null;

		try {

			activityJournals = journalWebService.getActivityJournalsForDashBoard(userProfileId);

		} catch (Exception e) {
			log.error("Error in fetching activity journals for dash board", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return activityJournals;
	}

	public void getJournalsForDashBoard(Long userProfileId) {

		try {
			// TODO: clear() ?
			dashFoodJournalList = new ArrayList<FoodJournalDTO>();
			dashActivityJournalList = new ArrayList<ActivityJournalDTO>();

			dashFoodJournalList = journalWebService.getFoodJournalsForDashBoard(userProfileId);

			dashActivityJournalList = journalWebService.getActivityJournalsForDashBoard(userProfileId);

		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public FoodJournalDTO getFoodJournalById(Long foodJournalId) {
		FoodJournalDTO foodJournalDTO = null;

		try {
			foodJournalDTO = journalWebService.getFoodJournalById(foodJournalId);

		} catch (Exception e) {
			log.error("Error in fetching food journal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return foodJournalDTO;
	}

	public ActivityJournalDTO getActivityJournalById(Long activityJournalId) {
		ActivityJournalDTO activityJournalDTO = null;

		try {

			activityJournalDTO = journalWebService.findActivityJournalById(activityJournalId);

		} catch (Exception e) {
			log.error("Error in fetching activity journal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return activityJournalDTO;
	}

	protected void findUser() {
		PortletRequest request = null;
		User user = null;

		try {
			request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			log.error("Unable to get user from portal Utils");
		}

		if (user != null) {
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}

	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	// Get Activity Journals
	public void initActivityJornals(ComponentSystemEvent event) throws IOException {
		log.info("=====authorizeJournalsHome()==========");
		activityJournalTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("activityJournalForm:activityJList");
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		FacesContext context = FacesContext.getCurrentInstance();

		if (request.getUserPrincipal() == null) {
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "journalUnauthorized.xhtml");
		} else {

			if (!context.isPostback()) {
				resetActivityMessages();
				setRowsPerPage(10);
			} else {
				if (sortColumn != null && sortBy != null) {
					activityJournalTable.setValueExpression("sortBy", sortColumn);
					activityJournalTable.setSortOrder(sortBy);
				}
			}

			findUser();
			Long userProfileId = getUserProfileId();
			if (!context.isPostback()) {
				activityJournalList = getActivityJournals(userProfileId);
			}
		}
	}

	public void onSort(SortEvent event) {
		sortColumn = event.getSortColumn().getValueExpression("sortBy");
		sortBy = event.isAscending() ? "ascending" : "descending";
	}

	public List<ActivityJournalDTO> getActivityJournals(Long userProfileId) {
		List<ActivityJournalDTO> activityJournals = null;

		try {

			activityJournals = journalWebService.findActivityJournalsForUser(userProfileId);

		} catch (Exception e) {
			log.error("Error in fetching activity journals", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return activityJournals;
	}

	protected void processErrorMessages(MHVException e) {
		log.debug("failure message=" + e.getFailureMessage());

		// check if there are any validation errors in response object
		if (e.getValidationErrorMessages() != null && !e.getValidationErrorMessages().isEmpty()) {

			for (Map.Entry<String, String> err : e.getValidationErrorMessages().entrySet()) {
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
			}
		}

		// check for non-validation errors in response object
		if (e.getFailureMessage() != null && !e.getFailureMessage().isEmpty()) {
			String errorMessage = e.getFailureMessage();

			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
		}
	}

	protected void resetMessages() {
		saveMessage = false;
		// saveAndAddMessage = false;
		deleteMessage = false;
		editMealItem = false;
		// foodJournalReturnPage = "foodJournalSummary";
	}

	protected void resetActivityMessages() {
		saveMessage = false;
		// saveAndAddMessage = false;
		deleteMessage = false;
		editActivityDetail = false;
		// activityJournalReturnPage = "activityJournalSummary";
	}

	public String getLogoutUrl() {
		return logoutUrl;
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}

	public String getJournalEndpointUrl() {
		return journalEndpointUrl;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public List<FoodJournalDTO> getDashFoodJournalList() {
		return dashFoodJournalList;
	}

	public void setDashFoodJournalList(List<FoodJournalDTO> dashFoodJournalList) {
		this.dashFoodJournalList = dashFoodJournalList;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public List<ActivityJournalDTO> getDashActivityJournalList() {
		return dashActivityJournalList;
	}

	public void setDashActivityJournalList(List<ActivityJournalDTO> dashActivityJournalList) {
		this.dashActivityJournalList = dashActivityJournalList;
	}

	public Boolean getEditMealItem() {
		return editMealItem;
	}

	public void setEditMealItem(Boolean editMealItem) {
		this.editMealItem = editMealItem;
	}

	public Boolean getEditActivityDetail() {
		return editActivityDetail;
	}

	public void setEditActivityDetail(Boolean editActivityDetail) {
		this.editActivityDetail = editActivityDetail;
	}

	public String getFoodJournalReturnPage() {
		return foodJournalReturnPage;
	}

	public void setFoodJournalReturnPage(String foodJournalReturnPage) {
		this.foodJournalReturnPage = foodJournalReturnPage;
	}

	public String getActivityJournalReturnPage() {
		return activityJournalReturnPage;
	}

	public void setActivityJournalReturnPage(String activityJournalReturnPage) {
		this.activityJournalReturnPage = activityJournalReturnPage;
	}

	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}

	public DataTable getFoodJournalTable() {
		return foodJournalTable;
	}

	public void setFoodJournalTable(DataTable foodJournalTable) {
		this.foodJournalTable = foodJournalTable;
	}

	public DataTable getActivityJournalTable() {
		return activityJournalTable;
	}

	public List<FoodJournalDTO> getFoodJournalList() {
		return foodJournalList;
	}

	public void setFoodJournalList(List<FoodJournalDTO> foodJournalList) {
		this.foodJournalList = foodJournalList;
	}

	public List<ActivityJournalDTO> getActivityJournalList() {
		return activityJournalList;
	}

	public void setActivityJournalList(List<ActivityJournalDTO> activityJournalList) {
		this.activityJournalList = activityJournalList;
	}

	public void setActivityJournalTable(DataTable activityJournalTable) {
		this.activityJournalTable = activityJournalTable;
	}

}