package gov.va.med.mhv.journal.web.controller;

import java.io.IOException;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;
import gov.va.med.mhv.journal.enums.MealPrepMethodEnumeration;
import gov.va.med.mhv.journal.enums.MealQtyEnumeration;
import gov.va.med.mhv.journal.enums.MealSvgSizeEnumeration;
import gov.va.med.mhv.journal.enums.MealTypeEnumeration;
import gov.va.med.mhv.journal.exception.MHVRuntimeException;
import gov.va.med.mhv.journal.service.JournalWebService;

@ManagedBean
@Component
@Scope("session")
public class FoodJournalController extends JournalController {

	private static final long serialVersionUID = 2201037159515655515L;
	private static Logger log = LogManager.getLogger(FoodJournalController.class);

	private static final String REQUEST_FROM_ADD_JOURNAL = "addJournal";
	private static final String REQUEST_FROM_EDIT_JOURNAL = "editJournal";

	@Autowired
	private JournalWebService journalWebService;

	private FoodJournalDTO selectedFoodJournal;
	private FoodJournalDTO newFoodJournal = new FoodJournalDTO();

	public void init(ComponentSystemEvent event) throws IOException {

		if (!FacesContext.getCurrentInstance().isPostback()) {
			setRowsPerPage(10);
		}
	}

	public String showDetail(FoodJournalDTO foodJournalDTO) {
		try {
			resetMessages();
			foodJournalReturnPage = "foodJournalDetail";

			selectedFoodJournal = foodJournalDTO;
		} catch (Exception e) {
			log.error("Error in showDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "foodJournalDetail";
	}

	public void showFoodJournalDetail() {
		try {
			resetMessages();
			findUser();
			String foodJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodId");

			if (null != foodJournalId) {
				Long id = Long.valueOf(foodJournalId);
				selectedFoodJournal = getFoodJournalById(id);
			} else {
				throw new MHVRuntimeException("foodJournalId is null");
			}

			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "foodJournalDetail.xhtml");
		} catch (Exception e) {
			log.error("Error in showFoodJournalDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public String loadFoodJournalSummaryPrint() {
		resetMessages();
		setFoodJournalTable((DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("foodJournalForm:foodJList"));
		return "foodJournalSummaryPrint";
	}

	public String loadEditFoodJournalFromSummary(FoodJournalDTO foodJournalDTO) {
		try {
			selectedFoodJournal = foodJournalDTO;

			resetMessages();

			// set mealItem's editMode to false
			editMealItem = null;

			// which page to return from edit page 'Cancel' button
			foodJournalReturnPage = "foodJournalSummary";

			nullifyMeailItemValues(selectedFoodJournal);
		} catch (Exception e) {
			log.error("Error in loadEditFoodJournalFromSummary", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "editFoodJournalInfo";
	}

	public String loadEditFoodJournalFromDetail() {
		try {
			// set mealItem's editMode to false
			editMealItem = null;

			// which page to return from edit page 'Cancel' button
			foodJournalReturnPage = "foodJournalDetail";

			nullifyMeailItemValues(selectedFoodJournal);
		} catch (Exception e) {
			log.error("Error in loadEditFoodJournalFromDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "editFoodJournalInfo";
	}

	public String returnToCallingPage() {
		resetMessages();
		foodJournalReturnPage = (null != foodJournalReturnPage && foodJournalReturnPage.trim().length() > 0) ? foodJournalReturnPage : "foodJournalSummary";
		return foodJournalReturnPage;
	}

	public String loadEditFoodJournal() {
		try {
			String strFoodJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalId");
			Long foodJournalId = Long.valueOf(strFoodJournalId);

			// set mealItem's editMode to false
			editMealItem = null;

			selectedFoodJournal = getFoodJournalById(foodJournalId);
			nullifyMeailItemValues(selectedFoodJournal);
		} catch (Exception e) {
			log.error("Error in loadEditFoodJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "editFoodJournalInfo";
	}

	public String loadFoodJournal() {
		try {
			String strFoodJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalId");
			Long foodJournalId = Long.valueOf(strFoodJournalId);

			// set mealItem's editMode to false
			editMealItem = null;

			newFoodJournal = getFoodJournalById(foodJournalId);
			nullifyMeailItemValues(newFoodJournal);
		} catch (Exception e) {
			log.error("Error in loadFoodJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "addFoodJournalInfo";
	}

	public String loadSelectedMealItem() {
		MealItemDTO selectedMealItem = null;
		String returnpage = "addFoodJournalInfo";

		try {
			String strMealItemId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mealItemId");
			Long mealItemId = Long.valueOf(strMealItemId);

			selectedMealItem = journalWebService.getMealItemById(mealItemId);

			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom && requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				assignMealItemValues(selectedMealItem, newFoodJournal);
				returnpage = "addFoodJournalInfo";
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				assignMealItemValues(selectedMealItem, selectedFoodJournal);
				returnpage = "editFoodJournalInfo";
			}

			// set mealItem's editMode to true
			editMealItem = true;
			
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error("Error in loading selected meal Item", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return returnpage;

	}

	public String loadDeleteFoodJournal(FoodJournalDTO foodJournalDTO) {
		try {
			resetMessages();

			// which page to return from edit page 'Cancel' button
			foodJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalReturnPage");

			// if delete request from summary, then get food journal from
			// foodJournalTable, otherwise not required from detail page
			if (null != foodJournalReturnPage && foodJournalReturnPage.equalsIgnoreCase("foodJournalSummary")) {
				selectedFoodJournal = foodJournalDTO;
			}
		} catch (Exception e) {
			log.error("Error in loadDeleteFoodJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "deleteFoodJournalInfo";
	}
	
	
	
	public String loadDeleteFoodJournal() {
		resetMessages();
		// which page to return from edit page 'Cancel' button
		foodJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalReturnPage");
		return "deleteFoodJournalInfo";
	}
	

	public String deleteFoodJournal() {
		log.debug("deleteFoodJournal");

		try {
			String strFoodJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalId");
			setRowsPerPage(10);
			Long foodJournalId = Long.valueOf(strFoodJournalId);

			journalWebService.deleteFoodJournalById(foodJournalId);

			deleteMessage = true;
			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				foodJournalList = getFoodJournals(userProfileId);
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "foodJournalSummary";
	}

	public String deleteMealItem() {
		log.debug("deleteMealItem");

		String returnpage = "addFoodJournalInfo";

		try {
			String strMealItemId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mealItemId");
			Long mealItemId = Long.valueOf(strMealItemId);

			journalWebService.deleteMealItemById(mealItemId);

			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom && requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newFoodJournal = journalWebService.getFoodJournalById(newFoodJournal.getFoodJournalId());
				returnpage = "addFoodJournalInfo";
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedFoodJournal = journalWebService.getFoodJournalById(selectedFoodJournal.getFoodJournalId());
				returnpage = "editFoodJournalInfo";
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return returnpage;
	}

	public void addNewMeallItem() {
		FoodJournalDTO saveFoodJournal = null;
		FoodJournalDTO currentFoodJournal = null;
		MealItemDTO newMealItemDto = null;

		try {

			// <f:param name="requestFrom" value="addJournal" />
			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
					saveFoodJournal = newFoodJournal;
					currentFoodJournal = new FoodJournalDTO(newFoodJournal);
				} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
					saveFoodJournal = selectedFoodJournal;
					currentFoodJournal = new FoodJournalDTO(selectedFoodJournal);
				}
			} else {
				log.error("requestFrom is null");
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}

			// always store Food Journal along with newly entered Meal Item
			// details in DB
			newMealItemDto = addMealItemToFoodJournal(saveFoodJournal);
			
			FoodJournalDTO dto = journalWebService.addFoodJournal(saveFoodJournal);
			
			if (null != requestFrom && requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newFoodJournal = dto;
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedFoodJournal = dto;
			}
			
			// set mealItem's editMode to false
			editMealItem = null;

			
		} catch (MHVException e) {
			log.error(e);
			
			//if whole mealItem is null, remove it from Food Journal's mealItem list
			if (null != newMealItemDto && isMealItemNull(newMealItemDto)) {
				if (null != saveFoodJournal.getMealItems() && saveFoodJournal.getMealItems().size() > 0) {
					saveFoodJournal.getMealItems().remove(newMealItemDto);
				}
			}
			
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			
			//if whole mealItem is null, remove it from Food Journal's mealItem list
			if (null != newMealItemDto && isMealItemNull(newMealItemDto)) {
				if (null != saveFoodJournal.getMealItems() && saveFoodJournal.getMealItems().size() > 0) {
					saveFoodJournal.getMealItems().remove(newMealItemDto);
				}
			}

			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public String loadAddNewFoodJournalFromDashBoard() {
		try {
			findUser();
			resetMessages();
			setRowsPerPage(10);
			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				foodJournalList = getFoodJournals(userProfileId);
			}
			// which page to return from edit page 'Cancel' button
			foodJournalReturnPage = "foodJournalSummary";

			// initialize newFoodJournal object
			this.newFoodJournal = new FoodJournalDTO();
			this.newFoodJournal.setUserId(getUserProfileId());
			this.newFoodJournal.setCreatedDate(new java.util.Date());
			this.newFoodJournal.setJournalDate(new java.util.Date());

			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "addFoodJournalInfo.xhtml");
		} catch (Exception e) {
			log.error("Error in loadAddNewFoodJournalFromDashBoard", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return null;
	}

	public String loadAddNewFoodJournal() {
		try {
			findUser();
			resetMessages();

			// which page to return from edit page 'Cancel' button
			foodJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("foodJournalReturnPage");

			// initialize newFoodJournal object
			this.newFoodJournal = new FoodJournalDTO();
			this.newFoodJournal.setUserId(getUserProfileId());
			this.newFoodJournal.setCreatedDate(new java.util.Date());
			this.newFoodJournal.setJournalDate(new java.util.Date());
		} catch (Exception e) {
			log.error("Error in loadAddNewFoodJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "addFoodJournalInfo";
	}

	public String saveFoodJournal() {
		String returnpage = "addFoodJournalInfo";
		FoodJournalDTO saveFoodJournal = null;

		log.debug("saveFoodJournal");

		try {
			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
					saveFoodJournal = newFoodJournal;
					returnpage = "addFoodJournalInfo";
				} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
					saveFoodJournal = selectedFoodJournal;
					returnpage = "editFoodJournalInfo";
				}
			}
			
			journalWebService.addFoodJournal(saveFoodJournal);

			saveMessage = true;
			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				foodJournalList = getFoodJournals(userProfileId);
			}

			returnpage = "foodJournalSummary";

		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error("Error in saving new food journal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		log.debug("returnpage=" + returnpage);

		return returnpage;
	}

	public String loadFoodJournalSummary() {
		findUser();
		setRowsPerPage(10);
		Long userProfileId = getUserProfileId();
		if (userProfileId != null) {
			foodJournalList = getFoodJournals(userProfileId);
		}
		return "foodJournalSummary";
	}

	private MealItemDTO addMealItemToFoodJournal(FoodJournalDTO saveFoodJournal) {
		MealItemDTO updatedMealItemDto = new MealItemDTO();

		updatedMealItemDto.setMealItemId(saveFoodJournal.getMealItemId() != null ? saveFoodJournal.getMealItemId() : null);
		updatedMealItemDto.setMealType(StringUtils.trimToNull(saveFoodJournal.getMealType()));
		updatedMealItemDto.setServingSize(StringUtils.trimToNull(saveFoodJournal.getServingSize()));
		updatedMealItemDto.setQuantity(saveFoodJournal.getQuantity());
		updatedMealItemDto.setItem(StringUtils.trimToNull(saveFoodJournal.getItem()));
		updatedMealItemDto.setPrepMethod(StringUtils.trimToNull(saveFoodJournal.getPrepMethod()));
		updatedMealItemDto.setCreatedDate(new java.util.Date());

		// EDIT MEAL ITEM - if mealItem already exists, then update it in food
		// journal's meal Item set
		if (null != saveFoodJournal.getFoodJournalId() && null != saveFoodJournal.getMealItemId()) {
			Set<MealItemDTO> mealItems = saveFoodJournal.getMealItems();
			if (null != mealItems && mealItems.size() > 0) {
				for (MealItemDTO mealItemDto : mealItems) {
					if (mealItemDto.getMealItemId().longValue() == updatedMealItemDto.getMealItemId().longValue()) {
						saveFoodJournal.getMealItems().remove(mealItemDto);
						updatedMealItemDto.setEditMode(true);
						saveFoodJournal.getMealItems().add(updatedMealItemDto);
						break;
					}
				}
			}
		} else {
			// add new mealItem to food journal's meal Item set
			saveFoodJournal.getMealItems().add(updatedMealItemDto);
		}

		return updatedMealItemDto;
	}

	@SuppressWarnings("unused")
	private MealItemDTO getNewMealItem(FoodJournalDTO saveFoodJournal) {
		MealItemDTO mealItemDto = new MealItemDTO();

		mealItemDto.setMealItemId(saveFoodJournal.getMealItemId() != null ? saveFoodJournal.getMealItemId() : null);
		mealItemDto.setMealType(StringUtils.trimToNull(saveFoodJournal.getMealType()));
		mealItemDto.setServingSize(StringUtils.trimToNull(saveFoodJournal.getServingSize()));
		mealItemDto.setQuantity(saveFoodJournal.getQuantity());
		mealItemDto.setItem(StringUtils.trimToNull(saveFoodJournal.getItem()));
		mealItemDto.setPrepMethod(StringUtils.trimToNull(saveFoodJournal.getPrepMethod()));
		mealItemDto.setCreatedDate(new java.util.Date());
		mealItemDto.setFoodJournalId(saveFoodJournal.getFoodJournalId());

		return mealItemDto;
	}

	private void nullifyMeailItemValues(FoodJournalDTO foodJournalDto) {
		foodJournalDto.setMealItemId(null);
		foodJournalDto.setMealType(null);
		foodJournalDto.setServingSize(null);
		foodJournalDto.setQuantity(null);
		foodJournalDto.setItem(null);
		foodJournalDto.setPrepMethod(null);
	}

	private void assignMealItemValues(MealItemDTO selectedMealItem, FoodJournalDTO selectedFoodJournal) {
		selectedFoodJournal.setMealItemId(selectedMealItem.getMealItemId() != null ? selectedMealItem.getMealItemId() : null);
		selectedFoodJournal.setMealType(StringUtils.trimToNull(selectedMealItem.getMealType()));
		selectedFoodJournal.setServingSize(StringUtils.trimToNull(selectedMealItem.getServingSize()));
		selectedFoodJournal.setQuantity(selectedMealItem.getQuantity() != null ? selectedMealItem.getQuantity() : null);
		selectedFoodJournal.setItem(StringUtils.trimToNull(selectedMealItem.getItem()));
		selectedFoodJournal.setPrepMethod(StringUtils.trimToNull(selectedMealItem.getPrepMethod()));

		if (null != selectedFoodJournal.getMealItems() && selectedFoodJournal.getMealItems().size() > 0) {
			for (MealItemDTO mealItem : selectedFoodJournal.getMealItems()) {
				if (mealItem.getMealItemId().equals(selectedMealItem.getMealItemId())) {
					mealItem.setEditMode(true);
					// break;
				} else {
					mealItem.setEditMode(false);
				}
			}
		}
	}

	private boolean isMealItemNull(MealItemDTO mealItemDto) {
		boolean mealItemNull = true;

		if (null != mealItemDto) {
			if (null != mealItemDto.getMealItemId()) {
				return false;
			}

			if (null != StringUtils.trimToNull(mealItemDto.getMealType()) && null != mealItemDto.getQuantity()
					&& null != StringUtils.trimToNull(mealItemDto.getServingSize()) && null != StringUtils.trimToNull(mealItemDto.getItem())
					&& null != StringUtils.trimToNull(mealItemDto.getPrepMethod())) {
				mealItemNull = false;
			}
		}

		return mealItemNull;
	}

	public FoodJournalDTO getSelectedFoodJournal() {
		return selectedFoodJournal;
	}

	public MealTypeEnumeration[] getMealTypes() {
		return MealTypeEnumeration.values();
	}

	public MealQtyEnumeration[] getMealQtys() {
		return MealQtyEnumeration.values();
	}

	public MealSvgSizeEnumeration[] getMealSvgSizes() {
		return MealSvgSizeEnumeration.values();
	}

	public MealPrepMethodEnumeration[] getMealPrepMethods() {
		return MealPrepMethodEnumeration.values();
	}

	public FoodJournalDTO getNewFoodJournal() {
		return newFoodJournal;
	}

	public void setNewFoodJournal(FoodJournalDTO newFoodJournal) {
		this.newFoodJournal = newFoodJournal;
	}
}
