package gov.va.med.mhv.journal.web.controller;

import java.io.IOException;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.journal.enums.IntensityEnumeration;
import gov.va.med.mhv.journal.enums.MeasureEnumeration;
import gov.va.med.mhv.journal.enums.TimeOfDayEnumeration;
import gov.va.med.mhv.journal.exception.MHVRuntimeException;
import gov.va.med.mhv.journal.service.JournalWebService;

@ManagedBean
@Component
@Scope("session")
public class ActivityJournalController extends JournalController {

	private static final long serialVersionUID = 2201037159515655515L;
	private static Logger log = LogManager.getLogger(ActivityJournalController.class);

	private static final String REQUEST_FROM_ADD_JOURNAL = "addJournal";
	private static final String REQUEST_FROM_EDIT_JOURNAL = "editJournal";

	@Autowired
	private JournalWebService journalWebService;

	private ActivityJournalDTO selectedActivityJournal;

	private ActivityJournalDTO newActivityJournal = new ActivityJournalDTO();

	public void init(ComponentSystemEvent event) throws IOException {
		authorizeJournalsHome(event);

		findUser();
		userprofileId = getUserProfileId();

		if (!FacesContext.getCurrentInstance().isPostback()) {
			setRowsPerPage(10);
		}
	}

	public String showDetail(ActivityJournalDTO activityJournalDTO) {
		resetActivityMessages();
		activityJournalReturnPage = "activityJournalDetail";
		selectedActivityJournal = activityJournalDTO;
		return "activityJournalDetail";
	}

	public void showActivityJournalDetail() {
		try {
			resetActivityMessages();
			findUser();
			String activityJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityId");

			if (null != activityJournalId) {
				Long id = Long.valueOf(activityJournalId);
				selectedActivityJournal = getActivityJournalById(id);
			} else {
				throw new MHVRuntimeException("activityJournalId is null");
			}

			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "activityJournalDetail.xhtml");
		} catch (Exception e) {
			log.error("Error in showActivityJournalDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	public String loadActivityJournalSummaryPrint() {
		resetActivityMessages();
		setActivityJournalTable((DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("activityJournalForm:activityJList"));
		return "activityJournalSummaryPrint";
	}
	
	public ActivityJournalDTO getSelectedActivityJournal() {
		return selectedActivityJournal;
	}

	public void setSelectedActivityJournal(ActivityJournalDTO selectedActivityJournal) {
		this.selectedActivityJournal = selectedActivityJournal;
	}

	public ActivityJournalDTO getNewActivityJournal() {
		return newActivityJournal;
	}

	public void setNewActivityJournal(ActivityJournalDTO newActivityJournal) {
		this.newActivityJournal = newActivityJournal;
	}

	public String loadAddNewActivityJournalFromDashBoard() {
		try {
			findUser();
			resetActivityMessages();
			setRowsPerPage(10);
			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				activityJournalList = getActivityJournals(userProfileId);
			}
			// which page to return, when 'Cancel' button is licked
			activityJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalReturnPage");

			// initialize newActivityJournal object
			this.newActivityJournal = new ActivityJournalDTO();
			this.newActivityJournal.setUserId(getUserProfileId());
			this.newActivityJournal.setCreatedDate(new java.util.Date());
			this.newActivityJournal.setJournalDate(new java.util.Date());

			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "addActivityJournalInfo.xhtml");
		} catch (Exception e) {
			log.error("Error in loadAddNewActivityJournalFromDashBoard", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return null;
	}

	public String loadAddNewActivityJournal() {
		try {
			findUser();
			resetActivityMessages();

			// which page to return, when 'Cancel' button is licked
			activityJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalReturnPage");
			setRowsPerPage(10);
			// initialize newActivityJournal object
			this.newActivityJournal = new ActivityJournalDTO();
			this.newActivityJournal.setUserId(getUserProfileId());
			// this.newActivityJournal.setCreatedDate(new java.util.Date());
			this.newActivityJournal.setJournalDate(new java.util.Date());
		} catch (Exception e) {
			log.error("Error in loadAddNewActiviyJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return "addActivityJournalInfo";
	}

	public String loadDeleteActivityJournal(ActivityJournalDTO activityJournalDTO) {
		try {
			resetActivityMessages();

			// which page to return, when 'Cancel' button is clicked
			activityJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalReturnPage");

			// if delete request from summary, then get food journal from
			// activityJournalTable, otherwise not required from detail page
			if (null != activityJournalReturnPage && activityJournalReturnPage.equalsIgnoreCase("activityJournalSummary")) {
				selectedActivityJournal = activityJournalDTO;
			}
		} catch (Exception e) {
			log.error("Error in loadDeleteActivityJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "deleteActivityJournalInfo";
	}
	
	
	public String loadDeleteActivityJournal() {
		resetActivityMessages();
		// which page to return, when 'Cancel' button is clicked
		activityJournalReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalReturnPage");
		return "deleteActivityJournalInfo";
	}

	public String loadEditActivityJournal() {
		try {
			String strActivityJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalId");
			Long activityJournalId = Long.valueOf(strActivityJournalId);

			// set activityDetail's editMode to false
			editActivityDetail = null;

			selectedActivityJournal = getActivityJournalById(activityJournalId);
			nullifyActivityDetailValues(selectedActivityJournal);
		} catch (Exception e) {
			log.error("Error in loadEditActivityJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "editActivityJournalInfo";
	}

	public String loadActivityJournal() {
		try {
			String strActivityJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalId");
			Long activityJournalId = Long.valueOf(strActivityJournalId);

			// set activityDetail's editMode to false
			editActivityDetail = null;

			newActivityJournal = getActivityJournalById(activityJournalId);
			nullifyActivityDetailValues(newActivityJournal);
		} catch (Exception e) {
			log.error("Error in loadActivityJournal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "addActivityJournalInfo";
	}

	public String deleteActivityJournal() {
		log.debug("deleteActivityJournal");

		try {
			String strActivityJournalId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityJournalId");
			Long activityJournalId = Long.valueOf(strActivityJournalId);

			journalWebService.deleteActivityJournalById(activityJournalId);

			deleteMessage = true;

			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				activityJournalList = getActivityJournals(userProfileId);

			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error("Error in deleting activity journal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return "activityJournalSummary";
	}

	public void addNewActivityType() {
		ActivityJournalDTO saveActivityJournal = null;
		ActivityJournalDTO currentActivityJournal = null;
		ActivityDetailDTO activityDetailDto = null;
		String requestFrom = null;

		log.debug("addNewActivityType");

		try {

			// <f:param name="requestFrom" value="addJournal" />
			requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
					saveActivityJournal = newActivityJournal;
					currentActivityJournal = new ActivityJournalDTO(newActivityJournal);
				} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
					saveActivityJournal = selectedActivityJournal;
					currentActivityJournal = new ActivityJournalDTO(selectedActivityJournal);
				}
			} else {
				log.error("requestFrom is null");
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}

			// store Activity Journal along with new activity Type Item in DB
			// if (saveActivityJournal.getActivityJournalId() == null) {
			activityDetailDto = addActivityDetailToActivityJournal(saveActivityJournal);

			ActivityJournalDTO dto = journalWebService.addActivityJournal(saveActivityJournal);

			// set editActivityDetail's editMode to false
			editActivityDetail = null;

			if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newActivityJournal = dto;
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedActivityJournal = dto;
			}
		} catch (MHVException e) {
			log.error(e);

			if (null != activityDetailDto && isActivityDetailmNull(activityDetailDto)) {
				if (null != saveActivityJournal.getActivityDetails() && saveActivityJournal.getActivityDetails().size() > 0) {
					saveActivityJournal.getActivityDetails().remove(activityDetailDto);
				}
			}
			
			if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newActivityJournal = currentActivityJournal;
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedActivityJournal = currentActivityJournal;
			}

			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);

			if (null != activityDetailDto && isActivityDetailmNull(activityDetailDto)) {
				if (null != saveActivityJournal.getActivityDetails() && saveActivityJournal.getActivityDetails().size() > 0) {
					saveActivityJournal.getActivityDetails().remove(activityDetailDto);
				}
			}
			
			if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newActivityJournal = currentActivityJournal;
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedActivityJournal = currentActivityJournal;
			}

			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	private boolean isActivityDetailmNull(ActivityDetailDTO acvtDetailDto) {
		boolean activitytypeNull = true;

		if (null != acvtDetailDto.getActivityDetailId()) {
			return false;
		}

		if (null != acvtDetailDto && null != StringUtils.trimToNull(acvtDetailDto.getActivityType()) && null != acvtDetailDto.getMeasure()
				&& (null != acvtDetailDto.getDistanceDuration() && acvtDetailDto.getDistanceDuration().longValue() > 0)
				&& null != StringUtils.trimToNull(acvtDetailDto.getIntensity())
				&& (null != acvtDetailDto.getRepCount() && acvtDetailDto.getRepCount().longValue() > 0)
				&& (null != acvtDetailDto.getSetCount() && acvtDetailDto.getSetCount().longValue() > 0)
				&& null != StringUtils.trimToNull(acvtDetailDto.getTimeOfDay()) && null != StringUtils.trimToNull(acvtDetailDto.getDescription())) {
			activitytypeNull = false;
		}

		return activitytypeNull;
	}

	public String saveActivityJournal() {
		ActivityJournalDTO saveActivityJournal = null;
		String returnpage = "addActivityJournalInfo";

		log.debug("saveActivityJournal");

		try {
			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
					saveActivityJournal = newActivityJournal;
					returnpage = "addActivityJournalInfo";
				} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
					saveActivityJournal = selectedActivityJournal;
					returnpage = "editActivityJournalInfo";
				}
			}

			journalWebService.addActivityJournal(saveActivityJournal);

			saveMessage = true;
			Long userProfileId = getUserProfileId();
			if (userProfileId != null) {
				activityJournalList = getActivityJournals(userProfileId);
			}

			return "activityJournalSummary";

		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		log.debug("returnpage=" + returnpage);

		return returnpage;
	}

	private ActivityDetailDTO addActivityDetailToActivityJournal(ActivityJournalDTO saveActivityJournal) {
		ActivityDetailDTO activityDetailDto = new ActivityDetailDTO();
		activityDetailDto.setActivityDetailId(saveActivityJournal.getActivityDetailId() != null ? saveActivityJournal.getActivityDetailId() : null);
		activityDetailDto.setActivityType(StringUtils.trimToNull(saveActivityJournal.getActivityType()));
		activityDetailDto.setDistanceDuration(saveActivityJournal.getDistDuration());
		activityDetailDto.setMeasure(saveActivityJournal.getMeasure());
		activityDetailDto.setTimeOfDay(saveActivityJournal.getTimeOfDay());
		if (saveActivityJournal.getIntensity() != null) {
			activityDetailDto.setIntensity(StringUtils.trimToNull(saveActivityJournal.getIntensity()));
		}
		activityDetailDto.setSetCount(saveActivityJournal.getNoOfSets());
		activityDetailDto.setRepCount(saveActivityJournal.getNoOfReps());
		activityDetailDto.setDescription(StringUtils.trimToNull(saveActivityJournal.getActivityDesc()));

		// if activityType already exists, then update it in Acivity journal's
		// Activity Type set
		if (null != saveActivityJournal.getActivityJournalId() && null != saveActivityJournal.getActivityDetailId()) {
			Set<ActivityDetailDTO> activityDetails = saveActivityJournal.getActivityDetails();
			if (null != activityDetails && activityDetails.size() > 0) {
				for (ActivityDetailDTO acvtDetailDTO : activityDetails) {
					if (acvtDetailDTO.getActivityDetailId().longValue() == activityDetailDto.getActivityDetailId().longValue()) {
						saveActivityJournal.getActivityDetails().remove(acvtDetailDTO);
						activityDetailDto.setEditMode(true);
						saveActivityJournal.getActivityDetails().add(activityDetailDto);
						break;
					}
				}
			}
		} else {
			// add new activity to activity journal's activity type set
			saveActivityJournal.getActivityDetails().add(activityDetailDto);
		}

		return activityDetailDto;

	}

	private ActivityDetailDTO getNewActivityDetail(ActivityJournalDTO saveActivityJournal) {
		ActivityDetailDTO activityDetailDto = new ActivityDetailDTO();

		activityDetailDto.setActivityDetailId(saveActivityJournal.getActivityDetailId() != null ? saveActivityJournal.getActivityDetailId() : null);
		activityDetailDto.setActivityType(StringUtils.trimToNull(saveActivityJournal.getActivityType()));
		activityDetailDto.setDistanceDuration(saveActivityJournal.getDistDuration());
		activityDetailDto.setMeasure(saveActivityJournal.getMeasure());
		activityDetailDto.setTimeOfDay(saveActivityJournal.getTimeOfDay());
		activityDetailDto.setIntensity(StringUtils.trimToNull(saveActivityJournal.getIntensity()));
		activityDetailDto.setSetCount(saveActivityJournal.getNoOfSets());
		activityDetailDto.setRepCount(saveActivityJournal.getNoOfReps());
		activityDetailDto.setDescription(StringUtils.trimToNull(saveActivityJournal.getActivityDesc()));
		activityDetailDto.setActivityJournalId(saveActivityJournal.getActivityJournalId());
		// activityDetailDto.setCreatedDate(new java.util.Date());

		return activityDetailDto;
	}

	private void assignActivityDetailValues(ActivityDetailDTO selectedActivityDetail, ActivityJournalDTO selectedActivityJournal) {
		selectedActivityJournal.setActivityDetailId(selectedActivityDetail.getActivityDetailId() != null ? selectedActivityDetail.getActivityDetailId() : null);
		selectedActivityJournal.setActivityType(StringUtils.trimToNull(selectedActivityDetail.getActivityType()));
		selectedActivityJournal.setDistDuration(selectedActivityDetail.getDistanceDuration());
		selectedActivityJournal.setMeasure(selectedActivityDetail.getMeasure() != null ? selectedActivityDetail.getMeasure() : null);
		selectedActivityJournal.setIntensity(StringUtils.trimToNull(selectedActivityDetail.getIntensity()));
		selectedActivityJournal.setTimeOfDay(StringUtils.trimToNull(selectedActivityDetail.getTimeOfDay()));
		selectedActivityJournal.setNoOfSets(selectedActivityDetail.getSetCount());
		selectedActivityJournal.setNoOfReps(selectedActivityDetail.getRepCount());
		selectedActivityJournal.setActivityDesc(StringUtils.trimToNull(selectedActivityDetail.getDescription()));

		if (null != selectedActivityJournal.getActivityDetails() && selectedActivityJournal.getActivityDetails().size() > 0) {
			for (ActivityDetailDTO activityDetail : selectedActivityJournal.getActivityDetails()) {
				if (activityDetail.getActivityDetailId().equals(selectedActivityJournal.getActivityDetailId())) {
					activityDetail.setEditMode(true);
					// break;
				} else {
					activityDetail.setEditMode(false);
				}
			}
		}
	}

	public String loadSelectedActivityDetail() {
		ActivityDetailDTO selectedActivityDetail = null;
		String returnpage = "addActivityJournalInfo";

		log.debug("loadSelectedActivityDetail");

		try {
			String strActivityDetailId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityDetailId");
			Long activityDetailId = Long.valueOf(strActivityDetailId);

			selectedActivityDetail = journalWebService.getActivityDetailById(activityDetailId);

			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");
			if (null != requestFrom && requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				assignActivityDetailValues(selectedActivityDetail, newActivityJournal);
				returnpage = "addActivityJournalInfo";
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				assignActivityDetailValues(selectedActivityDetail, selectedActivityJournal);
				returnpage = "editActivityJournalInfo";
			}

			// set activityDetail's editMode to true
			editActivityDetail = true;
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error("Error in loading selected activity detail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return returnpage;
	}

	private void nullifyActivityDetailValues(ActivityJournalDTO activityJournalDto) {
		activityJournalDto.setActivityDetailId(null);
		activityJournalDto.setActivityType(null);
		activityJournalDto.setDistDuration(null);
		activityJournalDto.setMeasure(null);
		activityJournalDto.setIntensity(null);
		activityJournalDto.setNoOfReps(null);
		activityJournalDto.setNoOfSets(null);
		activityJournalDto.setActivityDesc(null);
	}

	public String deleteActivityDetail() {
		String returnpage = "addActivityJournalInfo";

		log.debug("deleteActivityDetail");

		try {
			String strActivityDetailId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("activityDetailId");
			Long activityDetailId = Long.valueOf(strActivityDetailId);

			journalWebService.deleteActivityDetailById(activityDetailId);
			String requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");

			if (null != requestFrom && requestFrom.equalsIgnoreCase(REQUEST_FROM_ADD_JOURNAL)) {
				newActivityJournal = journalWebService.findActivityJournalById(newActivityJournal.getActivityJournalId());
				returnpage = "addActivityJournalInfo";
			} else if (requestFrom.equalsIgnoreCase(REQUEST_FROM_EDIT_JOURNAL)) {
				selectedActivityJournal = journalWebService.findActivityJournalById(selectedActivityJournal.getActivityJournalId());
				returnpage = "editActivityJournalInfo";
			}

		} catch (Exception e) {
			log.error("Error in deleting activity journal", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return returnpage;
	}

	public String returnToCallingPage() {
		resetActivityMessages();
		activityJournalReturnPage = (null != activityJournalReturnPage && activityJournalReturnPage.trim().length() > 0) ? activityJournalReturnPage
				: "activityJournalSummary";
		return activityJournalReturnPage;
	}

	public String loadEditActivityJournalFromSummary(ActivityJournalDTO activityJournalDTO) {

		resetActivityMessages();
		selectedActivityJournal = activityJournalDTO;

		// set activity details editMode to false
		editActivityDetail = null;

		// which page to return from edit page 'Cancel' button
		activityJournalReturnPage = "activityJournalSummary";

		nullifyActivityDetailValues(selectedActivityJournal);

		return "editActivityJournalInfo";
	}

	public String loadEditActivityJournalFromDetail() {

		// set activityDetail editMode to false
		editActivityDetail = null;

		// which page to return from edit page 'Cancel' button
		activityJournalReturnPage = "activityJournalDetail";

		nullifyActivityDetailValues(selectedActivityJournal);

		return "editActivityJournalInfo";
	}

	public String loadActivityJournalSummary() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		Long userProfileId = getUserProfileId();
		if (userProfileId != null) {
			activityJournalList = getActivityJournals(userProfileId);
		}
		return "activityJournalSummary";
	}

	public ActivityTypeEnumeration[] getActivityTypes() {
		return ActivityTypeEnumeration.values();
	}

	public MeasureEnumeration[] getMeasureValues() {
		return MeasureEnumeration.values();
	}

	public IntensityEnumeration[] getIntensityValues() {
		return IntensityEnumeration.values();
	}

	public TimeOfDayEnumeration[] getTimeOfDayValues() {
		return TimeOfDayEnumeration.values();
	}

	@Override
	public String toString() {
		return "ActivityJournalController [journalWebService=" + journalWebService + ", selectedActivityJournal=" + selectedActivityJournal
				+ ", newActivityJournal=" + newActivityJournal + "]";
	}

}
