package gov.va.med.mhv.journal.converter;

import gov.va.med.mhv.journal.data.model.ActivityDetail;
import gov.va.med.mhv.journal.data.model.ActivityJournal;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.web.util.JournalDecorator;

import java.util.HashSet;
import java.util.Set;

import org.springframework.stereotype.Component;

@Component
public class ActivityJournalConverter {
	
	public ActivityJournalDTO convertDomainActivityJournal(ActivityJournal activityJournal) {
		ActivityJournalDTO activityJournalDto = new ActivityJournalDTO();
		
		activityJournalDto.setActivityJournalId(activityJournal.getActivityJournalId());
	//	activityJournalDto.setCreatedDate(activityJournal.getCreatedDate());
		activityJournalDto.setComments(activityJournal.getComments());
		activityJournalDto.setJournalDate(activityJournal.getJournalDate());
		//activityJournalDto.setModifiedDate(activityJournal.getModifiedDate());
		activityJournalDto.setDayNoOfWeek(JournalDecorator.getDayNoOfWeek(activityJournal.getJournalDate()));

		if (null != activityJournal.getActivityDetails() && activityJournal.getActivityDetails().size() > 0) {
			Set<ActivityDetailDTO> activityDetailDtos = new HashSet<ActivityDetailDTO>();
			for (ActivityDetail activityDetail : activityJournal.getActivityDetails()) {
				activityDetailDtos.add(new ActivityDetailConverter().convertDomainDetailItem(activityDetail));
			}
			activityJournalDto.setActivityDetails(activityDetailDtos);
		}
		
		activityJournalDto.setUserId(activityJournal.getUserId());
		/*if (null != activityJournal.getUserProfile()) {
			activityJournalDto.setUserProfile(new UserProfileConverter().convertDomainUserProfile(activityJournal.getUserProfile()));
		}*/
		
		return activityJournalDto;
	}
	
	
	public ActivityJournal convertDTOActivityJournal(ActivityJournalDTO activityJournalDto) {
		ActivityJournal activityJournal = new ActivityJournal();
		
		activityJournal.setActivityJournalId(activityJournalDto.getActivityJournalId());
		//activityJournal.setCreatedDate(activityJournalDto.getCreatedDate());
		activityJournal.setComments(activityJournalDto.getComments());
		activityJournal.setJournalDate(activityJournalDto.getJournalDate());
		//activityJournal.setModifiedDate(activityJournalDto.getModifiedDate());
		Set<ActivityDetail> activityDetails = new HashSet<ActivityDetail>();
		if (null != activityJournalDto.getActivityDetails() && activityJournalDto.getActivityDetails().size() > 0) {
			for (ActivityDetailDTO activityDetailDto : activityJournalDto.getActivityDetails()) {
				activityDetails.add(new ActivityDetailConverter().convertDTODetailItem(activityDetailDto));
			}
		}
		activityJournal.setActivityDetails(activityDetails);
		
		activityJournal.setUserId(activityJournalDto.getUserId());
		/*if (null != activityJournalDto.getUserProfile()) {
			activityJournal.setUserProfile(new UserProfileConverter().convertDTOProfile(new UserProfile(), activityJournalDto.getUserProfile()));
		}*/
		
		return activityJournal;
	}
}
