package gov.va.med.mhv.journal.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "FOOD_JOURNAL_MEAL_ITEMS")
public class MealItem implements Serializable {

	private static final long serialVersionUID = 4538674933294206670L;

	@Id
	@Column(name = "FOOD_JOURNAL_MEAL_ITEM_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long mealItemId;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "ITEM")
	private String item;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "MEAL_TYPE")
	private String mealType;

	@Column(name = "MEAL_ITEM_SERVING_SIZE")
	private String servingSize;

	@Column(name = "MEAL_ITEM_QUANTITY")
	private BigDecimal quantity;

	@Column(name = "MEAL_ITEM_PREP_METHOD")
	private String prepMethod;

	@Column(name = "FOOD_JOURNAL_ID_SEQ", insertable = false, updatable = false)
	private Long foodJournalId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FOOD_JOURNAL_ID_SEQ")
	private FoodJournal foodJournal;

	public Long getMealItemId() {
		return mealItemId;
	}

	public void setMealItemId(Long mealItemId) {
		this.mealItemId = mealItemId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getItem() {
		return item;
	}

	public void setItem(String item) {
		this.item = item;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getMealType() {
		return mealType;
	}

	public void setMealType(String mealType) {
		this.mealType = mealType;
	}

	public String getServingSize() {
		return servingSize;
	}

	public void setServingSize(String servingSize) {
		this.servingSize = servingSize;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public String getPrepMethod() {
		return prepMethod;
	}

	public void setPrepMethod(String prepMethod) {
		this.prepMethod = prepMethod;
	}

	public Long getFoodJournalId() {
		return foodJournalId;
	}

	public void setFoodJournalId(Long foodJournalId) {
		this.foodJournalId = foodJournalId;
	}

	public FoodJournal getFoodJournal() {
		return foodJournal;
	}

	public void setFoodJournal(FoodJournal foodJournal) {
		this.foodJournal = foodJournal;
	}
}
