package gov.va.med.mhv.journal.web.util;

import java.math.BigDecimal;
import java.util.Map;
import java.util.HashMap;
import java.util.TreeMap;


public class MealItemMap {
	
	private static final Map<BigDecimal, String> quantities;
	private static final Map<String, String> servingSizes;
	
	public static final String SERVING_SIZE_2_OZ = "2 oz";
    public static final String SERVING_SIZE_3_OZ = "3 oz";
    public static final String SERVING_SIZE_4_OZ = "4 oz";
    public static final String SERVING_SIZE_6_OZ = "6 oz";
    public static final String SERVING_SIZE_8_OZ = "8 oz";
    public static final String SERVING_SIZE_12_OZ = "12 oz";
    public static final String SERVING_SIZE_16_OZ = "16 oz";
    public static final String SERVING_SIZE_SMALL = "Small";
    public static final String SERVING_SIZE_MEDIUM = "Medium";
    public static final String SERVING_SIZE_LARGE = "Large";
    public static final String SERVING_SIZE_X_LARGE = "X-Large";
    public static final String SERVING_SIZE_CUP = "Cup";
    public static final String SERVING_SIZE_SLICE = "Slice";
    public static final String SERVING_SIZE_TABLESPOON = "Tablespoon";
    public static final String SERVING_SIZE_TEASPOON = "Teaspoon";
	
	static {	
		quantities = new TreeMap<BigDecimal, String>();
		quantities.put(new BigDecimal(.25), "1/4");
	    quantities.put(new BigDecimal(.5), "1/2");
	    quantities.put(new BigDecimal(.75), "3/4");
	    quantities.put(new BigDecimal(1), "1");
	    quantities.put(new BigDecimal(2), "2");
	    quantities.put(new BigDecimal(3), "3");
	    quantities.put(new BigDecimal(4), "4");
	    quantities.put(new BigDecimal(5), "5");
	    quantities.put(new BigDecimal(6), "6");
	    quantities.put(new BigDecimal(7), "7");
	    quantities.put(new BigDecimal(8), "8");
	    quantities.put(new BigDecimal(9), "9");
	    quantities.put(new BigDecimal(10), "10");
	    quantities.put(new BigDecimal(11), "11");
	    quantities.put(new BigDecimal(12), "12");
	    quantities.put(new BigDecimal(13), "13");
	    quantities.put(new BigDecimal(14), "14");
	    quantities.put(new BigDecimal(15), "15");
	    quantities.put(new BigDecimal(16), "16");
	    quantities.put(new BigDecimal(17), "17");
	    quantities.put(new BigDecimal(18), "18");
	    quantities.put(new BigDecimal(19), "19");
	    quantities.put(new BigDecimal(20), "20");
	    quantities.put(new BigDecimal(21), "21");
	    quantities.put(new BigDecimal(22), "22");
	    quantities.put(new BigDecimal(23), "23");
	    quantities.put(new BigDecimal(24), "24");
	    quantities.put(new BigDecimal(25), "25");
	    
	    servingSizes = new HashMap<String, String>(15);
	    servingSizes.put("2", SERVING_SIZE_2_OZ);
        servingSizes.put("3", SERVING_SIZE_3_OZ);
        servingSizes.put("4", SERVING_SIZE_4_OZ);
        servingSizes.put("6", SERVING_SIZE_6_OZ);
        servingSizes.put("8", SERVING_SIZE_8_OZ);
        servingSizes.put("12", SERVING_SIZE_12_OZ);
        servingSizes.put("16", SERVING_SIZE_16_OZ);
        servingSizes.put(SERVING_SIZE_SMALL, SERVING_SIZE_SMALL);
        servingSizes.put(SERVING_SIZE_MEDIUM, SERVING_SIZE_MEDIUM);
        servingSizes.put(SERVING_SIZE_LARGE, SERVING_SIZE_LARGE);
        servingSizes.put(SERVING_SIZE_X_LARGE, SERVING_SIZE_X_LARGE);
        servingSizes.put(SERVING_SIZE_CUP, SERVING_SIZE_CUP);
        servingSizes.put(SERVING_SIZE_SLICE, SERVING_SIZE_SLICE);
        servingSizes.put(SERVING_SIZE_TABLESPOON, SERVING_SIZE_TABLESPOON);
        servingSizes.put(SERVING_SIZE_TEASPOON, SERVING_SIZE_TEASPOON);
	}
	
	public static Map<BigDecimal, String> getQuantities() {
		return quantities;
	}
	
	public static Map<String, String> getServingSizes() {
		return servingSizes;
	}
}
