package gov.va.med.mhv.journal.web.util;

import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;
import gov.va.med.mhv.journal.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.journal.enums.MealTypeEnumeration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;

public class JournalDecorator implements Serializable {
	
	private static final long serialVersionUID = 8242865186685540565L;
	
	private static final String DISP_DATE_FORMAT = "MM/dd/yyyy";
	private static final String NUMBER_WEEKDAY_FORMAT = "u";
	private static final String ABBR_WEEKDAY_FORMAT = "EEE";
	private static final String FULL_WEEKDAY_FORMAT = "EEEE";
	private static final String WATER = "Water";
	private static final String COMMENTS = "Comments";
	
	/*
	protected List<String> bfItems = null;
	protected List<String> lItems = null;
	protected List<String> dItems = null;
	protected List<String> sItems = null;*/

	public static String formatDate(Date date) {
		return (null != date) ? WebUtility.dateToString(date, DISP_DATE_FORMAT) : "";
	}
	
	public static int getDayNoOfWeek(Date date) {
		Calendar c = Calendar.getInstance();
		c.setTime(date);
		c.setFirstDayOfWeek(Calendar.SUNDAY);
		
		return (null != date) ? c.get(Calendar.DAY_OF_WEEK) : 8;
    }

	public static String getDayOfWeek(Date date) {
		return (null != date) ? WebUtility.dateToString(date, FULL_WEEKDAY_FORMAT) : "";
    }
	
	public static String getAbbrDayOfWeek(Date date) {
		return (null != date) ? WebUtility.dateToString(date, ABBR_WEEKDAY_FORMAT) : "";
    }
	
	public static String getFoodJournalSummary(FoodJournalDTO journal) {
		String summaryString = null;
		String mealType = null;
		SortedMap<String, String> mealTypesMap = new TreeMap<String, String>();
		
		if (null != journal && null != journal.getMealItems() && journal.getMealItems().size() > 0) {
			for(MealItemDTO mealItem : journal.getMealItems()) {
				mealType = mealItem.getMealType();
				if (MealTypeEnumeration.BREAKFAST.getMealType().equalsIgnoreCase(mealType)) {
					mealTypesMap.put("A", MealTypeEnumeration.BREAKFAST.getMealDesc());
				} else if (MealTypeEnumeration.LUNCH.getMealType().equalsIgnoreCase(mealType)) {
					mealTypesMap.put("B", MealTypeEnumeration.LUNCH.getMealDesc());
				} else if (MealTypeEnumeration.DINNER.getMealType().equalsIgnoreCase(mealType)) {
					mealTypesMap.put("C", MealTypeEnumeration.DINNER.getMealDesc());
				} else if (MealTypeEnumeration.SNACK.getMealType().equalsIgnoreCase(mealType)) {
					mealTypesMap.put("D", MealTypeEnumeration.SNACK.getMealDesc());
				}
			}
			
			if (journal.getComments() != null) {
				mealTypesMap.put("E", COMMENTS);
			}
		
			if (journal.getGlassesOfWater() != null) {
				mealTypesMap.put("F", WATER);
			}
			
			summaryString = StringUtils.join(mealTypesMap.values(), ", ");
			
			/*for(MealItemDTO item : journal.getMealItems()) {
				//unique mealTypes
				if (!includedMealTypes.contains(item.getMealType())) {
					includedMealTypes.add(item.getMealType());
				}
			}
			
			for (String mealType : includedMealTypes) {
				for (MealTypeEnumeration mealTypeEnumeration : MealTypeEnumeration.values()){
					if (mealTypeEnumeration.getMealType().equalsIgnoreCase(mealType)) {
						summaryString = addToString(summaryString, mealTypeEnumeration.getMealDesc());
					}
				}
			}

			if (journal.getComments() != null) {
				summaryString = addToString(summaryString, COMMENTS);
			}
		
			if (journal.getGlassesOfWater() != null) {
				summaryString = addToString(summaryString, WATER);
			}*/
		}
		
		return summaryString;
	}
	
	public static List<String> getDecoratedItems(FoodJournalDTO journal, String mealType) {
		List<String> items = new ArrayList<String>();

		if (null != journal && null != journal.getMealItems() && journal.getMealItems().size() > 0) {
			for(MealItemDTO mealItem : journal.getMealItems()) {
				if (mealType.equalsIgnoreCase(mealItem.getMealType())) {
					items.add(MealItemDecorator.getDescription(mealItem) + MealItemDecorator.getPrepMethod(mealItem));
				} 
			}
		}
		
		return items;
	}
	
	public static List<String> getDecoratedActivityTypes(ActivityJournalDTO journal, String acvtType) {
		List<String> types = new ArrayList<String>();

		if (null != journal && null != journal.getActivityDetails() && journal.getActivityDetails().size() > 0) {
			for(ActivityDetailDTO activityType : journal.getActivityDetails()) {
				if (acvtType.equalsIgnoreCase(activityType.getActivityType())) {
					types.add(ActivityTypeDecorator.getDescription(activityType));
				} 
			}
		}
		
		return types;
	}
	
	public static List<MealItemDTO> getMealItemsSubList(Set<MealItemDTO> mealItems, String mealType) {
		List<MealItemDTO> subList = new ArrayList<MealItemDTO>();

		if (null != mealItems && mealItems.size() > 0) {
			for(MealItemDTO mealItem : mealItems) {
				if (null != mealItem.getMealItemId() && mealType.equalsIgnoreCase(mealItem.getMealType())) {
					subList.add(mealItem);
				} 
			}
		}
		
		Collections.sort(subList);
		
		return subList;
	}
	
	public static List<ActivityDetailDTO> getActivityDetailSubList(Set<ActivityDetailDTO> activityDetails, String activityType) {
		List<ActivityDetailDTO> activitySubList = new ArrayList<ActivityDetailDTO>();

		if (null != activityDetails && activityDetails.size() > 0) {
			for(ActivityDetailDTO activityDetail : activityDetails) {
				if (activityType.equalsIgnoreCase(activityDetail.getActivityType())) {
					activitySubList.add(activityDetail);
				} 
			}
		}
		
		Collections.sort(activitySubList);
		
		return activitySubList;
	}
	
	private String addToString(String delimitedString, String stringItem) {
		if (StringUtils.isNotEmpty(delimitedString)) {
			if (StringUtils.isNotEmpty(stringItem)) {
				return delimitedString + ", " + stringItem;
			}
			return delimitedString;
		}
		return stringItem;
	}
	
	public static String getMealItemsCount(FoodJournalDTO journal) {
		String displayValue = "";
		
		int count = (null != journal.getMealItems()) ? journal.getMealItems().size() : 0;
		if (count == 1) {
			displayValue = "<strong>" + count + "</strong>" + " Meal Item";
		} else if (count > 1) {
			displayValue = "<strong>" + count + "</strong>" + " Meal Items";
		}
		
		return displayValue;
	}
	
	public static String getActivityTypeCount(ActivityJournalDTO journal) {
		String displayValue = "";
		
		int count = (null != journal.getActivityDetails()) ? journal.getActivityDetails().size() : 0;
		if (count == 1) {
			displayValue = "<strong>" + count + "</strong>" + " Activity";
		} else if (count > 1) {
			displayValue = "<strong>" + count + "</strong>" + " Activities";
		}
		
		return displayValue;
	}
	
	public static String getActivityJournalSummary(ActivityJournalDTO journal) {
		String summaryString = null;
		String activityType = null;
		SortedMap<String, String> activityTypesMap = new TreeMap<String, String>();
		
		if (null != journal && null != journal.getActivityDetails() && journal.getActivityDetails().size() > 0) {
			for(ActivityDetailDTO activityDetailItem : journal.getActivityDetails()) {
				activityType = activityDetailItem.getActivityType();
				if (ActivityTypeEnumeration.AEROBIC.getActivityType().equalsIgnoreCase(activityType)) {
					activityTypesMap.put("A", ActivityTypeEnumeration.AEROBIC.getActivityDesc());
				} else if (ActivityTypeEnumeration.WEIGHTS.getActivityType().equalsIgnoreCase(activityType)) {
					activityTypesMap.put("B", ActivityTypeEnumeration.WEIGHTS.getActivityDesc());
				} else if (ActivityTypeEnumeration.OTHER.getActivityType().equalsIgnoreCase(activityType)) {
					activityTypesMap.put("C", ActivityTypeEnumeration.OTHER.getActivityDesc());
				} 
			}
			
			if (journal.getComments() != null) {
				activityTypesMap.put("E", COMMENTS);
			}
		
/*			if (journal.getGlassesOfWater() != null) {
				mealTypesMap.put("F", WATER);
			}*/
			
			summaryString = StringUtils.join(activityTypesMap.values(), ", ");
			

		}
		
		return summaryString;
	}	
}
