package gov.va.med.mhv.journal.dto;

import gov.va.med.mhv.journal.web.util.MealItemDecorator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings("unused")
public class MealItemDTO implements Serializable, Comparable<MealItemDTO> {

	private static final long serialVersionUID = 5983324865886841043L;
	
	private Long mealItemId;
	private Date createdDate;
	private String item;
	private Date modifiedDate;
	private String mealType;
	private String servingSize;
	private BigDecimal quantity;
	private String prepMethod;
	private Long foodJournalId;
	private FoodJournalDTO foodJournal;
	
	private String dispDesc;
	private Boolean editMode;
	
	public Long getMealItemId() {
		return mealItemId;
	}

	public void setMealItemId(Long mealItemId) {
		this.mealItemId = mealItemId;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getItem() {
		return item;
	}

	public void setItem(String item) {
		this.item = item;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getMealType() {
		return mealType;
	}

	public void setMealType(String mealType) {
		this.mealType = mealType;
	}

	public String getServingSize() {
		return servingSize;
	}

	public void setServingSize(String servingSize) {
		this.servingSize = servingSize;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public String getPrepMethod() {
		return prepMethod;
	}

	public void setPrepMethod(String prepMethod) {
		this.prepMethod = prepMethod;
	}

	public Long getFoodJournalId() {
		return foodJournalId;
	}

	public void setFoodJournalId(Long foodJournalId) {
		this.foodJournalId = foodJournalId;
	}

	public FoodJournalDTO getFoodJournal() {
		return foodJournal;
	}

	public void setFoodJournal(FoodJournalDTO foodJournal) {
		this.foodJournal = foodJournal;
	}
	
	public String getDispDesc() {
		return MealItemDecorator.getDescription(this);
	}
	
	public void setDispDesc(String dispDesc) {
		this.dispDesc = dispDesc;
	}
	
	public Boolean getEditMode() {
		return editMode;
	}
	
	public void setEditMode(Boolean editMode) {
		this.editMode = editMode;
	}

	@Override
	public int compareTo(MealItemDTO mealItem) {
		return this.mealItemId.compareTo(mealItem.getMealItemId());
	}

	@Override
	public String toString() {
		return "MealItemDTO [mealItemId=" + mealItemId + ", createdDate=" + createdDate + ", item=" + item + ", modifiedDate=" + modifiedDate + ", mealType="
				+ mealType + ", servingSize=" + servingSize + ", quantity=" + quantity + ", prepMethod=" + prepMethod + ", foodJournalId=" + foodJournalId
				+ ", foodJournal=" + foodJournal + ", dispDesc=" + dispDesc + ", editMode=" + editMode + "]";
	}
	
	
}
