package gov.va.med.mhv.journal.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class ActivityDetailDTO implements Serializable, Comparable<ActivityDetailDTO> /* extends MealItemDecorator */{

	private static final long serialVersionUID = 5983324865886841043L;

	private Long activityDetailId;
	private BigDecimal repCount;
	private String description;
	private String timeOfDay;
	private String activityType;
	private String measure;
	private BigDecimal distanceDuration;
	private BigDecimal setCount;
	private String intensity;
	private Long activityJournalId;
	private ActivityJournalDTO activityJournal;

	private String dispIntensity;
	private String dispMeasure;
	private String dispTimeOfDay;
	private String dispDescription;
	private StringBuffer dispDesc = null;
	private Boolean editMode;
	
	public ActivityDetailDTO() {		
	}
	
	public Long getActivityDetailId() {
		return activityDetailId;
	}

	public void setActivityDetailId(Long activityDetailId) {
		this.activityDetailId = activityDetailId;
	}

	public BigDecimal getRepCount() {
		return repCount;
	}

	public void setRepCount(BigDecimal repCount) {
		this.repCount = repCount;
	}

	public BigDecimal getDistanceDuration() {
		return distanceDuration;
	}

	public void setDistanceDuration(BigDecimal distanceDuration) {
		this.distanceDuration = distanceDuration;
	}

	public BigDecimal getSetCount() {
		return setCount;
	}

	public void setSetCount(BigDecimal setCount) {
		this.setCount = setCount;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getTimeOfDay() {
		return timeOfDay;
	}

	public void setTimeOfDay(String timeOfDay) {
		this.timeOfDay = timeOfDay;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public String getMeasure() {

		return measure;
	}

	public void setMeasure(String measure) {
		this.measure = measure;
	}

	public String getIntensity() {

		return intensity;
	}

	public void setIntensity(String intensity) {
		this.intensity = intensity;
	}

	public Long getActivityJournalId() {
		return activityJournalId;
	}

	public void setActivityJournalId(Long activityJournalId) {
		this.activityJournalId = activityJournalId;
	}

	public ActivityJournalDTO getActivityJournal() {
		return activityJournal;
	}

	public void setActivityJournal(ActivityJournalDTO activityJournal) {
		this.activityJournal = activityJournal;
	}

	public String getDispIntensity() {
		if (intensity != null) {
			if (intensity.equalsIgnoreCase("L")) {
				dispIntensity = "Low impact";
			} else if (intensity.equalsIgnoreCase("M")) {
				dispIntensity = "Moderate impact";
			} else {
				dispIntensity = "High impact";
			}
		}
		return dispIntensity;
	}

	public void setDispIntensity(String dispIntensity) {
		this.dispIntensity = dispIntensity;
	}

	public String getDispMeasure() {
		if (measure != null) {
			if (measure.equalsIgnoreCase("MN")) {
				dispMeasure = "Min(s)";
			} else if (measure.equalsIgnoreCase("HR")) {
				dispMeasure = "hr(s)";
			} else if (measure.equalsIgnoreCase("ML")) {
				dispMeasure = "mile(s)";
			} else if (measure.equalsIgnoreCase("KM")) {
				dispMeasure = "kilopmeter(s)";
			} else if (measure.equalsIgnoreCase("P")) {
				dispMeasure = "pound(s)";
			} else if (measure.equalsIgnoreCase("LP")) {
				dispMeasure = "lap(s)";
			} else {
				dispMeasure = "kilogram(s)";
			}
		}

		return dispMeasure;
	}

	public void setDispMeasure(String dispMeasure) {
		this.dispMeasure = dispMeasure;
	}


	public String getDispDescription() {
		DecimalFormat df = new DecimalFormat("0.####");
		dispDesc = new StringBuffer();
		if (this.getDistanceDuration() != null && getDispMeasure() == null && (( getSetCount() != null && getSetCount().longValue() > 0) || (getRepCount() != null && getRepCount().longValue() > 0))) {
			dispDesc.append(df.format(this.getDistanceDuration()) + "; ");
		}else if (this.getDistanceDuration() == null && getDispMeasure() != null && ((getSetCount() != null && getSetCount().longValue() > 0) || (getRepCount() != null && getRepCount().longValue() > 0))) {
			dispDesc.append(" " + getDispMeasure() + "; ");
		}else if (this.getDistanceDuration() != null && getDispMeasure() == null && (getSetCount() == null && getRepCount() == null)) {
			dispDesc.append(" " + df.format(this.getDistanceDuration()) + " of ");
		}else if (this.getDistanceDuration() == null && getDispMeasure() != null && (getSetCount() == null && getRepCount() == null)) {
			dispDesc.append(" " + getDispMeasure() + " of ");
		}else if (this.getDistanceDuration() != null && getDispMeasure() != null && (getSetCount() == null && getRepCount() == null)) {
			dispDesc.append(df.format(this.getDistanceDuration()) + " " + getDispMeasure() + " of ");
		}else if (this.getDistanceDuration() != null && getDispMeasure() != null && ((getSetCount() != null && getSetCount().longValue() > 0) || (getRepCount() != null && getRepCount().longValue() > 0))) {
			dispDesc.append(df.format(this.getDistanceDuration()) + " " + getDispMeasure() + "; ");
		}		
		if (null != getSetCount() && getSetCount().longValue() > 0) {
			dispDesc.append(df.format(getSetCount()) + " set(s) of ");
		}
		if (null != getRepCount() && getRepCount().longValue() > 0) {
			dispDesc.append(df.format(getRepCount()) + " reps of ");
		}
		if (getDescription() != null) {
			dispDesc.append(getDescription());
		}
		return dispDesc.toString();
	}

	public void setDispDescription(String dispDescription) {
		this.dispDescription = dispDescription;
	}

	public String getDispTimeOfDay() {
		if (timeOfDay != null) {
			if (timeOfDay.equalsIgnoreCase("M")) {
				dispTimeOfDay = "Morning";
			} else if (timeOfDay.equalsIgnoreCase("A")) {
				dispTimeOfDay = "Afternoon";
			} else if (timeOfDay.equalsIgnoreCase("E")) {
				dispTimeOfDay = "Evening";
			} else {
				dispTimeOfDay = "Night";
			}
		}

		return dispTimeOfDay;
	}

	public void setDispTimeOfDay(String dispTimeOfDay) {
		this.dispTimeOfDay = dispTimeOfDay;
	}
	
	public Boolean getEditMode() {
		return editMode;
	}
	
	public void setEditMode(Boolean editMode) {
		this.editMode = editMode;
	}
	
	@Override
	public int compareTo(ActivityDetailDTO activityDetail) {
		return this.activityDetailId.compareTo(activityDetail.getActivityDetailId());
	}

	@Override
	public String toString() {
		return "ActivityDetailDTO [activityDetailId=" + activityDetailId + ", repCount=" + repCount + ", description=" + description + ", timeOfDay="
				+ timeOfDay + ", activityType=" + activityType + ", measure=" + measure + ", distanceDuration=" + distanceDuration + ", setCount=" + setCount
				+ ", intensity=" + intensity + ", activityJournalId=" + activityJournalId + ", activityJournal=" + activityJournal + ", dispIntensity="
				+ dispIntensity + ", dispMeasure=" + dispMeasure + ", dispTimeOfDay=" + dispTimeOfDay + ", dispDescription=" + dispDescription + ", dispDesc="
				+ dispDesc + ", editMode=" + editMode + "]";
	}
	
}
