package gov.va.med.mhv.hra.web.controller;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.PropsUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.hra.service.HealthReadinessAssessmentService;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;

@Component
@PropertySources(value = {
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.hra.application.properties"),
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.hra.liferay.properties") })
public class HealthelivingAssessmentController implements Serializable {

	private static final long serialVersionUID = 243945029194034624L;

	private static Logger log = LogManager.getLogger(HealthelivingAssessmentController.class);

	private static final String ERR_PRCS_RQST = "Error Processing request";

	private String userFirstName;
	private String userLastName;
	private gov.va.med.mhv.hla.client.Session hraSession = null;
	private String sessionToken;
	private String currentUserName;
	private String sessionId;

	@Value("${logoutUrl}")
	private String logoutUrl;

	@Value("${appContextroot}")
	private String appContextRoot;

	@Value("${hra.requestTokenTimeout}")
	private int hraRequestTokenTimeout;

	@Value("${hra.requestTokenDelay}")
	private int hraRequestTokenDelay;

	@Value("${hra.assessmentAppAddress}")
	private String hraRedirectAddress;

	@Value("${endpointUrl.hra.ws.proxy}")
	private String hraEndpointUrl;

	@Autowired
	private ObjectMapper mapper;

	@Resource(name = "activityProxy")
	private AccountActivityCreatorService accountActivityService;

	@Resource(name = "hraServiceProxy")
	private HealthReadinessAssessmentService healthReadinessAssessmentService;

	public void authorizeHlaHome(ComponentSystemEvent event) throws IOException {

		log.info("=====authorizeHlaHome()==========");

		PortletSession session = null;

		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			FacesContext context = FacesContext.getCurrentInstance();

			if (request.getUserPrincipal() == null) {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "healtheLivingAssessmentUnauthorized.xhtml");
			} else {
				// get logged-in user screen name
				session = request.getPortletSession();

				sessionId = session.getId();

				currentUserName = (String) session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);

				String patientStr =  (String)session.getAttribute("LIFERAY_SHARED_userprofiledto", PortletSession.APPLICATION_SCOPE);
				log.debug("===patientStr  === "+ patientStr);
				log.debug("===Before getting userProfileDto === "+ (null==mapper));
				UserProfileDTO userProfileDto = mapper.readValue(patientStr, UserProfileDTO.class);

				if (userProfileDto != null) {
					setUserFirstName(userProfileDto.getFirstName());
					setUserLastName(userProfileDto.getLastName());
				}

				if (log.isDebugEnabled()) {
					log.debug("user exists " + currentUserName);
				}

				long start = System.currentTimeMillis();
				if (log.isDebugEnabled()) {
					log.debug("===befere HRA web service call === start " + start);
				}

				hraSession = healthReadinessAssessmentService.getHlaSession(currentUserName, sessionId);

				if (log.isDebugEnabled()) {
					log.debug("===after HRA web service call=== elapsed time " + (System.currentTimeMillis() - start));
				}

				if (null != hraSession) {
					if (log.isDebugEnabled()) {
						log.debug("hraToken : " + hraSession.getToken());
					}
					request.setAttribute("j_password", hraSession.getToken());
					request.setAttribute("j_username", currentUserName);
					request.setAttribute("currentUserLastName", getUserLastName());
				}

				accountActivityService.createAccountActivityLog(this.auditShareDataWithHRAEvent(userProfileDto.getId(),
						ActivityActorTypeEnumeration.SELF,
						true, true,
						ActivityActionTypeEnumeration.ACCESS_HEALTHELIVING_ASSESSMENT.getDescription()));
			}
		} catch (Exception e) {
			log.error("Error in authorizeHlaHome", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}

	private ActivityDTO auditShareDataWithHRAEvent(Long userProfileId, ActivityActorTypeEnumeration actor, boolean accept, Boolean successful, String activityActionType){
		ActivityDTO activity = new ActivityDTO();

		if (accept) {
			activity.setAction(ActivityActionTypeEnumeration.CONTINUE.getDescription());
		} else {
			activity.setAction(ActivityActionTypeEnumeration.CANCEL.getDescription());
		}
		activity.setActivityType(ActivityTypeEnumeration.SHARE.getDescription());
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(actor.getDescription());
		activity.setUserProfileId(userProfileId);
		activity.setStatus(successful);
		activity.setDetailValue(activityActionType);

		return activity;
	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		return context;
	}

	public String getSessionToken() {
		if (hraSession != null && hraSession.getToken() != null) {
			return (String) hraSession.getToken();
		} else {
			return "";
		}
	}

	public void setSessionToken(String sessionToken) {
		this.sessionToken = sessionToken;
	}

	public int getHraRequestTokenTimeout() {
		return hraRequestTokenTimeout;
	}

	public void setHraRequestTokenTimeout(int hraRequestTokenTimeout) {
		this.hraRequestTokenTimeout = hraRequestTokenTimeout;
	}

	public int getHraRequestTokenDelay() {
		return hraRequestTokenDelay;
	}

	public void setHraRequestTokenDelay(int hraRequestTokenDelay) {
		this.hraRequestTokenDelay = hraRequestTokenDelay;
	}

	public String getHraRedirectAddress() {
		return hraRedirectAddress;
	}

	public void setHraRedirectAddress(String hraRedirectAddress) {
		this.hraRedirectAddress = hraRedirectAddress;
	}

	public String getCurrentUserName() {
		return currentUserName;
	}

	public void setCurrentUserName(String currentUserName) {
		this.currentUserName = currentUserName;
	}

	public String getLogoutUrl() {
		return logoutUrl;
	}

	public void setLogoutUrl(String logoutUrl) {
		this.logoutUrl = logoutUrl;
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}

	public void setAppContextRoot(String appContextRoot) {
		this.appContextRoot = appContextRoot;
	}

	public HealthReadinessAssessmentService getHealthReadinessAssessmentService() {
		return healthReadinessAssessmentService;
	}

	public void setHealthReadinessAssessmentService(
			HealthReadinessAssessmentService healthReadinessAssessmentService) {
		this.healthReadinessAssessmentService = healthReadinessAssessmentService;
	}

	public String getUserFirstName() {
		return userFirstName;
	}

	public void setUserFirstName(String userFirstName) {
		this.userFirstName = userFirstName;
	}

	public String getUserLastName() {
		return userLastName;
	}

	public void setUserLastName(String userLastName) {
		this.userLastName = userLastName;
	}

	public gov.va.med.mhv.hla.client.Session getHraSession() {
		return hraSession;
	}

	public void setHraSession(gov.va.med.mhv.hla.client.Session hraSession) {
		this.hraSession = hraSession;
	}

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}
}