package gov.va.med.mhv.hra.data.repository;

import gov.va.med.mhv.hra.data.model.HlaVital;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface HlaVitalRepository extends JpaRepository<HlaVital, Long> {

	/*select * from (
	select * from EVAULT.HLA_VITALS_VW 
	where USER_PROFILE_USER_PROFILE_ID = '1854415' 
	ORDER BY BP_READING DESC, 
	BS_READING DESC,
	BT_READING DESC,
	BW_READING DESC,
	HTR_READING DESC,
	LR_READING DESC,
	POR_READING DESC
	)
	where rownum <= 1
	*/
	@Query("select h " +
		    "from HlaVital h "+
		    "where h.userprofileId = :userId " +
		    "order by h.bpReading desc, h.bsReading desc, h.btReading desc, h.bwReading desc, h.htrReading desc, h.inrReading desc, h.lrReading desc, h.oximeterReading desc")
	public List<HlaVital> getVitals(@Param("userId") Long userId, Pageable page);
}
