package gov.va.med.mhv.hra.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "HLA_VITALS_VW")
public class HlaVital implements Serializable {

	private static final long serialVersionUID = 4901063526685145770L;

	@Id
	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	@Column(name = "BLOOD_PRESSURE_ID")
	private Long bloodPressureId;

	@Column(name = "BP_OPLOCK")
	private Integer bpoplock;

	@Column(name = "BP_DIASTOLIC")
	private Integer diastolic;

	@Column(name = "BP_COMMENTS")
	private String bpComments;

	@Column(name = "BP_READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date bpReading;

	@Column(name = "BP_SYSTOLIC")
	private Integer systolic;

	@Column(name = "BLOOD_SUGAR_ID")
	private Long bloodSugarId;

	@Column(name = "BLOOD_SUGAR_COUNT")
	private Integer bloodSugarCount;

	@Column(name = "BS_OPLOCK")
	private Integer bsoplock;

	@Column(name = "BS_COMMENTS")
	private String bsComments;

	@Column(name = "BS_TESTING_METHOD")
	private String testingMethod;

	@Column(name = "BS_READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date bsReading;

	@Column(name = "BODY_TEMPERATURE_ID")
	private Long bodyTempId;

	@Column(name = "BT_OPLOCK")
	private Integer btoplock;

	@Column(name = "BT_READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date btReading;

	@Column(name = "BT_COMMENTS")
	private String btComments;

	@Column(name = "BODY_TEMP_METHOD")
	private String bodyTemperatureMethod;

	@Column(name = "BODY_TEMPERATURE")
	private BigDecimal bodyTemperature;

	@Column(name = "BODY_TEMP_MEASURE")
	private String measure;

	@Column(name = "BODY_WEIGHT_ID")
	private Long bodyWeightId;

	@Column(name = "BW_OPLOCK")
	private Integer bwoplock;

	@Column(name = "BODY_WEIGHT")
	private BigDecimal bodyweight;

	@Column(name = "BW_COMMENTS")
	private String bwComments;

	@Column(name = "BODY_WEIGHT_MEASURE")
	private String bodyweightMeasure;

	@Column(name = "BW_READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date bwReading;

	@Column(name = "HEART_RATE_ID")
	private Long heartRateId;

	@Column(name = "HTR_OPLOCK")
	private Integer htroplock;

	@Column(name = "HTR_COMMENTS")
	private String htrComments;

	@Column(name = "HEART_RATE")
	private Integer heartRate;

	@Column(name = "HTR_READING")
	private Date htrReading;

	@Column(name = "INR_ID")
	private Long inrId;

	@Column(name = "INR_OPLOCK")
	private Integer inroplock;

	@Column(name = "INR_COMMENTS")
	private String inrComments;

	@Column(name = "INR_READING")
	private Date inrReading;

	@Column(name = "INR")
	private BigDecimal inr;

	@Column(name = "LOW_END_TARGET_RANGE")
	private String lowendTargetRange;

	@Column(name = "HIGH_END_TARGET_RANGE")
	private String highendTragetRange;

	@Column(name = "INR_LOCATION")
	private String inrLocation;

	@Column(name = "INR_PROVIDER")
	private String inrProvider;

	@Column(name = "LIPIDS_ID")
	private Long lipidsId;

	@Column(name = "LR_OPLOCK")
	private Integer lroplock;

	@Column(name = "LR_COMMENTS")
	private String lrComments;

	@Column(name = "LR_READING")
	private Date lrReading;

	@Column(name = "LR_PROVIDER")
	private String lrProvider;

	@Column(name = "LR_LOCATION")
	private String lrLocation;

	@Column(name = "LR_FAST")
	private String fast;

	@Column(name = "LR_TOTAL")
	private BigDecimal total;

	@Column(name = "LR_HDL")
	private BigDecimal hdl;

	@Column(name = "LR_LDL")
	private BigDecimal ldl;

	@Column(name = "LR_TRIGLYCERIDES")
	private BigDecimal triglycerides;

	@Column(name = "PULSE_OXIMETRY_ID")
	private Long pulseOximetryId;

	@Column(name = "POR_OPLOCK")
	private Integer poroplock;

	@Column(name = "POR_COMMENTS")
	private String porComments;

	@Column(name = "SUPP_OXYGEN_DEVICE")
	private String suppOxygenDevice;

	@Column(name = "OXYGEN_SETTING")
	private Integer oxygenSetting;

	@Column(name = "POR_RESPIRATORY_RATE")
	private Integer respiratoryRate;

	@Column(name = "OXIMETER_READING")
	private Integer oximeterReading;

	@Column(name = "POR_OTHER_SYMPTOMS")
	private String otherSymptoms;

	@Column(name = "POR_SYMPTOMS")
	private String symptoms;

	@Column(name = "POR_READING")
	private Date porReading;

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public Long getBloodPressureId() {
		return bloodPressureId;
	}

	public void setBloodPressureId(Long bloodPressureId) {
		this.bloodPressureId = bloodPressureId;
	}

	public Integer getBpoplock() {
		return bpoplock;
	}

	public void setBpoplock(Integer bpoplock) {
		this.bpoplock = bpoplock;
	}

	public Integer getDiastolic() {
		return diastolic;
	}

	public void setDiastolic(Integer diastolic) {
		this.diastolic = diastolic;
	}

	public String getBpComments() {
		return bpComments;
	}

	public void setBpComments(String bpComments) {
		this.bpComments = bpComments;
	}

	public Date getBpReading() {
		return bpReading;
	}

	public void setBpReading(Date bpReading) {
		this.bpReading = bpReading;
	}

	public Integer getSystolic() {
		return systolic;
	}

	public void setSystolic(Integer systolic) {
		this.systolic = systolic;
	}

	public Long getBloodSugarId() {
		return bloodSugarId;
	}

	public void setBloodSugarId(Long bloodSugarId) {
		this.bloodSugarId = bloodSugarId;
	}

	public Integer getBloodSugarCount() {
		return bloodSugarCount;
	}

	public void setBloodSugarCount(Integer bloodSugarCount) {
		this.bloodSugarCount = bloodSugarCount;
	}

	public Integer getBsoplock() {
		return bsoplock;
	}

	public void setBsoplock(Integer bsoplock) {
		this.bsoplock = bsoplock;
	}

	public String getBsComments() {
		return bsComments;
	}

	public void setBsComments(String bsComments) {
		this.bsComments = bsComments;
	}

	public String getTestingMethod() {
		return testingMethod;
	}

	public void setTestingMethod(String testingMethod) {
		this.testingMethod = testingMethod;
	}

	public Date getBsReading() {
		return bsReading;
	}

	public void setBsReading(Date bsReading) {
		this.bsReading = bsReading;
	}

	public Long getBodyTempId() {
		return bodyTempId;
	}

	public void setBodyTempId(Long bodyTempId) {
		this.bodyTempId = bodyTempId;
	}

	public Integer getBtoplock() {
		return btoplock;
	}

	public void setBtoplock(Integer btoplock) {
		this.btoplock = btoplock;
	}

	public Date getBtReading() {
		return btReading;
	}

	public void setBtReading(Date btReading) {
		this.btReading = btReading;
	}

	public String getBtComments() {
		return btComments;
	}

	public void setBtComments(String btComments) {
		this.btComments = btComments;
	}

	public String getBodyTemperatureMethod() {
		return bodyTemperatureMethod;
	}

	public void setBodyTemperatureMethod(String bodyTemperatureMethod) {
		this.bodyTemperatureMethod = bodyTemperatureMethod;
	}

	public BigDecimal getBodyTemperature() {
		return bodyTemperature;
	}

	public void setBodyTemperature(BigDecimal bodyTemperature) {
		this.bodyTemperature = bodyTemperature;
	}

	public String getMeasure() {
		return measure;
	}

	public void setMeasure(String measure) {
		this.measure = measure;
	}

	public Long getBodyWeightId() {
		return bodyWeightId;
	}

	public void setBodyWeightId(Long bodyWeightId) {
		this.bodyWeightId = bodyWeightId;
	}

	public Integer getBwoplock() {
		return bwoplock;
	}

	public void setBwoplock(Integer bwoplock) {
		this.bwoplock = bwoplock;
	}

	public BigDecimal getBodyweight() {
		return bodyweight;
	}

	public void setBodyweight(BigDecimal bodyweight) {
		this.bodyweight = bodyweight;
	}

	public String getBwComments() {
		return bwComments;
	}

	public void setBwComments(String bwComments) {
		this.bwComments = bwComments;
	}

	public String getBodyweightMeasure() {
		return bodyweightMeasure;
	}

	public void setBodyweightMeasure(String bodyweightMeasure) {
		this.bodyweightMeasure = bodyweightMeasure;
	}

	public Date getBwReading() {
		return bwReading;
	}

	public void setBwReading(Date bwReading) {
		this.bwReading = bwReading;
	}

	public Long getHeartRateId() {
		return heartRateId;
	}

	public void setHeartRateId(Long heartRateId) {
		this.heartRateId = heartRateId;
	}

	public Integer getHtroplock() {
		return htroplock;
	}

	public void setHtroplock(Integer htroplock) {
		this.htroplock = htroplock;
	}

	public String getHtrComments() {
		return htrComments;
	}

	public void setHtrComments(String htrComments) {
		this.htrComments = htrComments;
	}

	public Integer getHeartRate() {
		return heartRate;
	}

	public void setHeartRate(Integer heartRate) {
		this.heartRate = heartRate;
	}

	public Date getHtrReading() {
		return htrReading;
	}

	public void setHtrReading(Date htrReading) {
		this.htrReading = htrReading;
	}

	public Long getInrId() {
		return inrId;
	}

	public void setInrId(Long inrId) {
		this.inrId = inrId;
	}

	public Integer getInroplock() {
		return inroplock;
	}

	public void setInroplock(Integer inroplock) {
		this.inroplock = inroplock;
	}

	public String getInrComments() {
		return inrComments;
	}

	public void setInrComments(String inrComments) {
		this.inrComments = inrComments;
	}

	public Date getInrReading() {
		return inrReading;
	}

	public void setInrReading(Date inrReading) {
		this.inrReading = inrReading;
	}

	public BigDecimal getInr() {
		return inr;
	}

	public void setInr(BigDecimal inr) {
		this.inr = inr;
	}

	public String getLowendTargetRange() {
		return lowendTargetRange;
	}

	public void setLowendTargetRange(String lowendTargetRange) {
		this.lowendTargetRange = lowendTargetRange;
	}

	public String getHighendTragetRange() {
		return highendTragetRange;
	}

	public void setHighendTragetRange(String highendTragetRange) {
		this.highendTragetRange = highendTragetRange;
	}

	public String getInrLocation() {
		return inrLocation;
	}

	public void setInrLocation(String inrLocation) {
		this.inrLocation = inrLocation;
	}

	public String getInrProvider() {
		return inrProvider;
	}

	public void setInrProvider(String inrProvider) {
		this.inrProvider = inrProvider;
	}

	public Long getLipidsId() {
		return lipidsId;
	}

	public void setLipidsId(Long lipidsId) {
		this.lipidsId = lipidsId;
	}

	public Integer getLroplock() {
		return lroplock;
	}

	public void setLroplock(Integer lroplock) {
		this.lroplock = lroplock;
	}

	public String getLrComments() {
		return lrComments;
	}

	public void setLrComments(String lrComments) {
		this.lrComments = lrComments;
	}

	public Date getLrReading() {
		return lrReading;
	}

	public void setLrReading(Date lrReading) {
		this.lrReading = lrReading;
	}

	public String getLrProvider() {
		return lrProvider;
	}

	public void setLrProvider(String lrProvider) {
		this.lrProvider = lrProvider;
	}

	public String getLrLocation() {
		return lrLocation;
	}

	public void setLrLocation(String lrLocation) {
		this.lrLocation = lrLocation;
	}

	public String getFast() {
		return fast;
	}

	public void setFast(String fast) {
		this.fast = fast;
	}

	public BigDecimal getTotal() {
		return total;
	}

	public void setTotal(BigDecimal total) {
		this.total = total;
	}

	public BigDecimal getHdl() {
		return hdl;
	}

	public void setHdl(BigDecimal hdl) {
		this.hdl = hdl;
	}

	public BigDecimal getLdl() {
		return ldl;
	}

	public void setLdl(BigDecimal ldl) {
		this.ldl = ldl;
	}

	public BigDecimal getTriglycerides() {
		return triglycerides;
	}

	public void setTriglycerides(BigDecimal triglycerides) {
		this.triglycerides = triglycerides;
	}

	public Long getPulseOximetryId() {
		return pulseOximetryId;
	}

	public void setPulseOximetryId(Long pulseOximetryId) {
		this.pulseOximetryId = pulseOximetryId;
	}

	public Integer getPoroplock() {
		return poroplock;
	}

	public void setPoroplock(Integer poroplock) {
		this.poroplock = poroplock;
	}

	public String getPorComments() {
		return porComments;
	}

	public void setPorComments(String porComments) {
		this.porComments = porComments;
	}

	public String getSuppOxygenDevice() {
		return suppOxygenDevice;
	}

	public void setSuppOxygenDevice(String suppOxygenDevice) {
		this.suppOxygenDevice = suppOxygenDevice;
	}

	public Integer getOxygenSetting() {
		return oxygenSetting;
	}

	public void setOxygenSetting(Integer oxygenSetting) {
		this.oxygenSetting = oxygenSetting;
	}

	public Integer getRespiratoryRate() {
		return respiratoryRate;
	}

	public void setRespiratoryRate(Integer respiratoryRate) {
		this.respiratoryRate = respiratoryRate;
	}

	public Integer getOximeterReading() {
		return oximeterReading;
	}

	public void setOximeterReading(Integer oximeterReading) {
		this.oximeterReading = oximeterReading;
	}

	public String getOtherSymptoms() {
		return otherSymptoms;
	}

	public void setOtherSymptoms(String otherSymptoms) {
		this.otherSymptoms = otherSymptoms;
	}

	public String getSymptoms() {
		return symptoms;
	}

	public void setSymptoms(String symptoms) {
		this.symptoms = symptoms;
	}

	public Date getPorReading() {
		return porReading;
	}

	public void setPorReading(Date porReading) {
		this.porReading = porReading;
	}
}
