package gov.va.med.mhv.hra.util;

import gov.va.med.mhv.hra.exception.MHVRuntimeException;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DateUtil {
	
	private static Logger log = LogManager.getLogger(DateUtil.class);

	public static XMLGregorianCalendar convertDate(Date date) {
		XMLGregorianCalendar xmlDate = null;
		try {
			GregorianCalendar gc = new GregorianCalendar();
			gc.setTime(date);
			xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
		} catch (DatatypeConfigurationException e) {
			log.error("Error in convertDate ", e);
			throw new MHVRuntimeException("Error in convertDate ", e);
		}
		
		return xmlDate;
	}
	
	public static Calendar dateToCal(Date date) {
		Calendar cal = null;
		try {
			cal = Calendar.getInstance();
			cal.setTime(date);
		} catch (Exception e) {
			log.error("Error in dateToCal ", e);
			throw new MHVRuntimeException("Error in dateToCal ", e);
		}
		
		return cal;
	}
}
