package gov.va.med.mhv.hra.service;

import gov.va.med.mhv.hla.client.HealthExtract;
import gov.va.med.mhv.hla.client.Session;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/")
@Service("healthReadinessAssessmentService")
public interface HealthReadinessAssessmentService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/gethlasession/{userName}/{sessionId}")
	public Session getHlaSession(@PathParam("userName") String userName, @PathParam("sessionId") String sessionId);
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/populateHealthExtract/{userProfileId}")
	public HealthExtract populateHealthExtract(@PathParam("userProfileId") Long userProfileId);
}
