package gov.va.med.mhv.sso;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.FieldTestEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.sso.SystemDownException.ErrorCodeEnum;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

/**
 * Created by dnebinger on 10/26/15.
 */
public class LegacyAutoLogin implements AutoLogin {

	private static final Log logger = LogFactoryUtil.getLog(LegacyAutoLogin.class);

	private static final Object HTTP_SESSION_ERROR = "java.io.IOException: Unable to access the clients http session";

	public static final String ATTR_SCREEN_NAME = "screenName";
	public static final String ATTR_USER_PROFILE = "userProfile";
	public static final String ATTR_PATIENT = "patient";
	public static final String ATTR_SHOW_DELEGATE_USER_TEXT = "showDelegateUserText";
	public static final String ATTR_DELEGATE_ID = "delegateID";			// The user that can act in behalf of a delegator
	public static final String ATTR_DELEGATOR_IDS = "delegatorIDsList";	// The users that are allowing the delegate act on their behalf
	private static final String ATTR_MHV_API_ERROR_CODE = "mhvapiErrorCode";

	// Values used the in the 'status' column of the 'ipa' table in the database
	private static final String DB_VAL_AUTHENTICATED = "Authenticated";
	private static final String DB_VAL_UNAUTHENTICATED = "Unauthenticated";

	public static final String VAR_USER_ROLE = "MHV_VAR";

	private UserMgmtService userMgmtService = null;

	private AccountValidatorService accountValidatorService;



	/**
	 * handleException: Handles the exception reported during the auto login process.
	 * @param request
	 * @param response
	 * @param e
	 * @return String The array of login details.
	 * @throws AutoLoginException
	 */
	public String[] handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws AutoLoginException {
		logger.error("Error encountered by auto login process: " + e.getMessage(), e);

		// now we'll just return null so that it does not do any auto login stuff:

		return null;
	}

	/**
	 * login: Handles the actual auto-login process.
	 * @param request
	 * @param response
	 * @return The array of login details.
	 * @throws AutoLoginException
	 */
	@Override
	public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
		String[] credentials = null;

		if(logger.isDebugEnabled()) {
			logger.debug("Entering login method.");
			logger.debug("Remote Address: " + request.getRemoteAddr());
		}

		long companyId = PortalUtil.getCompanyId(request);

		HttpSession session = request.getSession();
		ObjectMapper mapper = new ObjectMapper();


		try {
			User user = null;

			String username = (String)request.getAttribute("MHV_EA_UNAME");
			String csid = (String)request.getAttribute("MHV_EA_CSID");
			String userHash = (String)request.getAttribute("MHV_EA_HASH");
			String icn = (String)request.getAttribute("MHV_EA_ICN");
			String va_eauth_isdelegate = (String)request.getAttribute("MHV_EA_IS_DELEGATE");
			boolean isDelegate = "true".equals(va_eauth_isdelegate);
			Long userID = null;

			// TODO - debug only - remove when done with dev work
			if (username != null) {
				System.out.println("LegacyAutoLogin:  login():  #############  username            = " + username);
				System.out.println("LegacyAutoLogin:  login():  #############  icn                 = " + icn);
				System.out.println("LegacyAutoLogin:  login():  #############  va_eauth_isdelegate = " + va_eauth_isdelegate);
			}

			
			logger.debug("UserName: "+ username);

			if(username !=null && username.length() > 0) {
				user = UserLocalServiceUtil.getUserByScreenName(companyId, username);

				if(user != null) {
					if(logger.isDebugEnabled() && user != null) {
						logger.debug(String.format("Liferay User Found having ID: %d and Screen Name: %s", user.getUserId(), user.getScreenName()));
						logger.debug("User ICN: " + icn);
						logger.debug("User Hash: " + userHash);
						logger.debug("User CSID: " + csid);
					}

					session.setAttribute(ATTR_SCREEN_NAME, username);

					this.isUserInactive(username);
					credentials = new String[] {String.valueOf(user.getUserId()), user.getPassword(), String.valueOf(user.isPasswordEncrypted())};

					UserProfileDTO authenticatedMhvUserProfile = this.getUserProfile(username);

					if (authenticatedMhvUserProfile != null) {

						userID = authenticatedMhvUserProfile.getId();
						session.setAttribute(ATTR_USER_PROFILE, mapper.writeValueAsString(authenticatedMhvUserProfile));

						PatientDTO authenticateMhvPatient = (authenticatedMhvUserProfile != null)
								? this.getPatient(authenticatedMhvUserProfile.getId()) : null;

						if (authenticateMhvPatient != null) {
							session.setAttribute(ATTR_PATIENT, mapper.writeValueAsString(authenticateMhvPatient));
						}

						this.doPostLoginUpdateUser(authenticatedMhvUserProfile.getId());
						
						if(hasVARAccess(authenticateMhvPatient)) {	
							System.out.println(" *** ABOUT TO SET VAR ROLE ************");
							session.setAttribute(VAR_USER_ROLE, VAR_USER_ROLE);
							if(logger.isInfoEnabled())
								logger.info("User Profile : " + authenticatedMhvUserProfile.getUserName() + " is set for VAR ACCESS ");
						}
						

					}




				}


				// Assumes, through observational evidence, that the 'username' variable is not-null only when
				// the user has just logged in via SSOe.

				// If this user is a delegate user, and if the user has the 'DelegateFieldTester' field tester role'
				// or the 'DelegateFieldTester' field tester role has gone national, then we need to put a list of
				// this user's delegators into the session as an attribute.
				// Each delegator must meet 3 conditions: Is active, has accepted the terms, and is IPAed
				if (isDelegate) {

					// Find out if the user has the DELEGATE_FIELD_TESTER role.
					FieldTestDTO fieldTestDTO = getDelegateFieldTesterDTO(username);
					Boolean isDelegateFieldTester = fieldTestDTO != null ? new Boolean(true) : new Boolean(false);
					System.out.println("LegacyAutoLogin:  login():  #############  isDelegateFieldTester             = " + isDelegateFieldTester);

					// Find out if the DELEGATE_FIELD_TESTER role has gone national.
					Boolean isDelegateFieldTesterRoleNational = fieldTestDTO != null ? fieldTestDTO.getIsNational() : new Boolean(false);
					System.out.println("LegacyAutoLogin:  login():  #############  isDelegateFieldTesterRoleNational = " + isDelegateFieldTesterRoleNational);

					// Set a flag attribute to signal whether some text, which indicates that this user is a
					// delegate user, should be shown in the login portlet area of the UI.
					if (isDelegateFieldTester && !isDelegateFieldTesterRoleNational) {
						session.setAttribute(ATTR_SHOW_DELEGATE_USER_TEXT, new Boolean(isDelegate));
					}
					System.out.println("LegacyAutoLogin:  login():  #############  ATTR_SHOW_DELEGATE_USER_TEXT = " + session.getAttribute(ATTR_SHOW_DELEGATE_USER_TEXT));

					if (isDelegateFieldTester || isDelegateFieldTesterRoleNational) {

						// Get this user's delegators
						List<PatientDTO> delegators = getDelegatorsForUser(icn);

						System.out.println("LegacyAutoLogin:  login():  #############  Evaluate delegators and set list as attributes");
						System.out.println("LegacyAutoLogin:  login():  ############# ----------------------------");

						// Evaluate delegators and add to session as attribute
						List<String> delegatorIDsList = new ArrayList<String>();
						for(PatientDTO delegator: delegators) {
							System.out.println("LegacyAutoLogin:  login():  #############  delegator username      = " + delegator.getUserProfile().getUserName());
							System.out.println("LegacyAutoLogin:  login():  #############  delegator Profile ID    = " + delegator.getUserProfile().getId());
							System.out.println("LegacyAutoLogin:  login():  #############  delegator Patient ID    = " + delegator.getId());

							// Get conditions with as little overhead as possible
							Boolean acceptedTerms = delegator.getUserProfile().getAcceptTerms();
							Boolean isInactive = false;
							String status = DB_VAL_UNAUTHENTICATED;
							if (acceptedTerms) {
								isInactive = getAccountValidatorService().isUserInactive(delegator.getUserProfile().getUserName());
							}
							if (!isInactive) {
								status = getAccountValidatorService().getAuthenticationForPatient(delegator.getId()).getStatus();
							}

							System.out.println("LegacyAutoLogin:  login():  #############  delegator acceptedTerms = " + acceptedTerms + "  (mock)");
							System.out.println("LegacyAutoLogin:  login():  #############  delegator isInactive    = " + isInactive + "  (real)");
							System.out.println("LegacyAutoLogin:  login():  #############  delegator status        = " + status + "  (real)");

							// Check conditions
							if (!isInactive && acceptedTerms && DB_VAL_AUTHENTICATED.equals(status)) {
								delegatorIDsList.add(delegator.getUserProfile().getId().toString());
								System.out.println("LegacyAutoLogin:  login():  #############  ** Added delegator with ID" + delegator.getUserProfile().getId().toString());
							}
							System.out.println("LegacyAutoLogin:  login():  ############# ----------------------------");
						}

						// Get the user profile ID if we don't have it already
						if (userID == null) {
							try {
								userID = getUserProfile(username).getId();
							}
							catch (Exception e) {
								// Do nothing
							}
						}

					 	System.out.println("LegacyAutoLogin:  login():  #############  Set attribute  ATTR_DELEGATE_ID       = " + userID);
					 	String listOfIDs = "[";
						for (int i=0; i<delegatorIDsList.size(); i++) {
							listOfIDs = listOfIDs + delegatorIDsList.get(i);
							if (delegatorIDsList.size()>=2 && i<delegatorIDsList.size()-1) {
								listOfIDs = listOfIDs + ", ";
							}
						}
						listOfIDs = listOfIDs + "]";
						System.out.println("LegacyAutoLogin:  login():  #############  Set attribute  ATTR_DELEGATOR_IDSatus = " + listOfIDs);

						// Set the attributes
						session.setAttribute(ATTR_DELEGATE_ID,  userID);
						session.setAttribute(ATTR_DELEGATOR_IDS, delegatorIDsList);
					}
				}
			}
		} catch (AutoLoginException ale) {
			if(session != null && ale.getCause() instanceof SystemDownException) {
				session.setAttribute(ATTR_MHV_API_ERROR_CODE, ((SystemDownException)ale.getCause()).getErrorCode());
			}
			throw ale;

		}catch (Exception e) {
			logger.error("LegacyAutoLogin Exception: " + e.getMessage(), e);
			throw new AutoLoginException("Error processing LegacyAutoLogin.", e);
		}

		if(logger.isDebugEnabled()) {
			logger.debug("Exiting login method.");
		}

//		credentials[0] = String.valueOf(10728);
//		credentials[1] = "AAAAoAAB9AC1H7t95P/IMQxT9eyUjojAsDk53jaPEW7PCdcn";
//		credentials[2] = Boolean.TRUE.toString();

		return credentials;
	}

	/**
	 * Returns a list of delegators that have allowed the delegate (the given <code>userICN</code>) to
	 * act in their behalf.
	 * @param userICN	The ICN of the delegate user, which is the user that is logging in.
	 * @return			A list of delegators in the form of <code>PatientDTO</code> objects.
	 */
	private List<PatientDTO> getDelegatorsForUser(String userICN) {
		// TODO - Make 1305 MVI call
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  #############  Mock 1305 MVI call");

		// TODO - The following is only temp code for dev until the MVI call works
		List<PatientDTO> delegators = new ArrayList<PatientDTO>();

		// Test delegator 1
		UserProfileDTO userProfileDto1 = new UserProfileDTO();
		userProfileDto1.setId(new Long(49680));
		userProfileDto1.setUserName("ipa007");
		userProfileDto1.setAcceptTerms(true);

		PatientDTO patientDTO1 = new PatientDTO();
		patientDTO1.setId(new Long(49681));
		patientDTO1.setUserProfile(userProfileDto1);
		delegators.add(patientDTO1);

		// Test delegator 2
		UserProfileDTO userProfileDto2 = new UserProfileDTO();
		userProfileDto2.setId(new Long(45718));
		userProfileDto2.setUserName("ipa008");
		userProfileDto2.setAcceptTerms(true);

		PatientDTO patientDTO2 = new PatientDTO();
		patientDTO2.setId(new Long(45719));
		patientDTO2.setUserProfile(userProfileDto2);
		delegators.add(patientDTO2);

		// Test delegator 3
		UserProfileDTO userProfileDto3 = new UserProfileDTO();
		userProfileDto3.setId(new Long(45353));
		userProfileDto3.setUserName("ipa022");
		userProfileDto3.setAcceptTerms(true);

		PatientDTO patientDTO3 = new PatientDTO();
		patientDTO3.setId(new Long(45354));
		patientDTO3.setUserProfile(userProfileDto3);
		delegators.add(patientDTO3);

		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO1.getUserProfile().getId()          = " + patientDTO1.getUserProfile().getId());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO1.getUserProfile().getUserName()    = " + patientDTO1.getUserProfile().getUserName());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO1.getUserProfile().getAcceptTerms() = " + patientDTO1.getUserProfile().getAcceptTerms());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():              #############");
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO2.getUserProfile().getId()          = " + patientDTO2.getUserProfile().getId());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO2.getUserProfile().getUserName()    = " + patientDTO2.getUserProfile().getUserName());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO2.getUserProfile().getAcceptTerms() = " + patientDTO2.getUserProfile().getAcceptTerms());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():              #############");
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO3.getUserProfile().getId()          = " + patientDTO3.getUserProfile().getId());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO3.getUserProfile().getUserName()    = " + patientDTO3.getUserProfile().getUserName());
		System.out.println("LegacyAutoLogin:  getDelegatorsForUser():  mock setup: #############  patientDTO3.getUserProfile().getAcceptTerms() = " + patientDTO3.getUserProfile().getAcceptTerms());

		return delegators;
	}

	private UserProfileDTO getUserProfile(String screenName) throws AutoLoginException {
		UserProfileDTO userProfile = null;
         try {

             userProfile = getUserManagementService().getUserProfile(screenName);

         } catch (Exception ex) {
        	 ex.printStackTrace();
                         if (!HTTP_SESSION_ERROR.equals(ex.getMessage())) {
                                         logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_USER_PROFILE.toString()+", Screename:"+ screenName, ex);
                                         throw new AutoLoginException("Error getting User Profile from User Management Service.",
                                                                         new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_USER_PROFILE, ex));

                         }
         }

         return userProfile;
     }


	private PatientDTO getPatient(Long userProfileId) throws AutoLoginException {
        try {
            return getUserManagementService().getPatient(userProfileId);
        } catch (Exception ex) {
            logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_PATIENT.toString(), ex);
            throw new AutoLoginException("Error getting Patient from User Management Service.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_PATIENT, ex));
        }
	}

	private void doPostLoginUpdateUser(Long userProfileId) throws AutoLoginException {
        try {
                        this.userMgmtService.postLoginUpdateUser(userProfileId);
        } catch (MHVException ex) {
        	logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE.toString(), ex);
            throw new AutoLoginException("Error performing post login updates for User.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE, ex));
        }
	}

	private UserMgmtService getUserManagementService() {
        if (this.userMgmtService == null) {
        	this.userMgmtService = (UserMgmtService) ApplicationContextProvider.getApplicationContext().getBean("userMgmtServiceProxy");
        }
        return this.userMgmtService;
	}

	private void isUserInactive(String screenName) throws AutoLoginException {
        try {
            if (getAccountValidatorService().isUserInactive(screenName)) {
            	logger.error(screenName + ":: is deactivated");
                throw new AutoLoginException(new UserDeactivatedException(String.format("User: %s is not active.", screenName)));
            }
        } catch (MHVException e) {
            // something failed with the web service. fail authentication.
        	logger.error(ErrorCodeEnum.ACCOUNT_VALIDATOR_FAILURE_IS_USER_INACTIVE.toString(), e);
            throw new AutoLoginException("Error getting User Profile from User Management Service.", new SystemDownException(ErrorCodeEnum.ACCOUNT_VALIDATOR_FAILURE_IS_USER_INACTIVE, e));
        }
	}

	private AccountValidatorService getAccountValidatorService() {
        if (this.accountValidatorService == null) {
            this.accountValidatorService = (AccountValidatorService) ApplicationContextProvider.getApplicationContext().getBean("accountValidatorServiceProxy");
        }

        return this.accountValidatorService;
	}


	/**
	 * Used to determine whether the given user is a 'Delegate Field Tester' or not, and returns a
	 * <code>FieldTestDTO<code> object that represents that role.
	 * @param userName	The username of the user we are checking on.
	 * @return			A <code>FieldTestDTO<code> object if the user has the 'Delegate Field Tester' role,
	 * 					<code>null<code> otherwise.
	 * @throws AutoLoginException
	 */
	private FieldTestDTO getDelegateFieldTesterDTO(String userName) throws AutoLoginException  {
		FieldTestDTO fieldTestDTO = null;

		try {
			if (userName != null) {
				List<FieldTestDTO> fieldTesterRoles = getUserManagementService().getFieldTestGroupsByUserName(userName);

				if (fieldTesterRoles != null) {
					for (FieldTestDTO fieldTesterRole: fieldTesterRoles) {
						if (FieldTestEnum.DELEGATE_FIELD_TESTER.getRole().equals(fieldTesterRole.getRole())) {
							fieldTestDTO = fieldTesterRole;
							break;
						}
					}
				}
			}
		}
		catch (MHVException me) {
			// Assume that any error getting the user's field test roles means that the user
			// is not set up as a 'Delegate Field Tester'
		}
		catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage());
			throw new AutoLoginException(new SystemDownException(e));
		}

		return fieldTestDTO;
	}

	private boolean hasVARAccess(PatientDTO patient) {
		boolean hasVarAccess =false;
		try {
			hasVarAccess = getUserManagementService().checkVAREligibilityForPatient(patient.getId());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		
		if(logger.isInfoEnabled())
			logger.info("User Profile id "+patient.getUserProfileId() + " VAR Access status is: " +  hasVarAccess);
		
		return hasVarAccess;
	}


}
