package gov.va.med.mhv.sso;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class FedCredSsoUtil {
	private static final Log logger = LogFactoryUtil.getLog(EAuthGateway.class);
	
	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtServiceProxy;

	public static final String AUTHENTICATED = "Authenticated";
	public static final int PATIENT_CORRELATED = 2;

	public static final String ERROR_PAGE_URL = "errorPage";
	public static final String ERROR_DETAIL = "errorDetail";
	public static final String TRUE_VALUE = "true";
	public static final String FALSE_VALUE = "false";
	public static final String DISPLAY_ONLINE_UPGRADE_ATTRIB = "displayOnlineUpgrade";

	// Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
	public static final String VERSION_INFO_SEARCH_JOB = "family=Job -Search for user traits";
	public static final String VERSION_INFO_JOB_UNLINK = "Job -Unlink Correlation";
	public static final String VERSION_INFO_ID = "^PI^200MH^USVHA";
	public static final String INVALID_EDIPI_MSG = "Invalid EDIPI";
	public static final String MULTIPLE_EDIPIS_MSG = "Multiple EDIPIs";

	public static final String MULTIPLE_ACCOUNT_ERROR_MSG = "Multiple Account Error";
	public static final String DEACTIVATED_ACCOUNT_MSG = "Deactivated Account";
	public static final String EMPTY_CSID_MSG = "CSID is empty";
	public static final String EMPTY_ASSURANCE_LEVEL_MSG = "Empty VA Eauth Assurance Level";
	public static final String INVALID_ASSURANCE_LEVEL_MSG = "Invalid VA Eauth Assurance Level";
	public static final String INVALID_HASH_MSG = "Invalid Hash";
	public static final String NOT_FOUND_ERROR_MSG = "NOT_FOUND on first name, last name birth date or ssn";
	public static final String INVALID_SSN_MSG = "Invalid SSN";
	public static final String INVALID_DOB_MSG = "Invalid Birth Date";
	public static final String INVALID_ICN_MSG = "Invalid ICN";
	public static final String ORC_CSID_MSG = "ORC Logon is not allowed.";
	public static final String ORC_CSP = "2030004";
	public static final String PENDING_UNCORRELATION_MSG = "Pending Uncorrelation or Failed Correlation Status";

	public static final String UTF_8_ENCODING = "UTF-8";
	public static final String HASH_PARAM = "va_eauth_hash";
	public static final String CSID_PARAM = "va_eauth_csid";
	public static final String BIRTH_DATE = "va_eauth_birthdate";
	public static final String FIRST_NAME = "va_eauth_firstname";
	public static final String MIDDLE_NAME = "va_eauth_middleName";
	public static final String LAST_NAME = "va_eauth_lastname";
	public static final String ID = "va_eauth_pnid";
	public static final String ID_TYPE = "va_eauth_pnidtype";
	public static final String GENDER = "va_eauth_gender";
	public static final String DEEP_LINK = "va_eauth_deep_link";
	public static final String DEEP_LINK_ATTR = "deepLink";
	public static final String REALM_NAME = "myrealm";
	public static final String HASH_ATTR = "eauthHash";
	public static final String EAUTH_PORTAL = "eauth.portal";
	public static final String MHV_PORTAL = "/mhvPortal/mhv.portal";
	public static final String LOGIN_TYPE = "loginType";
	public static final String EAUTH = "eauth";
	public static final String EAUTH_ERROR = "eauthError";
	public static final String EDIPI_PARAM = "va_eauth_dodEdiPnId";
	public static final String VA_EAUTH_ASSUR_LEVEL = "va_eauth_assuranceLevel";
	public static final String ICN_PARAM = "va_eauth_icn";
	public static final String ADDRESS1 = "va_eauth_street";
	public static final String CITY = "va_eauth_city";
	public static final String STATE = "va_eauth_state";
	public static final String POSTAL_CODE = "va_eauth_postalcode";
	public static final String COUNTRY = "va_eauth_country";
	public static final String EMAIL = "va_eauth_email";
	public static final String PHONE = "va_eauth_phone";
	public static final String USER_PROFILE_ID = "va_eauth_mhvien";
	public static final String CSP_ONLY = "va_eauth_csponly";
	public static final String VA_ASSURANCE_LEVEL_PROP = "eauth.va.assurance.level";
	public static final String GENERIC_ERROR = "genericError";
	
	private String agreedMinimumAssuranceLevel;

	private boolean useExistingDslogonProcess;

	private String dslogonValue;
	private static Properties props = null;
	
	public void searchInMVIWithEdipi(String edipi,HttpServletResponse response) {
		//if it is successful, I need to return PatientObject
		//if there is an error, we need to go the error page with the specifi message
		
//		mviPatRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory
//				.createMviIntegrationServiceDelegate()
//				.searchPersonInMVIForDSLogonWithVersion(edipiValue, VERSION_INFO_SEARCH_JOB);
//
//		req.getSession().removeAttribute(MULTIPLE_ACCOUNT_ERROR_ATTRIB);
//		if (mviPatRes.getMessages().hasErrorMessages()) {
//			//addErrorMessage(message);
//			response.sendRedirect(getErrorPageUrl());
//			return null;
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MVI_COMM_ISSUE_VALUE)) {
//			return "MVIErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MviConstants.MULTIPLE_IDS_ERROR)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see
//			// if the user has one active advanced account known to MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account page.
//			request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL,
//					fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//			return "ErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().toString().startsWith(ERROR_VALUE)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see
//			// if the user has one active advanced account known to MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account page.
//
//			// TODO - Uncomment
//			// sendToErrorPage(req, res, icn,
//			// mviPatRes.getValue().toString());
//			// request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL,
//			// fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//			return "ErrorPage";
//		}
//
//		if (mviPatRes.getPatient() != null) {
//			patient = mviPatRes.getPatient();
	}
	
	public String getAgreedMinimumAssuranceLevel() {
		if(agreedMinimumAssuranceLevel == null) {
			agreedMinimumAssuranceLevel = (String)props.get(VA_ASSURANCE_LEVEL_PROP);
		}
		
		return agreedMinimumAssuranceLevel;
	}

	public String getErrorPageUrl() {
		return "eauth-error";
	}

	public String getSplashPageUrl() {
		return "eauth-splash";
	}

	public String getAnonymousUrl() {
		return "eauth-anonymous";
	}

	public String getOnlineAuthenticationUrl() {
		return "eauth-online-authentication";
	}

	public String getMHVLoggedInUrl() {
		return "mhv-partner";
	}
	
	public String getMhvLoginUrl() {
		return "home";
	}

	public String getReauthPageUrl() {
		return "eauth-reauth";
	}
	
	public void addErrorMessage(String message) {
		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, 
			GENERIC_ERROR, message));
	}
	
	public void setAgreedMinimumAssuranceLevel(String agreedMinimumAssuranceLevel) {
		this.agreedMinimumAssuranceLevel = agreedMinimumAssuranceLevel;
	}

	public String getFccxFormUrl() {
		// log.debug("fccxFormUrl*=" );
		// log.debug(props.getProperty("eauthEndpointUrl"));
		// log.debug(props.getProperty("fccxFormUrl"));
		return props.getProperty("fccxFormUrl");
	}

	public void logInfo(Log logger, String message) {
		if (logger.isInfoEnabled()) {
			logger.info(message);
		}
	}

	public Boolean isUserAuthenticated(String username) {
		UserProfileDTO userProfile = getUserProfile(username);
		PatientDTO patient = getPatient(userProfile.getId());

		Set<InPersonAuthenticationDTO> ipas = patient.getIpas();
		InPersonAuthenticationDTO ipa = null;
		if (null != ipas && ipas.size() > 0 && null != ipas.iterator() && ipas.iterator().hasNext()) {
			ipa = ipas.iterator().next();
		} else {
			return false;
		}

		logInfo(logger, "ipa.getStatus() " + ipa.getStatus());

		return (isIpaAuthenticated(patient));
	}

	public Boolean isIpaAuthenticated(PatientDTO patient) {
		Set<InPersonAuthenticationDTO> ipas = patient.getIpas();
		InPersonAuthenticationDTO ipa = null;
		if (null != ipas && ipas.size() > 0 && null != ipas.iterator() && ipas.iterator().hasNext()) {
			ipa = ipas.iterator().next();
		} else {
			return false;
		}

		logInfo(logger, "ipa.getStatus() " + ipa.getStatus());
		return (null != ipa.getStatus() && ipa.getStatus().equals(AUTHENTICATED));
	}

	public Boolean isIpaAuthenticated(InPersonAuthenticationDTO ipa) {
		return (null != ipa.getStatus() && ipa.getStatus().equals(AUTHENTICATED));
	}

	public UserProfileDTO getUserProfile(String userName) {
		logInfo(logger, "Inside Get USerprofile");

		UserProfileDTO userProfile = new UserProfileDTO();
		
		try {
			userProfile = this.userMgmtServiceProxy.getUserProfile(userName);
		} catch (MHVException e) {
			logger.error("Error in getuserprofle:",e);
			FacesContext.getCurrentInstance().addMessage(
					null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", e.getFailureMessage()));
		}
		//successMessage = "success";
		return userProfile;
	}

	public UserProfileDTO getUserProfileByUserProfileId(Long userProfileId) {
		logInfo(logger, "Inside Post Login Action Update User Activity");
		UserProfileDTO userProfile = new UserProfileDTO();
		try {
			userProfile = this.userMgmtServiceProxy.postLoginUpdateUser(userProfileId);
		} catch (MHVException e) {
			logger.error("Error in getuserprofle:",e);
			FacesContext.getCurrentInstance().addMessage(
					null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", e.getFailureMessage()));
		}
		//successMessage = "success";
		return userProfile;
	}
	
	public InPersonAuthenticationDTO retrieveIpaByUserName(String username) {
		UserProfileDTO userProfile = getUserProfile(username);
		PatientDTO patient = getPatient(userProfile.getId());

		Set<InPersonAuthenticationDTO> ipas = patient.getIpas();
		if (null != ipas && ipas.size() > 0 && null != ipas.iterator() && ipas.iterator().hasNext()) {
			return ipas.iterator().next();
		}

		return null;
	}

	public PatientDTO getPatient(Long userProfileId) {
		PatientDTO patientDTO = null;
		if (logger.isInfoEnabled()) {
			logger.debug("Inside Get patient");
		}
		
		try {
			patientDTO = this.userMgmtServiceProxy.getPatient(userProfileId);
		} catch (MHVException e) {
			logger.error("Error in getuserprofle:",e);
			FacesContext.getCurrentInstance().addMessage(
					null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", e.getFailureMessage()));
		}
		//successMessage = "success";
		return patientDTO;
	}

//	public void sendRedirect(String forward, HttpServletResponse response) throws IOException {
//		ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("application.xml");
//		Properties props = (Properties) context.getBean("envProperties");
//		response.sendRedirect(props.getProperty(forward));
//	}

	public boolean goToOnlineAuthenticationPage(PatientDTO patient, HttpServletRequest request) {
		return false;
	}
	
	public boolean goToOnlineAuthenticationPage(String username, HttpServletRequest request)
			throws ServletException, IOException {
		UserProfileDTO userProfile = getUserProfile(username);
		PatientDTO patient = getPatient(userProfile.getId());

//TODO - Uncomment
//	} else if(AuthenticationStatus.getEnum(AuthenticationStatus.UNAUTHENTICATED) == authStatus ||
//			   //JAZZ#32762 US01 REQ#1.2 MHV system shall check the users Authentication status
//			   //is either Unauthenticated or In Process or Pending Data Mismatch.
//			   AuthenticationStatus.getEnum(AuthenticationStatus.INPROCESS) == authStatus ||
//			   AuthenticationStatus.getEnum(AuthenticationStatus.PENDINGDATAMISMATCH) == authStatus) {
//
//					enterInfoLog("The user authStatus:" + authStatus, icn);
//
//					yesNoUpgrade = req.getParameter("doUpgrade");
//					enterInfoLog("doUpgrade:" + yesNoUpgrade, icn);
		
		
		
		// Post: 12.12.x BUC If the User is a VA Patient and/or Veteran, and
		// logged in via DS Logon, then the System will display the upgrade page
		// with all three bullet selections. This flow is captured in the
		// Account Upgrade Using the Electronic Right of Access
		// Request (eRAR) Form BUC. When the user requests to upgrade their
		// account, an AAL entry will be created to record the
		// account upgrade was requested.
		if (retrieveVAFFIProperty(request, CSID_PARAM).equals(dslogonValue)) {
			request.getSession().setAttribute(DISPLAY_ONLINE_UPGRADE_ATTRIB, TRUE_VALUE);
		} else {
			// If the user is a VA Patient, and logged in with any credential,
			// then the System will display
			// the upgrade page with the last two bullet selections.
			if (!userProfile.getIsPatient() && !userProfile.getIsVeteran()) {
				return false;
			}
			request.getSession().setAttribute(DISPLAY_ONLINE_UPGRADE_ATTRIB, FALSE_VALUE);
		}
		
		 //JAZZ #32762 US01 REQ#1.3 The MHV system shall check if the user has
		 //signed the form or
		 //started the electronic upgrade process by checking the "Signed
		 //20-5345a-MHV form online"
		 //field or "Date/Time Start upgrade online" field in the MHV
		// database.
//		 StringServiceResponse vapiiStatusResponse =
//		 gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createUserProfileServiceDelegate().getVapiiFormStatusForUser(
//		 ipa.getPatient().getUserProfile());
//		 //JAZZ #32762 US04 REQ#1.1.2 WhenVAPii is unavailable, refer US05:
//		 VAPii is Unavailable.
//		 if(vapiiStatusResponse.getMessages().hasErrorMessages()) {
//		 enterInfoLog("getVapiiFormStatus has errors:" +
//		 retrieveErrorMessages(vapiiStatusResponse.getMessages()),
//		 ipa.getPatient().getIcn());
//		 request.getSession().setAttribute(DISPLAY_ONLINE_UPGRADE_ATTRIB,
//		 FALSE_VALUE);
//		 request.getSession().setAttribute(DISPLAY_ERROR_ATTRIB,
//		 VAPII_ERRIR_VALUE);
//		 res.sendRedirect(upgrade_url);
//		 } else
//		 if(!VAPII_SUBMITTED_VALUE.equalsIgnoreCase(vapiiStatusResponse.getString()))
//		 {
//		 //JAZZ #32762 US02 REQ#5.2 If the User did not complete the form
//		 process or VAPii does not locate the form, the
//		 //System shall provide a user-friendly message indicating the signed
//		 form was not located within VAPii at the top of the
//		 //Start Upgrading Your My HealtheVet Account Today page.
//		 if(ipa.getStartUpgradeOnlineDateTime()!=null ||
//		 ipa.getSignedFormOnlineDateTime()!=null) {
//		 request.getSession().setAttribute(DISPLAY_ERROR_ATTRIB,
//		 FORM_NOT_FOUND_VALUE);
//		 } else {
//		 //JAZZ #32762 US01 REQ#2 If the users have not started the upgrade
//		 process or signed the eRAR form,
//		 //MHV system shall display the Start Upgrading Your My HealtheVet
//		 Account Today page in MHV.
//		 request.getSession().removeAttribute(DISPLAY_ERROR_ATTRIB);
//		 }
//		 request.getSession().setAttribute("upgradeUsername",
//		 ipa.getPatient().getUserProfile().getUserName());
//		 res.sendRedirect(upgrade_url);
//		 } else
//		 if(VAPII_SUBMITTED_VALUE.equalsIgnoreCase(vapiiStatusResponse.getString()))
//		 {
//		 enterInfoLog("Not Going to the Upgrade page. VAPii Status is
//		 'SUBMITTED' for UserProfileId: " +
//		 ipa.getPatient().getUserProfile().getUserName(),
//		 ipa.getPatient().getIcn());
//		 return false;
//		 }
		return false;
	}

	public void retrieveAllVAFFIPropertiesFromHeader(HttpServletRequest req) {
		retrieveVAFFIProperty(req, HASH_PARAM, true);
		retrieveVAFFIProperty(req, CSID_PARAM, true);
		retrieveVAFFIProperty(req, BIRTH_DATE, true);
		retrieveVAFFIProperty(req, FIRST_NAME, true);
		retrieveVAFFIProperty(req, MIDDLE_NAME, true);
		retrieveVAFFIProperty(req, LAST_NAME, true);
		retrieveVAFFIProperty(req, ID, true);
		retrieveVAFFIProperty(req, ID_TYPE, true);
		retrieveVAFFIProperty(req, GENDER, true);
		retrieveVAFFIProperty(req, DEEP_LINK, true);
		retrieveVAFFIProperty(req, DEEP_LINK_ATTR, true);
		retrieveVAFFIProperty(req, REALM_NAME, true);
		retrieveVAFFIProperty(req, HASH_ATTR, true);
		retrieveVAFFIProperty(req, LOGIN_TYPE, true);
		retrieveVAFFIProperty(req, EDIPI_PARAM, true);
		retrieveVAFFIProperty(req, VA_EAUTH_ASSUR_LEVEL, true);
		retrieveVAFFIProperty(req, ICN_PARAM, true);
		retrieveVAFFIProperty(req, ADDRESS1, true);
		retrieveVAFFIProperty(req, CITY, true);
		retrieveVAFFIProperty(req, STATE, true);
		retrieveVAFFIProperty(req, POSTAL_CODE, true);
		retrieveVAFFIProperty(req, COUNTRY, true);
		retrieveVAFFIProperty(req, EMAIL, true);
		retrieveVAFFIProperty(req, PHONE, true);
		retrieveVAFFIProperty(req, USER_PROFILE_ID, true);
		retrieveVAFFIProperty(req, CSP_ONLY, true);
	}

	public static String formatSSN(String ssn) {
		StringBuffer ssnBuff = new StringBuffer(ssn);
		ssnBuff.insert(3, '-');
		ssnBuff.insert(6, '-');
		return ssnBuff.toString();
	}

	public boolean isEdipiMultiple(String edipi) {
		if ((edipi != null) && !isNotFound(edipi) && edipi.length() == 10 && isDigit(edipi)) {
			String[] edipis = edipi.split(",");
			if (edipis != null && edipis.length > 1) {
				return false;
			}
			return true;
		}
		return false;
	}

	public boolean isEdipiExist(String edipi) {
		if ((edipi != null) && !isNotFound(edipi)) {
			return true;
		}
		return false;
	}

	public String retrieveVAFFIProperty(HttpServletRequest req, String attribute) {
		return retrieveVAFFIProperty(req, attribute, false);
	}

	public String retrieveVAFFIProperty(HttpServletRequest request, String attribute, boolean forced) {
		String trait = null;

		if (forced) {
			trait = request.getParameter(attribute);
			request.getSession().setAttribute(attribute, trait);
		} else {
			trait = (String) request.getSession().getAttribute(attribute);
			if (trait == null) {
				trait = request.getParameter(attribute);
				request.getSession().setAttribute(attribute, trait);
			}
		}

		if (logger.isInfoEnabled()) {
			logger.info("VAFFIProperty:" + attribute + "=" + trait);
		}

		return trait;
	}

	public boolean isNotFound(String str) {
		if (str == null || str.equalsIgnoreCase("NOT_FOUND")) {
			return true;
		}
		return false;
	}

	public boolean isValidCredentialProvider(HttpServletRequest request) {
		String credentialProvider = retrieveVAFFIProperty(request, CSID_PARAM);

		if (isNotFound(credentialProvider)) {
			addErrorMessage(EMPTY_CSID_MSG);
			return false;
		}

		if (retrieveVAFFIProperty(request, CSID_PARAM).equals(ORC_CSP)) {
			addErrorMessage(ORC_CSID_MSG);
			return false;
		}

		return true;
	}

	public boolean isToProcessExistingSSO(HttpServletRequest request) {
		if (useExistingDslogonProcess && retrieveVAFFIProperty(request, CSID_PARAM).equals(dslogonValue)) {
			return true;
		}

		return false;
	}

	public boolean isMinimumAssuranceLevelMet(HttpServletRequest request) throws UnsupportedEncodingException {
		String assuranceLevel = retrieveVAFFIProperty(request, VA_EAUTH_ASSUR_LEVEL);

		assuranceLevel = URLDecoder.decode(retrieveVAFFIProperty(request, VA_EAUTH_ASSUR_LEVEL), UTF_8_ENCODING);

		if (Integer.parseInt(assuranceLevel) >= Integer.parseInt(agreedMinimumAssuranceLevel)) {
			request.getSession().setAttribute(ERROR_DETAIL, INVALID_ASSURANCE_LEVEL_MSG);
			return true;
		}

		return false;
	}

	// public ResponseUtil retrievePatientByUserName(String username) {
	//// UserProfile profile =
	// userProfileService.getUserProfileByUserName(username);
	//// if (profile != null) {
	////
	//// profile.
	//// ResponseUtil res =
	// patientService.getPatientByUserProfileId(profile.getId());
	//// PatientDTO patient = (PatientDTO)res.getPojoObject();
	//// return patient;
	//// }
	//
	// return null;
	// }

	// public ResponseUtil retrieveIpaByPatientId(long patientId) {
	// //TODO - Uncomment
	//// InPersonAuthenticationServiceDelegate ipaDelegate =
	// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createInPersonAuthenticationServiceDelegate();
	//// InPersonAuthenticationServiceResponse ipaServiceResponse =
	// ipaDelegate.getAuthenticationForPatient(patient.getId());
	////
	//// enterInfoLog("ipaServiceResponse.getInPersonAuthentication() != null" +
	// (ipaServiceResponse.getInPersonAuthentication() != null), icn);
	////
	//// if (ipaServiceResponse.getMessages().hasErrorMessages()) {
	//// for (Object item:ipaServiceResponse.getMessages().getErrorMessages()) {
	//// log.error("IPA find action Error: " + item);
	//// }
	//// res.sendRedirect(anonymous_url);
	//// return;
	//// }
	//
	// return null;
	// }

	public boolean isICNValid(String icn) {
		// Jazz #110471 RemoteID Proofing - Use ICN -US02 - If ICN exists then
		// validate the syntax of ICN (17 character ICN.
		// (Format is 10 digits, one alpha letter followed by 6 digits )*
		// (per discussion with IAM on fully qualified ICN)
		if ((icn != null) && !isNotFound(icn) && icn.length() == 17 && isDigit(icn.substring(0, 10))
				&& !isDigit(icn.substring(10, 11)) && isDigit(icn.substring(11, 17))) {
			return true;
		}
		return false;
	}

	public boolean isDigit(String number) {
		char[] numberArray = number.toCharArray();
		for (int i = 0; i < numberArray.length; i++) {
			if (!Character.isDigit(numberArray[i])) {
				return false;
			}
		}
		return true;
	}

	public boolean isUserAccountDeactivated(String username) {
		// TODO - Uncomment
		// boolean result = true;
		//
		// UserProfileServiceDelegate userProfileDelegate =
		// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createUserProfileServiceDelegate();
		// UserProfileServiceResponse upResponse =
		// userProfileDelegate.getProfileForUser(username);
		// if (upResponse.getMessages().hasErrorMessages()) {
		// for (Object item:upResponse.getMessages().getErrorMessages()) {
		// log.error("UserProfile getUserProfileByUsername action Error: " +
		// item);
		// }
		// }
		//
		// if( upResponse.getUserProfile() != null &&
		// upResponse.getUserProfile().getDeactivationReason() == null) {
		// result = false;
		// }
		// if( result == true && log.isInfoEnabled() ) {
		// log.info("Found a deactivated status for user:: " + username + ",
		// Deactivation Reason: " +
		// upResponse.getUserProfile().getDeactivationReason() );
		// }
		//
		// return result;
		return false;
	}

	public void processDeactivatedAccount(PatientDTO patient, HttpServletRequest request)
			throws ServletException, IOException {

		// TODO - Uncomment
		// String versionInfo = "dataEntererId=" + uProfile.getId() +
		// VERSION_INFO_ID + ",family=" +VERSION_INFO_JOB_UNLINK;
		//
		// if(patient != null && removeCorrelation) {
		// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().removeCorrelationInMVIWithVersion(
		// patient, uProfile, "System", versionInfo);
		// }
		//// request.getSession().setAttribute(FEDERATED_CREDENTIAL_ATTRIB,
		// TRUE_VALUE);
		//// request.getSession().setAttribute("displayUpdateButton",
		// TRUE_VALUE);
		//// request.setAttribute("removeTabs", "true");
		// response.sendRedirect(login_url);
	}

	public boolean isEdipiValid(String edipi) {
		if ((edipi != null) && !isNotFound(edipi) && edipi.length() == 10 && isDigit(edipi)) {
			return true;
		}
		return false;
	}

	public String processMiddleName(String middleName) {
		if (isNotFound(middleName)) {
			middleName = "";
		}
		return middleName;
	}

	public String processGender(String gender) {
		if (isNotFound(gender)) {
			gender = "";
		}
		return gender;
	}

	public String processSsn(String ssn) {
		if (ssn.length() == 10) {
			ssn = ssn.substring(1);
		}
		return ssn;
	}

	public boolean isDate(String dateStr) {
		if (dateStr.equalsIgnoreCase("NOT_FOUND")) {
			return false;
		}

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(dateStr.substring(0, 10));
		} catch (Throwable t) {
			t.printStackTrace();
			return false;
		}
		return true;
	}

	public boolean isSsnValid(String ssn, String idType) {
		if (!isDigit(ssn) || ssn.length() != 9 || !idType.equalsIgnoreCase("SSN")) {
			return false;
		}
		return true;
	}

	public UserProfileDTO findUserProfile(String firstName, String lastName, String gender, String sSN,
			String birthDate) {

		// GenderEnumeration genderEnum = null;
		// if(gender != null && gender.length()>0) {
		// if(gender.equalsIgnoreCase(GenderEnumeration.MALE)){
		// genderEnum = GenderEnumeration.getEnum(GenderEnumeration.MALE);
		// }else{
		// genderEnum = GenderEnumeration.getEnum(GenderEnumeration.FEMALE);
		// }
		// }
		//
		// SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		// Date date = null;
		// try {
		// date = sdf.parse(birthDate.substring(0, 10));
		// } catch (ParseException e) {
		// if(logger.isInfoEnabled()){
		// logger.info("Not able to parse date for the user:: " + firstName + "
		// " + lastName + ", birthdate: " + birthDate);
		// }
		// }
		//
		// UserProfileServiceDelegate userProfileDelegate =
		// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createUserProfileServiceDelegate();
		// UserProfileServiceResponse upResponse =
		// userProfileDelegate.getUserProfileForVAAFITraits(firstName, lastName,
		// date, genderEnum);
		// if (upResponse.getMessages().hasErrorMessages()) {
		// for (Object item:upResponse.getMessages().getErrorMessages()) {
		// logger.error("UserProfile getUserProfileForVAAFITraits action Error:
		// " + item);
		// }
		// }
		//
		// UserProfile uProfile = upResponse.getUserProfile();
		// if( uProfile != null ) {
		// if(logger.isInfoEnabled()){
		// logger.info("Found DSLogon user profile:: " + uProfile.getId() + "
		// with user_name:: " + uProfile.getUserName());
		// }
		//
		// /*
		// * Compare SSN right here (SSN could be null for a non patient from
		// evault)
		// */
		// if(uProfile.getSsn() == null || !uProfile.getSsn().replace("-",
		// "").equals(sSN)){
		// if(logger.isInfoEnabled()){
		// logger.info("SSN did not match for DSLogon CSID user for the user
		// profile:: " + uProfile.getId());
		// }
		// uProfile = null;
		// }
		// }

		// return uProfile;
		return null;
	}



	public String determineDeepLinkingPage(HttpServletResponse response) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isUserAccountDeactivated(UserProfileDTO uProfile) {
		// TODO Auto-generated method stub
		return false;
	}

	public void processFacilitiesUpdate(PatientDTO patient) {
		// TODO Auto-generated method stub
		
	}

	public PatientDTO findPatientByIcn(String icn, HttpServletResponse response) {
		//PatientServiceResponse patRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory
		//		.createPatientServiceDelegate().getPatientByIcn(icn);
		return null;
	}

	public void searchInMVIWithIcn(String icn,  HttpServletResponse response) {
//		versionInfo = VERSION_INFO_SEARCH_JOB;
//		mviPatRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory
//				.createMviIntegrationServiceDelegate().searchPersonInMVIByICNWithVersion(icn, versionInfo);
//		
//		req.getSession().removeAttribute(MULTIPLE_ACCOUNT_ERROR_ATTRIB);
//		if (mviPatRes.getMessages().hasErrorMessages()) {
//			// sendToErrorPage(req, res, icn,
//			// retrieveErrorMessages(mviPatRes.getMessages()));
//			return "ErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MVI_COMM_ISSUE_VALUE)) {
//			return "MVIErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MviConstants.MULTIPLE_IDS_ERROR)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to
//			// see if the user has one active advanced account known to
//			// MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account
//			// page.
//			request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL,
//					fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//			return "ErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().toString().startsWith(ERROR_VALUE)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to
//			// see if the user has one active advanced account known to
//			// MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account
//			// page.
//			// req.getSession().setAttribute(ERROR_DETAIL,
//			// mviPatRes.getValue().toString());
//			return "ErrorPage";
//		}
	}

	public String getConnectePageUrl() {
		// TODO Auto-generated method stub
		return "eauth-connect";
	}

	public void searchInMVIWithTraits(String firstName, String middleName, String lastName, String birthDate,
			String gender2, String ssn, HttpServletResponse response) {
//		String versionInfo = fedCredSsoUtil.VERSION_INFO_SEARCH_JOB;
//		mviPatRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory
//				.createMviIntegrationServiceDelegate().searchPersonInMVIForUSAAWithVersion(firstName, middleName,
//						lastName, birthDate, gender, ssn, versionInfo);
//
//		// TODO - Uncomment
//		// req.getSession().removeAttribute(MULTIPLE_ACCOUNT_ERROR_ATTRIB);
//		if (mviPatRes.getMessages().hasErrorMessages()) {
//			// TODO - Uncomment
//			// sendToErrorPage(req, res, icn,
//			// retrieveErrorMessages(mviPatRes.getMessages()));
//			return "ErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MVI_COMM_ISSUE_VALUE)) {
//			return "MVIErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().equals(MviConstants.MULTIPLE_IDS_ERROR)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see
//			// if the user has one active advanced account known to MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account page.
//			request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL,
//					fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//			return "ErrorPage";
//		} else if (mviPatRes != null && mviPatRes.getValue() != null
//				&& mviPatRes.getValue().toString().startsWith(ERROR_VALUE)) {
//			// JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see
//			// if the user has one active advanced account known to MVI,
//			// in the event multiple accounts are returned from MVI, the
//			// system shall display a user-friendly error message in a
//			// yellow box at the top of We Cannot Connect Your Account page.
//
//			// TODO - Uncomment
//			// sendToErrorPage(req, res, icn,
//			// mviPatRes.getValue().toString());
//			return "ErrorPage";
//		}
//
//		if (mviPatRes.getPatient() != null) {
	}

	public void processLastLogin(UserProfileDTO userProfile, String retrieveVAFFIProperty) {
		// TODO Auto-generated method stub
		
	}

	public void populateEauthHash(UserProfileDTO userProfile, String hash, String retrieveVAFFIProperty) {
		// TODO Auto-generated method stub
		
	}

}
