package gov.va.med.mhv.sso;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;

/**
 * Created by dnebinger on 10/26/15.
 */
public class EAuthGateway implements AutoLogin {
	private static final Log logger = LogFactoryUtil.getLog(EAuthGateway.class);

	/**
	 * handleException: Handles the exception reported during the auto login process.
	 * @param request
	 * @param response
	 * @param e
	 * @return String The array of login details.
	 * @throws AutoLoginException
	 */
	public String[] handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws AutoLoginException {
		logger.error("Error encountered by auto login process: " + e.getMessage(), e);

		// now we'll just return null so that it does not do any auto login stuff:

		return null;
	}

	/**
	 * login: Handles the actual auto-login process.
	 * @param request
	 * @param response
	 * @return The array of login details.
	 * @throws AutoLoginException
	 */
	@Override
	public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
		DsLogonAction dsLogonAction = new DsLogonAction();
		FedCredCspAction fedCredCspAction = new FedCredCspAction();
		FedCredFullTraitsAction fedCredFullTraitsAction = new FedCredFullTraitsAction();
		FedCredSsoUtil fedCredSsoUtil = new FedCredSsoUtil();
		
		fedCredSsoUtil.logInfo(logger, "Eauthgateway.Login ********"); 
		
		fedCredSsoUtil.retrieveAllVAFFIPropertiesFromHeader(request);
		
		try {
			if(!fedCredSsoUtil.isValidCredentialProvider(request)) {
				fedCredSsoUtil.logInfo(logger, "Invalid Credential Provider. Going to Error page for icn:" + 
					fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
				//Go to an error page
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				
				//TODO - Figure out what tod do here.
				return null;
			}
			
			if(!fedCredSsoUtil.isMinimumAssuranceLevelMet(request)) {
				fedCredSsoUtil.logInfo(logger, "VA Assurance Level is < 2. Going to Anonymous page for icn:" + 
						fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
				fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_ASSURANCE_LEVEL_MSG);
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				
				//TODO - Figure out what tod do here.
				return null;
			}
		
			if(fedCredSsoUtil.isToProcessExistingSSO(request)) {
				fedCredSsoUtil.logInfo(logger, "Processing Existing SSO for icn:" + 
					fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
				dsLogonAction.run(request, response);
				//fedCredSsoUtil.sendRedirect(response);
				return null;
			} else {
				String cspOnly = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.CSP_ONLY);
				//JAZZ Story #144874 Federated Credential - RemoteID Proofing - Check to see if IAM is providing CSP traits or Full PS traits
				if(cspOnly != null && cspOnly.equalsIgnoreCase(fedCredSsoUtil.TRUE_VALUE)) {
					fedCredSsoUtil.logInfo(logger, "Processing CSP Only SSO for icn:" + 
						fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
					fedCredCspAction.processCspOnlySSo(request, response);
				} else {
					fedCredSsoUtil.logInfo(logger, "Processing Full Traits SSO for icn:" + 
						fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
					fedCredFullTraitsAction.processFullTraitSSo(request, response);
				}
			}
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
			throw new AutoLoginException();
		} catch (IOException e) {
			e.printStackTrace();
			throw new AutoLoginException();
		} catch (ActionException e) {
			e.printStackTrace();
			throw new AutoLoginException();
		} catch (ServletException e) {
			e.printStackTrace();
			throw new AutoLoginException();
		}
		
			//Test eAuthGateway = new Test();
			
			//String testValue = eAuthGateway.testMethod();
			//eAuthGateway.goToStartTodayPage(request,response);
			//String test = eAuthGateway.testMethod();
			
			
		

		// so this is what is normally returned:
		String[] credentials = new String[3];

		//credentials[0] = String.valueOf(user.getUserId());
		//credentials[1] = user.getPassword();
		//credentials[2] = Boolean.TRUE.toString();
		
		credentials[0] = String.valueOf(20903);
		credentials[1] = "AAAAoAAB9ACTX3G9/1k8k6R7RpuWULTaX1uuS0RRkd+RurID";
		credentials[2] = Boolean.TRUE.toString();

		return credentials;

		// now we'll just return null so that it does not do any auto login stuff:

		//return null;
	}
	
}
