/**
 * 
 */
package gov.va.med.mhv.login.hook.service;

import java.io.IOException;

import javax.servlet.http.HttpSession;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;

import gov.va.med.mhv.login.hook.MhvAuthenticator;

/**
 * @author DNS   egberb
 *
 */
public class HttpSessionScreenNameClientRequestFilter implements ClientRequestFilter {
	
	private static final Logger LOGGER = LogManager.getLogger(HttpSessionScreenNameClientRequestFilter.class);
	
	private static final String API_APP_KEY = "appToken";
	private static final String API_MHV_USERNAME_KEY = "mhvUsername";
	private static final String SESSION_USERNAME_KEY = "LIFERAY_SHARED_userid";
	private static final String APP_TOKEN = "MyHealth3Vet123";
	
	/* (non-Javadoc)
	 * @see javax.ws.rs.client.ClientRequestFilter#filter(javax.ws.rs.client.ClientRequestContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		try{
			HttpSession session = PortalSessionThreadLocal.getHttpSession();
			String mhvUsername = (String) session.getAttribute(MhvAuthenticator.ATTR_SCREEN_NAME);
		
			if( mhvUsername == null ){
				System.out.println("**** mhvUsername is null in filter method ****");
				throw new IOException("Unable to get mhvCorrelationId or mhvUsername from session");
			}else{
				System.out.println("Adding '"+API_APP_KEY+"' and '" + API_MHV_USERNAME_KEY
						+ "' to API Client Request for " + API_MHV_USERNAME_KEY
						+ " "+mhvUsername);
			}
			
			if(LOGGER.isDebugEnabled() && mhvUsername != null) {
				LOGGER.debug("Adding '"+API_APP_KEY+"' and '" + API_MHV_USERNAME_KEY
						+ "' to API Client Request for " + API_MHV_USERNAME_KEY
						+ " "+mhvUsername);
			}
			
			requestContext.getHeaders().add(API_APP_KEY, APP_TOKEN);
			requestContext.getHeaders().add(API_MHV_USERNAME_KEY, mhvUsername);
		} catch(Exception e){
			throw new IOException("Unable to access client http session", e);
		}

	}

}
