package gov.va.med.mhv.login.hook;

import java.util.Date;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PerformerTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;

@Component
public class PreLogoutAction extends Action{
	
	private static Log log = LogFactoryUtil.getLog(PreLogoutAction.class);
	
	private AccountActivityCreatorService accountActivityCreatorService;
	
	//when user logs out a record is inserted in to Activity table for audit purpose
	@Override
	public void run(HttpServletRequest request, HttpServletResponse response)
			throws ActionException {
		
		
		try {
			HttpSession session = request.getSession();
			String username=null;
			Long userProfileId=null;
			if(session.getAttribute("LIFERAY_SHARED_userid") != null){
				username = (String)session.getAttribute("LIFERAY_SHARED_userid");
			}
			if(session.getAttribute("LIFERAY_SHARED_userprofileid") != null){
				userProfileId= (Long)session.getAttribute("LIFERAY_SHARED_userprofileid");
			}
			
			if(username != null &&  userProfileId != null){
			   createLogoutActivity(username,userProfileId);
			}
			String sessionId = session.getId();
			session.invalidate();
			Cookie[] cookies = request.getCookies();
		    for (Cookie cookie : cookies) {
		      if (sessionId.equalsIgnoreCase(cookie.getValue())) {
		        cookie.setMaxAge(0);
		        cookie.setValue(null);
		        cookie.setDomain(request.getServerName());
		        cookie.setPath(request.getServletContext().getContextPath() + "/");
		        cookie.setSecure(request.isSecure());
		        response.addCookie(cookie);
		        break;
		      }
		    }
		
		} catch (Exception e) {
			log.error("Error in Pre logout", e);
		}
	}
	
	private void createLogoutActivity(String username, Long userProfileId){
	
		log.debug("Creating Account Activity Log - Logout");
		
		try {
			ActivityDTO logoutActivity = new ActivityDTO();
			logoutActivity.setAction(ActivityActionTypeEnumeration.LOGOUT_WITH_MY_HEALTHEVET.getDescription());
			logoutActivity.setActivityType("Logout");
			logoutActivity.setUserProfileId(userProfileId);
			logoutActivity.setStatus(Boolean.TRUE);
			logoutActivity.setPerformerType(PerformerTypeEnumeration.valueOf("Self").toString());
			logoutActivity.setDetailValue("None");
			logoutActivity.setCompletionTime(new Date());
			
			getAccountActivityCreatorService().createAccountActivityLog(logoutActivity);
		} catch (MHVException e) {
			// TODO: Figure out if this is really the right thing to do here.
			// TODO: Throw runtime exception???
			throw new RuntimeException("Error Creating Account Activity Log - Logut", e);
		}
		
		log.debug("Account Activity Log - Logout Created");
	}
	
	private AccountActivityCreatorService getAccountActivityCreatorService() {
		if(this.accountActivityCreatorService == null) {
			this.accountActivityCreatorService = (AccountActivityCreatorService)ApplicationContextProvider.getApplicationContext().getBean("activityProxy");
		}
		
		return this.accountActivityCreatorService;
	}
}
