/**
 * Perform user pre-timeout actions
 */
package gov.va.med.mhv.login.hook;

import java.util.Date;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.auth.AuthException;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.login.hook.SystemDownException.ErrorCodeEnum;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PerformerTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;


/**
 * @author DNS   BHAMIS
 *
 */
@Component
public class CustomPreSessionExpireAction extends SessionAction {
	
	private static Log log = LogFactoryUtil.getLog(CustomPreSessionExpireAction.class);
	
	private static final String SESSION_USERNAME_KEY = "LIFERAY_SHARED_userid";
	private static final String SESSION_USERPROFILEID_KEY = "LIFERAY_SHARED_userprofileid";
	private AccountActivityCreatorService accountActivityCreatorService;

	
	//When user session times out an AAL entry is added to Activity table for audit purpose
    @Override
    public void run(HttpSession session) throws ActionException {
    	
		try {
			String username=null;
			Long userProfileId=null;
			if(session!=null){
				if(session.getAttribute(SESSION_USERNAME_KEY) != null){
					username = (String)session.getAttribute(SESSION_USERNAME_KEY);
				}
				if(session.getAttribute(SESSION_USERPROFILEID_KEY) != null){
					userProfileId= (Long)session.getAttribute(SESSION_USERPROFILEID_KEY);
				}
			}else{
				log.debug("****Session is null****");
				System.out.println("****Session is null****");
			}
			
			if(username != null &&  userProfileId != null){
				createTimeoutActivity(username,userProfileId);
			}
		
		} catch (Exception e) {
			log.error("Error in CustomPreSessionExpireAction: ", e);
		}    	
    	
    }
    
	private void createTimeoutActivity(String username, Long userProfileId) throws AuthException{
		
		log.debug("Creating Account Activity Log - MHV Timeout");
		
		try {
			ActivityDTO timeoutActivity = new ActivityDTO();
			timeoutActivity.setAction(ActivityActionTypeEnumeration.SESSION_TIMEOUT.getDescription());
			timeoutActivity.setActivityType("Logout");
			timeoutActivity.setUserProfileId(userProfileId);
			timeoutActivity.setStatus(Boolean.TRUE);
			timeoutActivity.setPerformerType(PerformerTypeEnumeration.valueOf("System").toString());
			timeoutActivity.setDetailValue("None");
			timeoutActivity.setCompletionTime(new Date());
			
			getAccountActivityCreatorService().createAccountActivityLog(timeoutActivity);
			
		} catch (MHVException e) {
			log.error("Error Creating Account Activity Log - Session timeout", e);
			throw new AuthException("Error Creating Account Activity Log Service.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE, e));			
		}
		
		log.debug("Account Activity Log - Session timeout created");
	}
	
	private AccountActivityCreatorService getAccountActivityCreatorService() {
		if(this.accountActivityCreatorService == null) {
			this.accountActivityCreatorService = (AccountActivityCreatorService)ApplicationContextProvider.getApplicationContext().getBean("activityProxy");
		}
		
		return this.accountActivityCreatorService;
	}    
}
