package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.VAAllergyService;
import gov.va.med.mhv.health.webservice.VAAllergyWebService;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("vaAllergyService")
@Path("/")
public class VAAllergyWebServiceImpl  implements VAAllergyWebService{
	
	private static Logger log = LogManager.getLogger(VAAllergyWebServiceImpl.class);
	
	@Autowired
	private VAAllergyService allergyService;


	@Override
	@GET
	@Path("/vaallergy/{patientid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getAllergiesForPatient(@PathParam("patientid") Long patientid) {
		log.debug(" DEBUG SERVER -- GET VA Allergy Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findAllergiesForPatient(patientid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET VA Allergy Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	

	@Override
	@GET
	@Path("/dashboardvaallergy/{patientid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getDashBoardVaAllergiesForPatient(@PathParam("patientid") Long patientid) {
		log.debug(" DEBUG SERVER -- GET Dashboard VA Allergy Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findDashBoardVaallergiesForPatient(patientid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Dashboard VA Allergy Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	@Override
	@GET
	@Path("/vaallergybyid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getVaallergyById(@PathParam("id") Long id) {
       log.debug(" DEBUG SERVER -- GET Va allergy record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Va allergy record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").serializeNulls().create();
	}


}
