package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.MilitaryHistoryDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.MilitaryHistoryService;
import gov.va.med.mhv.health.webservice.MilitaryHistoryWebService;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("militaryHistoryService")
@Path("/")
public class MilitaryHistoryWebServiceImpl implements  MilitaryHistoryWebService{
	
	private static Logger log = LogManager.getLogger(MilitaryHistoryWebServiceImpl.class);
	
	@Autowired
	private MilitaryHistoryService militaryHistoryService;


	@Override
	@POST
	@Path("/militaryHistory")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public String saveMilitaryHistoryRecord(String militaryHistoryJson) {
		log.debug("DEBUG SERVER -- SAVE Health History Record");
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			MilitaryHistoryDTO militaryHistoryDTO = gson.fromJson(militaryHistoryJson, MilitaryHistoryDTO.class);
			response = militaryHistoryService.save(militaryHistoryDTO);
			if(response.getValidationErrors().size() == 0){
				response.setSuccess(true);
			}
		}
		catch (Exception e) {
			log.error("Exception Caught Save Health History Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@DELETE
	@Path("/deleteMilitaryHistory/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteMilitaryHistoryRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Health History Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			
			response = militaryHistoryService.delete(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Health History Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/militaryHistory/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getMilitaryHistoryRecordsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Health Records For User ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = militaryHistoryService.findMilitaryHistoryForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Health Records For User", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/militaryHistoryRecordByid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getMilitaryHistoryRecordById(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- GET Immunization record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = militaryHistoryService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Health Records record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
	}

}
