package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.MedicalEventDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.MedicalEventService;
import gov.va.med.mhv.health.webservice.MedicalEventWebService;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("medicalEventService")
@Path("/")
public class MedicalEventWebServiceImpl implements  MedicalEventWebService{
	
	private static Logger log = LogManager.getLogger(MedicalEventWebServiceImpl.class);
	
	@Autowired
	private MedicalEventService medicalEventService;


	@Override
	@POST
	@Path("/medicalEvent")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public String saveMedicalEventRecord(String medicalEventjson) {
		log.debug("DEBUG SERVER -- SAVE Medical Event Record");
		
		Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS a").create();
		ResponseUtil response = new ResponseUtil();
		try {
			MedicalEventDTO medicalEventDTO = gson.fromJson(medicalEventjson, MedicalEventDTO.class);
			response = medicalEventService.save(medicalEventDTO);
			if(response.getValidationErrors().size() == 0){
				response.setSuccess(true);
			}
		}
		catch (Exception e) {
			log.error("Exception Caught Save Medical Event Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@DELETE
	@Path("/deleteMedicalEventRecord/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteMedicalEventRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Medical Event Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = medicalEventService.delete(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Medical Event Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/medicalEvent/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getMedicalEventsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Medical Event Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = medicalEventService.findMedicalEventsForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Medical Event Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/dashboardMedicalEvent/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getDashBoardMedicalEventsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Dash Board Medical Event Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = medicalEventService.findDashBoardMedicalEventsForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Dash Board Medical Event Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/medicalEventRecordByid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getMedicalEventById(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- GET Immunization record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = medicalEventService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Immunization record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
	}

}
