package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.ImmunizationDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.ImmunizationService;
import gov.va.med.mhv.health.webservice.ImmunizationWebService;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("immunizationService")
@Path("/")
public class ImmunizationWebServiceImpl implements  ImmunizationWebService{
	
	private static Logger log = LogManager.getLogger(ImmunizationWebServiceImpl.class);
	
	@Autowired
	private ImmunizationService immunizationService;


	@Override
	@POST
	@Path("/immunization")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public String saveImmunizationRecord(String immunizationJson) {
		log.debug("DEBUG SERVER -- SAVE Immunization Record");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			ImmunizationDTO immunizationDTO = gson.fromJson(immunizationJson, ImmunizationDTO.class);
			response = immunizationService.save(immunizationDTO);
			if(response.getValidationErrors().size() == 0){
				response.setSuccess(true);
			}
		}
		catch (Exception e) {
			log.error("Exception Caught Save Immunization Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@DELETE
	@Path("/deleteImmunizationRecord/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteImmunizationRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Immunization Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = immunizationService.delete(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Immunization Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/immunization/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getImmunizationRecordsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Immunization Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = immunizationService.findImmunizationsForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Immunization Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/dashboardImmunization/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getDashBoardImmunizationRecordsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Dashboard Immunization Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = immunizationService.findDashBoardImmunizationsForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Dashboard Immunization Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/immunizationRecordByid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getImmunizationRecordById(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- GET Immunization record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = immunizationService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Immunization record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
	}

}
