package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.HealthHistoryService;
import gov.va.med.mhv.health.webservice.HealthHistoryWebService;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("healthHistoryService")
@Path("/")
public class HealthHistoryWebServiceImpl implements HealthHistoryWebService {
	
	private static Logger log = LogManager.getLogger(HealthHistoryWebServiceImpl.class);
	
	@Autowired
	private HealthHistoryService healthHistoryService;


	@Override
	@POST
	@Path("healthHistory")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public String saveHealthHistoryRecord(String healthHistoryJson) {
		log.debug("DEBUG SERVER -- SAVE Health History Record");
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			HealthHistoryRecordDTO healthHistoryDTO = gson.fromJson(healthHistoryJson, HealthHistoryRecordDTO.class);
			response = healthHistoryService.save(healthHistoryDTO);
			if (response.getValidationErrors().size() == 0) {
				response.setSuccess(true);
			}
		} catch (Exception e) {
			log.error("Exception Caught Save Health History Record", e);

			response = new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@DELETE
	@Path("/deleteHealthHistoryRecord/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteHealthHistoryRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Health History Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			
			response = healthHistoryService.delete(id);
			response.setSuccess(true);
			response.setFailure(false);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Health History Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	@Override
	@DELETE
	@Path("/deleteHealthIssueRecord/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteHealthIssueRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Health Issue Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = healthHistoryService.deleteHealthIssue(id);
			response.setSuccess(true);
			response.setFailure(false);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Health History Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/healthHistory/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getHealthHistoryRecordsForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Health Records For User ");

		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = healthHistoryService.findHealthHistoryForUser(userid);
			response.setSuccess(true);
		} catch (Exception e) {
			log.error("Exception Caught GET Health Records For User", e);

			response = new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/healthHistoryRecordByid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getHealthHistoryRecordById(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- GET Immunization record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = healthHistoryService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Health Records record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
	}

}
