package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.ChemistryLabService;
import gov.va.med.mhv.health.webservice.ChemistryLabWebService;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("chemLabService")
@Path("/")
public class ChemistryLabWebServiceImpl implements  ChemistryLabWebService{
	
private static Logger log = LogManager.getLogger(ChemistryLabWebServiceImpl.class);
	
	@Autowired
	private ChemistryLabService chemLabService;

	@Override
	@GET
	@Path("/chemlab/{patientid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getChemLabsForPatient(@PathParam("patientid") Long patientid) {
		log.debug(" DEBUG SERVER -- GET Chemistry lab Records For patient ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = chemLabService.findChemLabsForPatient(patientid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Chemistry lab Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/chempanel/{patientid}/{chemlabid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getChemPanelForPatient(@PathParam("patientid") Long patientid, @PathParam("chemlabid") Long chemlabid) {
		log.debug(" DEBUG SERVER -- GET Chemistry Panel For patient ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = chemLabService.findChemPanelForPatient(patientid, chemlabid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Chemistry Panel for patient", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/dashboardChemlab/{patientid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getDashboardChemLabsForPatient(@PathParam("patientid") Long patientid) {
		log.debug(" DEBUG SERVER -- GET Chemistry lab dash board Records For patient ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = chemLabService.findDashboardChemLabsForPatient(patientid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Chemistry lab  dash board Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}
	
	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").serializeNulls().create();
	}


}
