package gov.va.med.mhv.health.webservice.impl;

import gov.va.med.mhv.health.dto.AllergyDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.service.AllergyService;
import gov.va.med.mhv.health.webservice.AllergyWebService;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

@Service("allergyService")
@Path("/")
public class AllergyWebServiceImpl implements AllergyWebService{
	
	private static Logger log = LogManager.getLogger(AllergyWebServiceImpl.class);
	
	@Autowired
	private AllergyService allergyService;

	@Override
	@POST
	@Path("/allergy")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public String saveAllergiesRecord(String allergiesjson) {
		log.debug("DEBUG SERVER -- SAVE Allergy Record");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			AllergyDTO allergyDTO = gson.fromJson(allergiesjson, AllergyDTO.class);
			response = allergyService.save(allergyDTO);
			if(response.getValidationErrors().size() == 0){
				response.setSuccess(true);
			}
		}
		catch (Exception e) {
			log.error("Exception Caught Save Allergy Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@DELETE
	@Path("/deleteAllergyRecord/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteAllergiesRecord(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- Delete Allergy Record ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.delete(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Delete Allergy Record", e);
			
			response=new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/allergy/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getAllergiesForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Allergy Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findAllergiesForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Allergy Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/dashboardAllergy/{userid}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getDashBoardAllergiesForUser(@PathParam("userid") Long userid) {
		log.debug(" DEBUG SERVER -- GET Dashboard Allergy Records ForUser ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findDashBoardAllergiesForUser(userid);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught GET Dashboard Allergy Records ForUser", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	@Override
	@GET
	@Path("/allergyRecordByid/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public String getAllergiesRecordById(@PathParam("id") Long id) {
		log.debug(" DEBUG SERVER -- GET Allergy record By Id ");
		
		Gson gson = getGson();
		ResponseUtil response = new ResponseUtil();
		try {
			response = allergyService.findByPrimaryKey(id);
			response.setSuccess(true);
		}
		catch (Exception e) {
			log.error("Exception Caught Allergy record By Id", e);
			
			response= new ResponseUtil();
			response.setSuccess(false);
			response.setFailureMessage(e.getMessage());
		}
		return gson.toJson(response);
	}

	private Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").serializeNulls().create();
	}
}
