package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.CommonUtility;
import gov.va.med.mhv.health.web.form.bean.Allergy;
import gov.va.med.mhv.health.web.form.bean.VAAllergy;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

@ManagedBean
@Component
@Scope("session")
public class VaallergyController extends AbstractController {

	private static final long serialVersionUID = 9050946863612105316L;
	
	private static Logger log = LogManager.getLogger(VaallergyController.class);
	private List<VAAllergy> vaAllergyRecords = new ArrayList<VAAllergy>();
	private DataTable vaalTable = new DataTable();
	private VAAllergy selectedVAAllergyRecord = new VAAllergy();
	private static final String VA_ALLERGY="vaallergy";
	private static final String SELF_ENTERED_ALLERGY="allergy";
	List<Allergy> selfEnteredAllergies = new ArrayList<Allergy>();
	private String option = new String();
	private static final String VA ="VA";
	private static final String SELF = "SELF";
	private Allergy selectedAllergyRecord = new Allergy();
	private DataTable alTable = new DataTable();
	private String lastupdatedDate;
	PatientDTO patientDTO ;
	private static final String ALLERGY_RECORD_BY_ID="vaallergybyid";

	
	public void init(ComponentSystemEvent event) {
		
		alTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("vaallergyForm:selfAllergyList");
		vaalTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("vaallergyForm:vaAllergyList");
	
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setOption(VA);
			getVaAllergryRecords();
			setRowsPerPage(10);
		}else{
			if(sortColumn != null && sortBy != null){
				if(alTable!=null) {
					alTable.setValueExpression("sortBy", sortColumn);
					alTable.setSortOrder(sortBy);
				}	

				if(vaalTable!=null) {
					vaalTable.setValueExpression("sortBy", sortColumn);
					vaalTable.setSortOrder(sortBy);
				}
			} 
		}	
	}
	

	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	
	private void getVaAllergryRecords(){
		findUser();
		userprofileId = getUserProfileId();
		try{
			if (userprofileId != null) {
				patientDTO = getPatient(userprofileId);
				if(patientDTO != null){
					refreshAllergyData();
					getRefreshStatus();
				    vaAllergyRecords = findVAAllergyRecords(patientDTO.getId());
				}
			}
	    }catch(Exception e){
	    	log.error("Error in Finding VA Allergies::"+ e.getMessage());
	    	WebServiceClientUtil.showErrorMessage();
	    }
	}
	
	
	private void refreshAllergyData(){
		
		WebClient client= getPHRManagerWebClient().path("refresh").path(patientDTO.getIcn()).path("Allergy").
				         accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse=client.post(null);
		if(webserviceResponse.getStatus() == 200){
			log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
		}else{
			log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
	}
	
	
	public String getRefreshStatus(){
		   log.debug("Inside  PHR-status service");
		   if(patientDTO != null){
			   GsonBuilder builder = new GsonBuilder(); 
			   builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() { 
				@Override
				public Date deserialize(JsonElement json, Type typeOfT,
						JsonDeserializationContext context)
						throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong()); 
				} 
				});
			   Gson gson = builder.create();
			   WebClient client= getPHRManagerWebClient().path("status").path(patientDTO.getIcn()).
				         accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			   Response webserviceResponse =client.get();
			   Date lastModified=null; 
			   if(webserviceResponse.getStatus() == 200){
				   Reader responseReader= new InputStreamReader ((InputStream)webserviceResponse.getEntity());
				   PatientExtractStatus patientExtractStatus= gson.fromJson(responseReader,PatientExtractStatus.class);
				   String FacilityExtractStatusjson=gson.toJson(patientExtractStatus.getFacilityExtractStatusList()) ;   
				   Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				   Gson gson1= new Gson();
				   List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				   for(FacilityExtractStatus extractStatus : facilityStausList){
					   if(extractStatus.getExtract().trim().equals("Allergy")){
						   lastModified = extractStatus.getLastModified();
						   break;
					   }
				   }
				   if(lastModified != null){
					   lastupdatedDate=CommonUtility.dateToStringTimeZone(lastModified,"MM/dd/yyyy") +
							   "  at  "+CommonUtility.dateToStringTimeZone(lastModified,"HH:mm"); 
					   vaAllergyRecords = findVAAllergyRecords(patientDTO.getId());
				   }
				   
			   }else{
				   log.error("Error invoking PHR status service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			   }
	       }
		   return null;
	}

	private List<VAAllergy> findVAAllergyRecords(Long patientId) {
		List<VAAllergy> dtoList = null;
		Reader responseReader=null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(VA_ALLERGY).path(patientId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String allergiesJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<VAAllergy>>() {}.getType();
				dtoList = gson.fromJson(allergiesJson, type);
				
				log.debug("VA Allergy Records :" + dtoList.size());
			} else {
				log.error("Error in Find VA Allergy Records");
				WebServiceClientUtil.showErrorMessage();
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));	    }
		return dtoList;
	}

	
	public String showDetail(VAAllergy vAAllergy) {
		selectedVAAllergyRecord = vAAllergy;
		String outcome=null;
		if(selectedVAAllergyRecord.getVaAllergyId() != null){
			outcome ="vaallergy";
		}else{
			outcome="selfVaallergy";
		}
		return outcome;
	}
	
	public String showSelfDetail(Allergy allergy) {
		selectedAllergyRecord = allergy;
		return "selfAllergy";
	}
	
	public String showSelectedOption(){
		String outcome=null;
		Long userprofileId = getUserProfileId();
		if(userprofileId != null){
			if(option.equals(VA)){
				PatientDTO patientDTO  = getPatient(userprofileId);
				vaAllergyRecords = findVAAllergyRecords(patientDTO.getId());
				outcome="vaallergyList";
			}else if(option.equals(SELF)){
				selfEnteredAllergies = findSelfEnteredAllergyRecords(userprofileId);
				outcome="selfAllergyList";
				
				
			}else{
				selfEnteredAllergies = findSelfEnteredAllergyRecords(userprofileId);
				PatientDTO patientDTO  = getPatient(userprofileId);
				List<VAAllergy> vaRecords = findVAAllergyRecords(patientDTO.getId());
				vaAllergyRecords =  mergeAllergyRecords(vaRecords,selfEnteredAllergies);
				Collections.sort(vaAllergyRecords);
				outcome="vaallergyList";
			}
		}
		return outcome;
	}
	
	private List<VAAllergy> mergeAllergyRecords(List<VAAllergy> vaAllergyRecords,List<Allergy> selfEnteredAllergies) {
		List<VAAllergy> totalAllergyRecords = new ArrayList<VAAllergy>();
		for(Allergy allergy : selfEnteredAllergies){
			VAAllergy  vallergy = new VAAllergy();
			vallergy.setObservationDate(allergy.getEventDate());
			vallergy.setReactant(allergy.getAllergy());
			vallergy.setReaction(allergy.getReaction());
			vallergy.setFacilityName(null);
			vallergy.setSource("Self");
			vallergy.setSeverity(allergy.getDisplaySeverity());
			vallergy.setDiagnosed(allergy.getDisplayDiagnosed());
			totalAllergyRecords.add(vallergy);
		}
		totalAllergyRecords.addAll(vaAllergyRecords);
		return totalAllergyRecords;
	}	

	private List<Allergy> findSelfEnteredAllergyRecords(Long userprofileId) {
		List<Allergy> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(SELF_ENTERED_ALLERGY).path(userprofileId).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String allergiesJson = gson.toJson(response.getPojoObject());
					Type type = new TypeToken<List<Allergy>>() {}.getType();
					dtoList = gson.fromJson(allergiesJson, type);
					
					log.debug("Allergy Records :" + dtoList.size());
				} else {
					log.error("Error in Find Immunization Records");
					WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Immunization Records:", e.getMessage());
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return dtoList;
	}
	
	
	public String dashboardViewMore(){
		resetMessages();
		setOption(VA);
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		getVaAllergryRecords();
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/vaallergy/vaallergyList.xhtml");
		return null;
	}
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String alid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("alid");
		if (alid != null) {
			Long id = Long.valueOf(alid);
			selectedVAAllergyRecord=findVaAllergyRecordById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		setOption(VA);
		getVaAllergryRecords();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/vaallergy/vaallergy.xhtml");
		return null;
	}
	
	
	private VAAllergy findVaAllergyRecordById(Long id) {
		VAAllergy dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(ALLERGY_RECORD_BY_ID).path(id).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String allergyJson = gson.toJson(response.getPojoObject());
					dto = gson.fromJson(allergyJson, VAAllergy.class);
				} else {
					log.error("Error in Find Allergy record By id",response.getFailureMessage());
			    	WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Allergy record By id:", e);
	    	WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return dto;
	}
	
	public String printVAAllergySummary(){
		vaalTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("vaallergyForm:vaAllergyList");
		return "printVAAllergySummary";
	}
	
	public String printSelfAllergySummary(){
		alTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("vaallergyForm:selfAllergyList");
		return "printSelfAllergySummary";
	}


	public List<VAAllergy> getVaAllergyRecords() {
		return vaAllergyRecords;
	}


	public void setVaAllergyRecords(List<VAAllergy> vaAllergyRecords) {
		this.vaAllergyRecords = vaAllergyRecords;
	}


	public DataTable getVaalTable() {
		return vaalTable;
	}


	public void setVaalTable(DataTable vaalTable) {
		this.vaalTable = vaalTable;
	}


	public VAAllergy getSelectedVAAllergyRecord() {
		return selectedVAAllergyRecord;
	}


	public void setSelectedVAAllergyRecord(VAAllergy selectedVAAllergyRecord) {
		this.selectedVAAllergyRecord = selectedVAAllergyRecord;
	}


	public String getOption() {
		return option;
	}


	public void setOption(String option) {
		this.option = option;
	}


	public List<Allergy> getSelfEnteredAllergies() {
		return selfEnteredAllergies;
	}


	public void setSelfEnteredAllergies(List<Allergy> selfEnteredAllergies) {
		this.selfEnteredAllergies = selfEnteredAllergies;
	}


	public Allergy getSelectedAllergyRecord() {
		return selectedAllergyRecord;
	}


	public void setSelectedAllergyRecord(Allergy selectedAllergyRecord) {
		this.selectedAllergyRecord = selectedAllergyRecord;
	}


	public DataTable getAlTable() {
		return alTable;
	}


	public void setAlTable(DataTable alTable) {
		this.alTable = alTable;
	}


	public String getLastupdatedDate() {
		return lastupdatedDate;
	}


	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}
}
