package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.CommonUtility;
import gov.va.med.mhv.health.web.form.bean.TestEntry;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class SelfEnteredTestController extends AbstractController{

	private static final long serialVersionUID = 5170774081663442806L;
	
	private static Logger log = LogManager.getLogger(SelfEnteredTestController.class);
	private List<TestEntry> testEntries = new ArrayList<TestEntry>();
	private DataTable testTable;
	private TestEntry selectedTestEntry = new TestEntry();
	private TestEntry newTestEntry = new TestEntry();
	private static final String TEST_ENTRY="testEntry";
	private static final String DELETE_TEST_ENTRY="deleteTestEntry";
	private static final String TEST_ENTRY_BY_ID="testEntryByid";
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		testTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("selfTestForm:testEntryList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			if (userprofileId != null) {
				testEntries = findTestEntries(userprofileId);
			}
			setRowsPerPage(10);
		}else{
			if(sortColumn != null && sortBy != null){
				testTable.setValueExpression("sortBy", sortColumn);
				testTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<TestEntry> findTestEntries(Long userprofileId) {
		List<TestEntry> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGsonTimeStamp();
		    WebClient client= getWebClient().path(TEST_ENTRY).path(userprofileId).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String testEntryjson = gson.toJson(response.getPojoObject());
					Type type = new TypeToken<List<TestEntry>>() {}.getType();
					dtoList = gson.fromJson(testEntryjson, type);
					
					log.debug("Test Entries :" + dtoList.size());
				}else {
					log.error("Error in Find Test Entries:", response.getFailureMessage());
					WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Test Entry Records:", e.getMessage());
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail(TestEntry testEntry) {
		resetMessages();
		selectedTestEntry = testEntry;
		return "testEntry";
	}
	
	public String editDisplay(TestEntry testEntry) {
		resetMessages();
		selectedTestEntry = testEntry;
		return "editTestEntryDisplay";
	}
	
	public String resetEditDisplay(){
		return "editTestEntryDisplay";
	}

	public String deleteDisplay(TestEntry testEntry) {
		resetMessages();
		selectedTestEntry = testEntry;
		setDeleteOrigin("tableView");
		return "deleteTestEntryDisplay";
	}
	
	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteTestEntryDisplay";
	}

	
	public String addDisplay() {
		resetMessages();
		newTestEntry=new TestEntry();
		newTestEntry.setEventDate(new Date());
		return "addTestEntryDisplay";
	}
	
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newTestEntry=new TestEntry();
		newTestEntry.setEventDate(new Date());
		/*FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/selfenteredtest/addTestEntryDisplay.xhtml");*/
		return "/views/selfenteredtest/addTestEntryDisplay";
	}
	
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String testid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("testid");
		if (testid != null) {
			Long id = Long.valueOf(testid);
			selectedTestEntry=findTestEntryById(id);
		}	
/*		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/selfenteredtest/testEntry.xhtml");*/
		return "/views/selfenteredtest/testEntry";
	}
	
	
	

	
	private TestEntry findTestEntryById(Long id) {
		TestEntry dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGsonTimeStamp();
		    WebClient client= getWebClient().path(TEST_ENTRY_BY_ID).path(id).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String testEntryJson = gson.toJson(response.getPojoObject());
					dto = gson.fromJson(testEntryJson, TestEntry.class);
				} else {
					log.error("Error in Find Test Entry By id",response.getFailureMessage());
					WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Test Entry record By id:", e);
	    	WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return dto;
	}
	
	
	public String dashboardViewMore(){
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			testEntries = findTestEntries(userprofileId);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/selfenteredtest/testEntryList.xhtml");
		return null;
	}



	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String testid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("testid");
		try{
			if (testid != null) {
				Long id = Long.valueOf(testid);
				Gson gson = getGsonTimeStamp();
				WebClient client=getWebClient().path(DELETE_TEST_ENTRY).path(id).accept(CONTENT_TYPE);
				Response webserviceResponse =client.delete();
				if(webserviceResponse.getStatus() == 200){
					responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
					ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
					if (!response.isSuccess()) {
						log.debug("Failed to Delete Test Entry" ,response.getFailureMessage());
						WebServiceClientUtil.showErrorMessage();
					}else{
						deleteMessage = true;
						testEntries = findTestEntries(userprofileId);
						outcome="testEntryList";
					}
				}else{
			    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			    	WebServiceClientUtil.showErrorMessage();
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Test Entry",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response =saveTestEntry(responseReader);
			if(response.isSuccess()){
				outcome="testEntryList";
				testEntries = findTestEntries(userprofileId);
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Test Entry record",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public ResponseUtil saveTestEntry(Reader responseReader) {
		resetMessages();
		ResponseUtil response=new ResponseUtil();
		String testid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("testid");
		TestEntry testEntry=null;
		if (testid != null) {
			testEntry=getSelectedTestEntry();
		}else{
			testEntry=getNewTestEntry();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(TEST_ENTRY).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		testEntry = prepareTestEntry(testEntry);
		String testEntryJson = gson.toJson(testEntry);
		Response webserviceResponse =client.post(testEntryJson);
		if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			response = gson.fromJson(responseReader, ResponseUtil.class);
			if(!response.isSuccess()){
				Map<String, String> map = response.getValidationErrors();
				for (Map.Entry<String, String> entry : map.entrySet()) {
					if (null != entry) {
						log.debug("entry.getKey() : " + entry.getKey());
						log.debug("entry.getValue() : " + entry.getValue());
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
				}
			}
		}else{
	    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
	    	WebServiceClientUtil.showErrorMessage();
		}
		return response;
	}


	private TestEntry prepareTestEntry(TestEntry testEntry) {
		Date dateTime=null;
		if(testEntry.getEventDate()!= null){
		   dateTime = CommonUtility.getDaTeTime(testEntry.getEventDate(), DEFAULT_HOUR, DEFAULT_MINUTE);
		   testEntry.setEventDate(dateTime);
		}
		testEntry.setUserprofileId(getUserProfileId());
		return testEntry;
	}

	public String saveAndAdd() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response=saveTestEntry(responseReader);
			if(response.isSuccess()){
				outcome="addTestEntryDisplay";
				saveAndAddMessage = true;
				testEntries = findTestEntries(userprofileId);
				newTestEntry=new TestEntry();
				newTestEntry.setEventDate(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Test Entry record",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}
	
	public String printerFriendlySummary(){
		testTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("selfTestForm:testEntryList");
		return "printTestEntrySummary";
	}
	
	public String backToList(){
		resetMessages();
		return "testEntryList";
	}

	public List<TestEntry> getTestEntries() {
		return testEntries;
	}

	public void setTestEntries(List<TestEntry> testEntries) {
		this.testEntries = testEntries;
	}

	public DataTable getTestTable() {
		return testTable;
	}

	public void setTestTable(DataTable testTable) {
		this.testTable = testTable;
	}

	public TestEntry getSelectedTestEntry() {
		return selectedTestEntry;
	}

	public void setSelectedTestEntry(TestEntry selectedTestEntry) {
		this.selectedTestEntry = selectedTestEntry;
	}

	public TestEntry getNewTestEntry() {
		return newTestEntry;
	}

	public void setNewTestEntry(TestEntry newTestEntry) {
		this.newTestEntry = newTestEntry;
	}

}
