package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.CommonUtility;
import gov.va.med.mhv.health.web.form.bean.MedicalEvent;

@ManagedBean
@Component
@Scope("session")
public class MedicalEventController extends AbstractController{
	
	private static final long serialVersionUID = 981887530734048576L;
	
	private static Logger log = LogManager.getLogger(MedicalEventController.class);
	private List<MedicalEvent> medicalEvents = new ArrayList<MedicalEvent>();
	private DataTable meTable;
	private MedicalEvent selectedMedicalEvent = new MedicalEvent();
	private MedicalEvent newMedicalEvent = new MedicalEvent();
	private static final String MEDICAL_EVENT="medicalEvent";
	private static final String DELETE_MEDICAL_EVENT="deleteMedicalEventRecord";
	private static final String MEDICAL_EVENT_BY_ID="medicalEventRecordByid";
	private boolean displayEmptyMessage=false;
	private boolean displayViewMessage=false;
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		meTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicalEventForm:medicalEventList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			if (userprofileId != null) {
				medicalEvents = findMedicalEvents(userprofileId);
			}
			setRowsPerPage(10);
		}else{
			if(sortColumn != null && sortBy != null){
				meTable.setValueExpression("sortBy", sortColumn);
				meTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<MedicalEvent> findMedicalEvents(Long userprofileId) {
		List<MedicalEvent> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGsonTimeStamp();
		    WebClient client= getWebClient().path(MEDICAL_EVENT).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String medicalEventJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<MedicalEvent>>() {}.getType();
				dtoList = gson.fromJson(medicalEventJson, type);
				log.debug("Medical EVents :" + dtoList.size());
			} else {
				log.error("Error in Find Medical Events");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Medical EVents:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		
		if(dtoList==null || dtoList.isEmpty()) {
			displayEmptyMessage=true;
			displayViewMessage=false;
		}
		else {
			displayViewMessage=true;
			displayEmptyMessage=false;			
		}
		
		return dtoList;
	}

	public String showDetail(MedicalEvent medicalEvent) {
		resetMessages();
		selectedMedicalEvent = medicalEvent;
		return "medicalEvent";
	}
	
	public String editDisplay(MedicalEvent medicalEvent) {
		resetMessages();
		selectedMedicalEvent = medicalEvent;
		return "editMedicalEventDisplay";
	}

	public String deleteDisplay(MedicalEvent medicalEvent) {
		resetMessages();
		selectedMedicalEvent = medicalEvent;
		setDeleteOrigin("tableView");
		return "deleteMedicalEventDisplay";
	}
	
	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteMedicalEventDisplay";
	}
	
	public String addDisplay() {
		resetMessages();
		newMedicalEvent=new MedicalEvent();
		newMedicalEvent.setStartDate(new Date());
		return "addMedicalEventDisplay";
	}
	
	//TODO: change the navigation handler
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newMedicalEvent=new MedicalEvent();
		newMedicalEvent.setStartDate(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../heartrate/addHRDisplay.xhtml");
		return null;
	}
	
	//TODO:change the navigation handler
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String meid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("meid");
		if (meid != null) {
			Long id = Long.valueOf(meid);
			selectedMedicalEvent=findMedicalEventById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../heartrate/heartRate.xhtml");
		return null;
	}

	
	private MedicalEvent findMedicalEventById(Long id) {
		MedicalEvent dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGsonTimeStamp();
		    WebClient client= getWebClient().path(MEDICAL_EVENT_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String medicalEventJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(medicalEventJson, MedicalEvent.class);
			} else {
				log.error("Error in Find Medical Event By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find  Medical EventBy id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String meid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("meid");
		try{
			if (meid != null) {
				Long id = Long.valueOf(meid);
				Gson gson = getGsonTimeStamp();
				WebClient client=getWebClient().path(DELETE_MEDICAL_EVENT).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Medical Event" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					medicalEvents = findMedicalEvents(userprofileId);
					outcome="medicalEventList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Medical Event",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response =saveMedicalEvent(responseReader);
			if(response.isSuccess()){
				outcome="medicalEventList";
				medicalEvents = findMedicalEvents(userprofileId);
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Medical Event",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public ResponseUtil saveMedicalEvent(Reader responseReader) {
		resetMessages();
		String meid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("meid");
		MedicalEvent medicalEvent=null;
		if (meid != null) {
			medicalEvent=getSelectedMedicalEvent();
		}else{
			medicalEvent=getNewMedicalEvent();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(MEDICAL_EVENT).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		medicalEvent = prepareMedicalEvent(medicalEvent);
		String medicalEventJson = gson.toJson(medicalEvent);
		responseReader = new InputStreamReader((InputStream) client.post(medicalEventJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}


	private MedicalEvent prepareMedicalEvent(MedicalEvent medicalEvent) {
		Date dateTime=null;
		if(medicalEvent.getStartDate() != null){
		   dateTime = CommonUtility.getDaTeTime(medicalEvent.getStartDate(), DEFAULT_HOUR, DEFAULT_MINUTE);
		   medicalEvent.setStartDate(dateTime);
		}
		if(medicalEvent.getStopDate() != null){
		   dateTime = CommonUtility.getDaTeTime(medicalEvent.getStopDate(), DEFAULT_HOUR, DEFAULT_MINUTE);
		   medicalEvent.setStopDate(dateTime);
		}
		medicalEvent.setUserprofileId(getUserProfileId());
		return medicalEvent;
	}

	public String saveAndAdd() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response=saveMedicalEvent(responseReader);
			if(response.isSuccess()){
				outcome="addMedicalEventDisplay";
				saveAndAddMessage = true;
				medicalEvents = findMedicalEvents(userprofileId);
				newMedicalEvent=new MedicalEvent();
				newMedicalEvent.setStartDate(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Medical Event record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}
	
	public String printerFriendlySummary(){
		meTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicalEventForm:medicalEventList");
		return "printMedicalEventSummary";
	}
	
	public String backToList(){
		resetMessages();
		return "medicalEventList";
	}


	public List<MedicalEvent> getMedicalEvents() {
		return medicalEvents;
	}

	public void setMedicalEvents(List<MedicalEvent> medicalEvents) {
		this.medicalEvents = medicalEvents;
	}

	public DataTable getMeTable() {
		return meTable;
	}

	public void setMeTable(DataTable meTable) {
		this.meTable = meTable;
	}

	public MedicalEvent getSelectedMedicalEvent() {
		return selectedMedicalEvent;
	}

	public void setSelectedMedicalEvent(MedicalEvent selectedMedicalEvent) {
		this.selectedMedicalEvent = selectedMedicalEvent;
	}

	public MedicalEvent getNewMedicalEvent() {
		return newMedicalEvent;
	}

	public void setNewMedicalEvent(MedicalEvent newMedicalEvent) {
		this.newMedicalEvent = newMedicalEvent;
	}

	public boolean isDisplayEmptyMessage() {
		return displayEmptyMessage;
	}

	public void setDisplayEmptyMessage(boolean displayEmptyMessage) {
		this.displayEmptyMessage = displayEmptyMessage;
	}

	public boolean isDisplayViewMessage() {
		return displayViewMessage;
	}

	public void setDisplayViewMessage(boolean displayViewMessage) {
		this.displayViewMessage = displayViewMessage;
	}

}
