package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.faces.bean.ManagedBean;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;
import javax.faces.context.FacesContext;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.web.form.bean.ChemistryLab;
import gov.va.med.mhv.health.web.form.bean.TestEntry;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class LabsAndTestsController  extends AbstractController{

	private static final long serialVersionUID = -2120358181552099351L;
	
	private static Logger log = LogManager.getLogger(LabsAndTestsController.class);
	private List<TestEntry> testEntries = new ArrayList<TestEntry>();;
	private static final String TEST_ENTRY="dashboardTestEntry";
	private List<ChemistryLab> chemLabRecords = new ArrayList<ChemistryLab>();
	private static final String CHEM_LAB="dashboardChemlab";
	private String basicAccount;
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		Reader responseReader=null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String accountType = (String) session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE);
		
		if (accountType.equalsIgnoreCase("Basic") || accountType.equalsIgnoreCase("Advanced")){
			setBasicAccount("True");
		}

		try{
		   if (userprofileId != null) {
			   testEntries = findTestEntries(userprofileId,responseReader);
			   PatientDTO patientDTO = getPatient(userprofileId);
			   if(patientDTO != null){
				   chemLabRecords=findChemLabRecords(patientDTO.getId(),responseReader);
			   }
		   }
		}catch (Exception e){
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
	}
	
	
	private List<ChemistryLab> findChemLabRecords(Long patientId,Reader responseReader) {
		List<ChemistryLab> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(CHEM_LAB).path(patientId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String allergiesJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<ChemistryLab>>() {}.getType();
				dtoList = gson.fromJson(allergiesJson, type);
				
				log.debug("Chemistry Lab Records :" + dtoList.size());
			} else {
				log.error("Error in Find Chemistry Lab Records",response.getFailureMessage());
				WebServiceClientUtil.showErrorMessage();
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));	    }
		return dtoList;
	}

	
	
	private List<TestEntry> findTestEntries(Long userprofileId,Reader responseReader) {
		List<TestEntry> dtoList = null;
		Gson gson = getGsonTimeStamp();
	    WebClient client= getWebClient().path(TEST_ENTRY).path(userprofileId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String testEntryjson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<TestEntry>>() {}.getType();
				dtoList = gson.fromJson(testEntryjson, type);
				
				log.debug("Test Entries :" + dtoList.size());
			}else {
				log.error("Error in Find Test Entries:", response.getFailureMessage());
				throw new RuntimeException(response.getFailureMessage());
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
	   	}
		return dtoList;
	}


	public List<TestEntry> getTestEntries() {
		return testEntries;
	}


	public void setTestEntries(List<TestEntry> testEntries) {
		this.testEntries = testEntries;
	}


	public List<ChemistryLab> getChemLabRecords() {
		return chemLabRecords;
	}


	public void setChemLabRecords(List<ChemistryLab> chemLabRecords) {
		this.chemLabRecords = chemLabRecords;
	}
	
	
	public String getBasicAccount() {
		return basicAccount;
	}

	public void setBasicAccount(String basicAccount) {
		this.basicAccount = basicAccount;
	}
	
}
