package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.web.form.bean.Immunization;


@ManagedBean
@Component
@Scope("session")
public class ImmunizationController extends AbstractController {
	
	private static final long serialVersionUID = 1901221328105359932L;
	
	private static Logger log = LogManager.getLogger(ImmunizationController.class);
	private List<Immunization> immunizationRecords = new ArrayList<Immunization>();
	private DataTable imTable;
	private Immunization selectedImmunizationRecord = new Immunization();
	private Immunization newImmunizationRecord = new Immunization();

	private boolean displayEmptyMessage=false;
	private boolean displayViewMessage=false;
	private static final String IMMUNIZATION="immunization";
	private static final String DELETE_IMMUNIZATION_RECORD="deleteImmunizationRecord";
	private static final String IMMUNIZATION_RECORD_BY_ID="immunizationRecordByid";
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		imTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("immunizationForm:immunizationList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			if (userprofileId != null) {
				immunizationRecords = findImmunizationRecords(userprofileId);
			}
			setRowsPerPage(10);
		}else{
			if(sortColumn != null && sortBy != null){
				imTable.setValueExpression("sortBy", sortColumn);
				imTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<Immunization> findImmunizationRecords(Long userprofileId) {
		List<Immunization> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(IMMUNIZATION).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String immunizatiosJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<Immunization>>() {}.getType();
				dtoList = gson.fromJson(immunizatiosJson, type);
				
				Collections.sort(dtoList, new Comparator<Immunization>(){

					@Override
					public int compare(Immunization o1, Immunization o2) {
						int c = 0;
						if (o1.getDateReceived() == null || o2.getDateReceived() == null)
					        return 0;
						return o1.getDateReceived().compareTo(o2.getDateReceived());
						
					}
					
				});
				
				log.debug("Immunization Records :" + dtoList.size());
			} else {
				log.error("Error in Find Immunization Records");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Immunization Records:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		
		if(dtoList==null || dtoList.isEmpty()) {
			displayEmptyMessage=true;
			displayViewMessage=false;
		}
		else {
			displayViewMessage=true;
			displayEmptyMessage=false;			
		}
		
		return dtoList;
	}

	public String showDetail(Immunization immunization) {
		resetMessages();
		selectedImmunizationRecord = immunization;
		return "immunization";
	}
	
	public String editDisplay(Immunization immunization) {
		resetMessages();
		selectedImmunizationRecord = immunization;
		return "editImmunizationDisplay";
	}

	public String deleteDisplay(Immunization immunization) {
		resetMessages();
		selectedImmunizationRecord = immunization;
		setDeleteOrigin("tableView");
		return "deleteImmunizationDisplay";
	}
	
	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteImmunizationDisplay";
	}

	
	public String addDisplay() {
		resetMessages();
		newImmunizationRecord=new Immunization();
		newImmunizationRecord.setDateReceived(new Date());
		return "addImmunizationDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			immunizationRecords = findImmunizationRecords(userprofileId);
		}
		newImmunizationRecord=new Immunization();
		newImmunizationRecord.setDateReceived(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/immunization/addImmunizationDisplay.xhtml");
		return null;
	}
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String imid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("imid");
		if (imid != null) {
			Long id = Long.valueOf(imid);
			selectedImmunizationRecord=findImmunizationRecordById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/immunization/immunization.xhtml");
		return null;
	}
	
	
	public String dashboardViewMore(){
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			immunizationRecords = findImmunizationRecords(userprofileId);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		     handleNavigation(context, null, "/views/immunization/immunizationList.xhtml");
		return null;
	}


	
	private Immunization findImmunizationRecordById(Long id) {
		Immunization dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(IMMUNIZATION_RECORD_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String immunizationJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(immunizationJson, Immunization.class);
			} else {
				log.error("Error in Find Immunization record By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Immunization record By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String imid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("imid");
		try{
			if (imid != null) {
				Long id = Long.valueOf(imid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_IMMUNIZATION_RECORD).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Immunization Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					immunizationRecords = findImmunizationRecords(userprofileId);
					outcome="immunizationList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Immunization record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response =saveImmunizationRecord(responseReader);
			if(response.isSuccess()){
				outcome="immunizationList";
				immunizationRecords = findImmunizationRecords(userprofileId);
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Immunization record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public ResponseUtil saveImmunizationRecord(Reader responseReader) {
		resetMessages();
		String imid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("imid");
		Immunization immunizationRecord=null;
		if (imid != null) {
			immunizationRecord=getSelectedImmunizationRecord();
		}else{
			immunizationRecord=getNewImmunizationRecord();
		}
		Gson gson = getGson();
		WebClient client= getWebClient().path(IMMUNIZATION).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		immunizationRecord.setUserprofileId(getUserProfileId());
		String immunizationJson = gson.toJson(immunizationRecord);
		responseReader = new InputStreamReader((InputStream) client.post(immunizationJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}


	public String saveAndAdd() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response=saveImmunizationRecord(responseReader);
			if(response.isSuccess()){
				outcome="addImmunizationDisplay";
				saveAndAddMessage = true;
				immunizationRecords = findImmunizationRecords(userprofileId);
				newImmunizationRecord=new Immunization();
				newImmunizationRecord.setDateReceived(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Immunization record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}
	
	public String printerFriendlySummary(){
		imTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("immunizationForm:immunizationList");
		return "printImmunizationSummary";
	}
	
	
	public String backToList(){
		resetMessages();
		return "immunizationList";
	}

	public List<Immunization> getImmunizationRecords() {
		return immunizationRecords;
	}

	public void setImmunizationRecords(List<Immunization> immunizationRecords) {
		this.immunizationRecords = immunizationRecords;
	}

	public DataTable getImTable() {
		return imTable;
	}

	public void setImTable(DataTable imTable) {
		this.imTable = imTable;
	}

	public Immunization getSelectedImmunizationRecord() {
		return selectedImmunizationRecord;
	}

	public void setSelectedImmunizationRecord(
			Immunization selectedImmunizationRecord) {
		this.selectedImmunizationRecord = selectedImmunizationRecord;
	}

	public Immunization getNewImmunizationRecord() {
		return newImmunizationRecord;
	}

	public void setNewImmunizationRecord(Immunization newImmunizationRecord) {
		this.newImmunizationRecord = newImmunizationRecord;
	}

	public boolean isDisplayEmptyMessage() {
		return displayEmptyMessage;
	}

	public void setDisplayEmptyMessage(boolean displayEmptyMessage) {
		this.displayEmptyMessage = displayEmptyMessage;
	}

	public boolean isDisplayViewMessage() {
		return displayViewMessage;
	}

	public void setDisplayViewMessage(boolean displayViewMessage) {
		this.displayViewMessage = displayViewMessage;
	}
	
}
