package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.CommonUtility;
import gov.va.med.mhv.health.web.form.bean.Allergy;
import gov.va.med.mhv.health.web.form.bean.Immunization;
import gov.va.med.mhv.health.web.form.bean.VAAllergy;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

@ManagedBean
@Component
@Scope("session")
public class HealthHistoryController  extends AbstractController{
	private static final long serialVersionUID = 4224228548328252610L;
	private static Logger log = LogManager.getLogger(HealthHistoryController.class);
	private List<Allergy> allergyRecords = new ArrayList<Allergy>();;
	private List<Immunization> immunizationRecords = new ArrayList<Immunization>();
	private static final String ALLERGY="dashboardAllergy";
	private static final String IMMUNIZATION="dashboardImmunization";
	private String lastupdatedDate;
	PatientDTO patientDTO ;
	private List<VAAllergy> vaAllergyRecords = new ArrayList<VAAllergy>();
	private static final String VA_ALLERGY="dashboardvaallergy";
	
	private String basicAccount;

	
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String accountType = (String) session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE);
		log.debug("===HealthHistory== actountTYpe:" + accountType);
		
		if (accountType.equalsIgnoreCase("Basic")){
			
			setBasicAccount("True");
			
		}
		
		log.debug("===HealthHistory== getBasicAccount:" + getBasicAccount());
		Long userprofileId = getUserProfileId();
		Reader responseReader=null;
		try{
			if(userprofileId != null){
				patientDTO = getPatient(userprofileId);
				if(patientDTO != null){
					if(!FacesContext.getCurrentInstance().isPostback()){
						refreshAllergyData();
					}
					if(lastupdatedDate== null ){
						getRefreshStatus();
					}
					vaAllergyRecords=findVAAllergyRecords(patientDTO.getId(),responseReader);
				 }
			  allergyRecords = findAllergyRecords(userprofileId,responseReader);
			  immunizationRecords=findImmunizationRecords(userprofileId,responseReader);
			  
		     }
		}catch (Exception e){
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
	}
	
	
	private List<VAAllergy> findVAAllergyRecords(Long patientId,Reader responseReader) {
		List<VAAllergy> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(VA_ALLERGY).path(patientId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String allergiesJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<VAAllergy>>() {}.getType();
				dtoList = gson.fromJson(allergiesJson, type);
				
				log.debug("VA Allergy Records :" + dtoList.size());
			} else {
				log.error("Error in Find VA Allergy Records");
				WebServiceClientUtil.showErrorMessage();
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));	    }
		return dtoList;
	}

	
	
	private void refreshAllergyData(){
		WebClient client= getPHRManagerWebClient().path("refresh").path(patientDTO.getIcn()).path("Allergy").
				         accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse=client.post(null);
		if(webserviceResponse.getStatus() == 200){
			log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
		}else{
			log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
	}
	
	
	public String getRefreshStatus(){
		   log.debug("Inside  PHR-status service");
		   if(patientDTO != null){
			   GsonBuilder builder = new GsonBuilder(); 
			   builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() { 
				@Override
				public Date deserialize(JsonElement json, Type typeOfT,
						JsonDeserializationContext context)
						throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong()); 
				} 
				});
			   Gson gson = builder.create();
			   WebClient client= getPHRManagerWebClient().path("status").path(patientDTO.getIcn()).
				         accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			   Response webserviceResponse =client.get();
			   Date lastModified=null; 
			   if(webserviceResponse.getStatus() == 200){
				   Reader responseReader= new InputStreamReader ((InputStream)webserviceResponse.getEntity());
				   PatientExtractStatus patientExtractStatus= gson.fromJson(responseReader,PatientExtractStatus.class);
				   String FacilityExtractStatusjson=gson.toJson(patientExtractStatus.getFacilityExtractStatusList()) ;   
				   Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				   Gson gson1= new Gson();
				   List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				   for(FacilityExtractStatus extractStatus : facilityStausList){
					   if(extractStatus.getExtract().trim().equals("Allergy")){
						   lastModified = extractStatus.getLastModified();
						   break;
					   }
				   }
				   if(lastModified != null){
					   lastupdatedDate=CommonUtility.dateToStringTimeZone(lastModified,"MM/dd/yyyy") +
							   "  at  "+CommonUtility.dateToStringTimeZone(lastModified,"HH:mm"); 
					   vaAllergyRecords=findVAAllergyRecords(patientDTO.getId(),responseReader);
				   }
				   
			   }else{
				   log.error("Error invoking PHR status service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			   }
	       }
		   return null;
	}

	private List<Allergy> findAllergyRecords(Long userprofileId,Reader responseReader) {
		List<Allergy> dtoList = null;
		
		Gson gson = getGson();
	    WebClient client= getWebClient().path(ALLERGY).path(userprofileId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String allergiesJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<Allergy>>() {}.getType();
				dtoList = gson.fromJson(allergiesJson, type);
				
				log.debug("Allergy Records :" + dtoList.size());
			} else {
				log.error("Error in Find Allergy Records");
				throw new RuntimeException(response.getFailureMessage());
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
	    }
		
		return dtoList;
	}

	
	private List<Immunization> findImmunizationRecords(Long userprofileId,Reader responseReader) {
		List<Immunization> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(IMMUNIZATION).path(userprofileId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String immunizatiosJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<Immunization>>() {}.getType();
				dtoList = gson.fromJson(immunizatiosJson, type);
				
				log.debug("Immunization Records :" + dtoList.size());
			} else {
				log.error("Error in Find Immunization Records");
				throw new RuntimeException(response.getFailureMessage());
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
	    }
		return dtoList;
	}



	public List<Allergy> getAllergyRecords() {
		return allergyRecords;
	}



	public void setAllergyRecords(List<Allergy> allergyRecords) {
		this.allergyRecords = allergyRecords;
	}



	public List<Immunization> getImmunizationRecords() {
		return immunizationRecords;
	}



	public void setImmunizationRecords(List<Immunization> immunizationRecords) {
		this.immunizationRecords = immunizationRecords;
	}


	public String getLastupdatedDate() {
		return lastupdatedDate;
	}


	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}




	public List<VAAllergy> getVaAllergyRecords() {
		return vaAllergyRecords;
	}


	public void setVaAllergyRecords(List<VAAllergy> vaAllergyRecords) {
		this.vaAllergyRecords = vaAllergyRecords;
	}


	public String getBasicAccount() {
		return basicAccount;
	}


	public void setBasicAccount(String basicAccount) {
		this.basicAccount = basicAccount;
	}




}
