package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.CommonUtility;
import gov.va.med.mhv.health.web.form.bean.ChemistryLab;
import gov.va.med.mhv.health.web.form.bean.ChemistryPanel;
import gov.va.med.mhv.health.web.form.bean.ChemistryTest;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

@ManagedBean
@Component
@Scope("session")
public class ChemistryLabController extends AbstractController{

	private static final long serialVersionUID = 4254723854808651352L;
	
	private static Logger log = LogManager.getLogger(ChemistryLabController.class);
	private List<ChemistryLab> chemLabRecords = new ArrayList<ChemistryLab>();
	private DataTable chemTable;
	private ChemistryLab selectedChemLabRecord = new ChemistryLab();
	private ChemistryTest selectedChemTestRecord = new ChemistryTest();
	private List<ChemistryTest> chemTestRecords = new ArrayList<ChemistryTest>();
	private DataTable chemTest;
	//ChemistryPanel chemPanel = new  ChemistryPanel();
	private List<ChemistryPanel> chemPaenlRecords = new ArrayList<ChemistryPanel>();
	private static final String CHEM_LAB="chemlab";
	private static final String CHEM_PANEL="chempanel";
	private String lastupdatedDate;
	PatientDTO patientDTO ;
	private static final String DFORMAT="EEE MMM dd HH:mm:ss yyyy";
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		chemTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("chemlabForm:chemLabList");
		chemTest = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("chemlabForm:chemTestList");

		try{
			if (userprofileId != null) {
					if(!FacesContext.getCurrentInstance().isPostback()){
						resetMessages();						
						patientDTO = getPatient(userprofileId);
						if(patientDTO != null){							
							refreshChemistryHematologyData();
						}
						setRowsPerPage(10);
					}
					else{
						if(sortColumn != null && sortBy != null){
							chemTable.setValueExpression("sortBy", sortColumn);
							chemTable.setSortOrder(sortBy);
							chemTest.setValueExpression("sortBy", sortColumn);
							chemTest.setSortOrder(sortBy);
						} 
					}
					if(lastupdatedDate== null ){
					   getRefreshStatus();
					}
					if(patientDTO != null){		
						chemLabRecords = findChemLabRecords(patientDTO.getId());
					}
			}
			
	    }catch(Exception e){
	    	log.error("Error in Finding Chem Lab Records::"+ e.getMessage());
	    	WebServiceClientUtil.showErrorMessage();
	    }
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	
	private void refreshChemistryHematologyData(){
		
		WebClient client= getPHRManagerWebClient().path("refresh").path(patientDTO.getIcn()).path("ChemistryHematology").
				         accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse=client.post(null);
		if(webserviceResponse.getStatus() == 200){
			log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
		}else{
			log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		}
	}
	
	
	public String getRefreshStatus(){
		   log.debug("Inside  PHR-status service");
		   if(patientDTO != null){
			   GsonBuilder builder = new GsonBuilder(); 
			   builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() { 
				@Override
				public Date deserialize(JsonElement json, Type typeOfT,
						JsonDeserializationContext context)
						throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong()); 
				} 
				});
			   Gson gson = builder.create();
			   WebClient client= getPHRManagerWebClient().path("status").path(patientDTO.getIcn()).
				         accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			   Response webserviceResponse =client.get();
			   Date lastModified=null; 
			   if(webserviceResponse.getStatus() == 200){
				   Reader responseReader= new InputStreamReader ((InputStream)webserviceResponse.getEntity());
				   PatientExtractStatus patientExtractStatus= gson.fromJson(responseReader,PatientExtractStatus.class);
				   String FacilityExtractStatusjson=gson.toJson(patientExtractStatus.getFacilityExtractStatusList()) ;   
				   Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				   Gson gson1= new Gson();
				   List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				   for(FacilityExtractStatus extractStatus : facilityStausList){
					   if(extractStatus.getExtract().trim().equals("ChemistryHematology")){
						   lastModified = extractStatus.getLastModified();
						   break;
					   }
				   }
				   if(lastModified != null){
					   lastupdatedDate=CommonUtility.dateToStringTimeZone(lastModified,"MM/dd/yyyy") +
							   "  at  "+CommonUtility.dateToStringTimeZone(lastModified,"HH:mm"); 
					   
					   chemLabRecords = findChemLabRecords(patientDTO.getId());
				   }
				   
			   }else{
				   log.error("Error invoking PHR status service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			   }
	       }
		   return null;
	}

	private List<ChemistryLab> findChemLabRecords(Long patientId) {
		List<ChemistryLab> dtoList = null;
		Reader responseReader=null;
		Gson gson = getGsonTimeStamp();
	    WebClient client= getWebClient().path(CHEM_LAB).path(patientId).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String allergiesJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<ChemistryLab>>() {}.getType();
				dtoList = gson.fromJson(allergiesJson, type);
				
				log.debug("Chemistry Lab Records :" + dtoList.size());
			} else {
				log.error("Error in Find Chemistry Lab Records",response.getFailureMessage());
				WebServiceClientUtil.showErrorMessage();
			}
	    }else{
	    	throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));	    }
		return dtoList;
	}

	public String chemTestList(ChemistryLab chemistryLab) {
		resetMessages();
		selectedChemLabRecord = chemistryLab;
		findChemTestRecords(selectedChemLabRecord.getPatientId(),selectedChemLabRecord.getChemistryLabId());
		return "chemTestList";
	}

	private void findChemTestRecords(Long patientid,Long chemlabid) {
		Reader responseReader=null;
		Gson gson = getGsonTimeStamp();
	    WebClient client= getWebClient().path(CHEM_PANEL).path(patientid).path(chemlabid).accept(CONTENT_TYPE);
	    Response webserviceResponse =client.get();
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String chempaneljson = gson.toJson(response.getPojoObject());
				Type type1 = new TypeToken<List<ChemistryPanel>>() {}.getType();
				chemPaenlRecords  = gson.fromJson(chempaneljson, type1);
				chemTestRecords=new ArrayList<ChemistryTest>();
				if(chemPaenlRecords != null){
					for(ChemistryPanel chem:chemPaenlRecords){
						String chemtestjson =gson.toJson(chem.getChemistryTests());
						Type type = new TypeToken<List<ChemistryTest>>() {}.getType();
						List<ChemistryTest> tempchemTestRecords = new ArrayList<ChemistryTest>();
						tempchemTestRecords = gson.fromJson(chemtestjson, type);
						if(tempchemTestRecords != null){
						   chemTestRecords.addAll(tempchemTestRecords);
						}
					}
				}
				if(chemTestRecords != null && chemTestRecords.size() > 0){
				   Collections.sort(chemTestRecords);
				}
				log.debug("Chemistry Test Records :" + chemTestRecords.size());
			} else {
				log.error("Error in Find Chemistry Panel:",response.getFailureMessage());
				WebServiceClientUtil.showErrorMessage();
			}
	    }else{
	    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));	   
	    	WebServiceClientUtil.showErrorMessage();
	   	}
	}
	
	public String chemTestDetail(ChemistryTest chemistryTest) {
		resetMessages();
		selectedChemTestRecord = chemistryTest;
		return "chemTest";
	}

	
	public String dashboardViewMore(){
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		patientDTO = getPatient(userprofileId);
		if(patientDTO != null){		
			chemLabRecords = findChemLabRecords(patientDTO.getId());
		}
		/*FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/chemistrylab/chemLabList.xhtml");*/
		return "/views/chemistrylab/chemLabList";
	}
	
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String vaid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("vaid");
		String patid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("patid");
		String source = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("source");
		String location = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("location");
		String collDate = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("collDate");
		if (vaid != null) {
			Long id = Long.valueOf(vaid);
			Long patientid=Long.valueOf(patid);
			findChemTestRecords(patientid,id);
			selectedChemLabRecord.setSpecimenSource(source);
			selectedChemLabRecord.setOrderingLocation(location);
			StringBuffer sb=new StringBuffer();
			sb.append(collDate.substring(0,19)).append(" ").append(collDate.substring(24));
			Date CollectDate = CommonUtility.stringToDate(sb.toString(),DFORMAT);
			selectedChemLabRecord.setCollectedDatePrecise(CollectDate);
			
		}	
		/*FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../chemistrylab/chemTestList.xhtml");*/
		return "/views/chemistrylab/chemTestList";
	}

	
	
	public String printChemTestSummary(){
		chemTest = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("chemlabForm:chemTestList");
		return "printChemTestSummary";
	}
	
	public String printChemLabSummary(){
		chemTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("chemlabForm:chemLabList");
		return "printChemLabSummary";
	}
	
	public List<ChemistryLab> getChemLabRecords() {
		return chemLabRecords;
	}

	public void setChemLabRecords(List<ChemistryLab> chemLabRecords) {
		this.chemLabRecords = chemLabRecords;
	}

	public DataTable getChemTable() {
		return chemTable;
	}

	public void setChemTable(DataTable chemTable) {
		this.chemTable = chemTable;
	}

	public ChemistryLab getSelectedChemLabRecord() {
		return selectedChemLabRecord;
	}

	public void setSelectedChemLabRecord(ChemistryLab selectedChemLabRecord) {
		this.selectedChemLabRecord = selectedChemLabRecord;
	}

	public DataTable getChemTest() {
		return chemTest;
	}

	public void setChemTest(DataTable chemTest) {
		this.chemTest = chemTest;
	}

	

	public ChemistryTest getSelectedChemTestRecord() {
		return selectedChemTestRecord;
	}

	public void setSelectedChemTestRecord(ChemistryTest selectedChemTestRecord) {
		this.selectedChemTestRecord = selectedChemTestRecord;
	}

	public List<ChemistryTest> getChemTestRecords() {
		return chemTestRecords;
	}

	public void setChemTestRecords(List<ChemistryTest> chemTestRecords) {
		this.chemTestRecords = chemTestRecords;
	}

	public List<ChemistryPanel> getChemPaenlRecords() {
		return chemPaenlRecords;
	}

	public void setChemPaenlRecords(List<ChemistryPanel> chemPaenlRecords) {
		this.chemPaenlRecords = chemPaenlRecords;
	}


	public String getLastupdatedDate() {
		return lastupdatedDate;
	}


	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}
}
