package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.web.form.bean.Allergy;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class AllergyController extends AbstractController{
	
	private static final long serialVersionUID = -155245885106726822L;
	private static Logger log = LogManager.getLogger(AllergyController.class);
	private List<Allergy> allergyRecords = new ArrayList<Allergy>();
	private DataTable alTable;
	private Allergy selectedAllergyRecord = new Allergy();
	private Allergy newAllergyRecord = new Allergy();
	private boolean displayEmptyMessage=false;
	private boolean displayViewMessage=false;
	private static final String ALLERGY="allergy";
	private static final String DELETE_ALLERGY_RECORD="deleteAllergyRecord";
	private static final String ALLERGY_RECORD_BY_ID="allergyRecordByid";
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		alTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("allergyForm:allergyList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			if (userprofileId != null) {
				allergyRecords = findAllergyRecords(userprofileId);
			}
			setRowsPerPage(10);
		}
		else{
			if(sortColumn != null && sortBy != null){
				alTable.setValueExpression("sortBy", sortColumn);
				alTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<Allergy> findAllergyRecords(Long userprofileId) {
		List<Allergy> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(ALLERGY).path(userprofileId).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String allergiesJson = gson.toJson(response.getPojoObject());
					Type type = new TypeToken<List<Allergy>>() {}.getType();
					dtoList = gson.fromJson(allergiesJson, type);
					
					log.debug("Allergy Records :" + dtoList.size());
				} else {
					log.error("Error in Find Immunization Records");
					WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Immunization Records:", e.getMessage());
			log.error("Error in Find Immunization Records:", e.getMessage());
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		
		if(dtoList==null || dtoList.isEmpty()) {
			displayEmptyMessage=true;
			displayViewMessage=false;
		}
		else {
			displayViewMessage=true;
			displayEmptyMessage=false;			
		}
		
		return dtoList;
	}

	public String showDetail(Allergy allergy) {
		resetMessages();
		selectedAllergyRecord = allergy;
		return "allergy";
	}
	
	public String editDisplay(Allergy allergy) {
		resetMessages();
		selectedAllergyRecord = allergy;
		return "editAllergyDisplay";
	}

	public String deleteDisplay(Allergy allergy) {
		resetMessages();
		selectedAllergyRecord = allergy;
		setDeleteOrigin("tableView");
		return "deleteAllergyDisplay";
	}
	
	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteAllergyDisplay";
	}
	
	public String addDisplay() {
		resetMessages();
		newAllergyRecord=new Allergy();
		newAllergyRecord.setEventDate(new Date());
		return "addAllergyDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			allergyRecords = findAllergyRecords(userprofileId);
		}
		newAllergyRecord=new Allergy();
		newAllergyRecord.setEventDate(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/allergy/addAllergyDisplay.xhtml");
		
		return null;
	}
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		String alid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("alid");
		if (alid != null) {
			Long id = Long.valueOf(alid);
			selectedAllergyRecord=findAllergyRecordById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/allergy/allergy.xhtml");
		return null;
	}
	
	public String dashboardViewMore(){
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			allergyRecords = findAllergyRecords(userprofileId);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/allergy/allergyList.xhtml");
		return null;
	}

	
	private Allergy findAllergyRecordById(Long id) {
		Allergy dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(ALLERGY_RECORD_BY_ID).path(id).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String allergyJson = gson.toJson(response.getPojoObject());
					dto = gson.fromJson(allergyJson, Allergy.class);
				} else {
					log.error("Error in Find Allergy record By id",response.getFailureMessage());
			    	WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Allergy record By id:", e);
	    	WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String alid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("alid");
		try{
			if (alid != null) {
				Long id = Long.valueOf(alid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_ALLERGY_RECORD).path(id).accept(CONTENT_TYPE);
			    Response webserviceResponse =client.delete();
			    if(webserviceResponse.getStatus() == 200){
					responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
					ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
					if (!response.isSuccess()) {
						log.debug("Failed to Delete Allergy Record" ,response.getFailureMessage());
						WebServiceClientUtil.showErrorMessage();
					}else{
						deleteMessage = true;
						allergyRecords = findAllergyRecords(userprofileId);
						outcome="allergyList";
					}
			    }else{
			    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			    	WebServiceClientUtil.showErrorMessage();
			    }
			}
		}catch(Exception e){
			log.error("Failed to Delete Allergy record",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response =saveAllergyRecord(responseReader);
			if(response.isSuccess()){
				outcome="allergyList";
				allergyRecords = findAllergyRecords(userprofileId);
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Allergy record",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public ResponseUtil saveAllergyRecord(Reader responseReader) {
		resetMessages();
		ResponseUtil response=new ResponseUtil();
		String alid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("alid");
		Allergy allergyRecord=null;
		if (alid != null) {
			allergyRecord=getSelectedAllergyRecord();
		}else{
			allergyRecord=getNewAllergyRecord();
		}
		Gson gson = getGson();
		WebClient client= getWebClient().path(ALLERGY).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		allergyRecord.setUserprofileId(getUserProfileId());
		String allergyJson = gson.toJson(allergyRecord);
	    Response webserviceResponse =client.post(allergyJson);
	    if(webserviceResponse.getStatus() == 200){
			responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			response = gson.fromJson(responseReader, ResponseUtil.class);
			if(!response.isSuccess()){
				Map<String, String> map = response.getValidationErrors();
				for (Map.Entry<String, String> entry : map.entrySet()) {
					if (null != entry) {
						log.debug("entry.getKey() : " + entry.getKey());
						log.debug("entry.getValue() : " + entry.getValue());
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
				}
			}
	    }else{
	    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
	    	WebServiceClientUtil.showErrorMessage();
	    }
		return response;
	}


	public String saveAndAdd() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response=saveAllergyRecord(responseReader);
			if(response.isSuccess()){
				outcome="addAllergyDisplay";
				saveAndAddMessage = true;
				newAllergyRecord=new Allergy();
				newAllergyRecord.setEventDate(new Date());
				allergyRecords = findAllergyRecords(userprofileId);
			}
		}catch(Exception e){
			log.error("Failed to Save Immunization record",e);
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}
		return outcome;
	}
	
	public String printerFriendlySummary(){
		alTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("allergyForm:allergyList");
		return "printAllergySummary";
	}
	
	public String backToList(){
		resetMessages();
		return "allergyList";
	}

	public List<Allergy> getAllergyRecords() {
		return allergyRecords;
	}

	public void setAllergyRecords(List<Allergy> allergyRecords) {
		this.allergyRecords = allergyRecords;
	}

	public DataTable getAlTable() {
		return alTable;
	}

	public void setAlTable(DataTable alTable) {
		this.alTable = alTable;
	}

	public Allergy getSelectedAllergyRecord() {
		return selectedAllergyRecord;
	}

	public void setSelectedAllergyRecord(Allergy selectedAllergyRecord) {
		this.selectedAllergyRecord = selectedAllergyRecord;
	}

	public Allergy getNewAllergyRecord() {
		return newAllergyRecord;
	}

	public void setNewAllergyRecord(Allergy newAllergyRecord) {
		this.newAllergyRecord = newAllergyRecord;
	}

	public boolean isDisplayEmptyMessage() {
		return displayEmptyMessage;
	}

	public void setDisplayEmptyMessage(boolean displayEmptyMessage) {
		this.displayEmptyMessage = displayEmptyMessage;
	}

	public boolean isDisplayViewMessage() {
		return displayViewMessage;
	}

	public void setDisplayViewMessage(boolean displayViewMessage) {
		this.displayViewMessage = displayViewMessage;
	}

}
