package gov.va.med.mhv.health.web.controller;

import java.io.Serializable;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;
import gov.va.med.mhv.usermgmt.service.PatientWebService;

@PropertySources(value = { @PropertySource("classpath:/${MHV_ENV_PROPERTY}.application.properties"),
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.properties") })
public abstract class AbstractController implements Serializable {

	private static final String LIFERAY_SESSION_PATIENT_DTO = "LIFERAY_SHARED_patientdto";
	private static final String LIFERAY_SESSION_USERPROFILE_DTO = "LIFERAY_SHARED_userprofileid";

	private static final long serialVersionUID = -8611610134485398648L;
	private static Logger log = LogManager.getLogger(AbstractController.class);
	private String firstName;
	private String lastName;
	protected static final String DEFAULT_HOUR = "23";
	protected static final String DEFAULT_MINUTE = "59";
	protected static final String DEFAULT_DATETIME = "23:59";
	protected static final String HOUR_MINUTE = "HH:mm";
	protected static final String HOURS = "HH";
	protected static final String MINUTES = "mm";
	protected Boolean saveMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteMessage = false;
	protected String period;
	protected static final String YYYYMMDD_FORMAT = "yyyyMMdd";
	protected static final String YYYY_MM_DD_HHMMSS_FORMAT = "yyyy-MM-dd";
	protected static final String CHART_EXTENDER = "chartExtender";
	protected static final String DAYS = "dd";
	protected static final String MONTHS = "MM";
	protected static final String YEARS = "yyyy";
	protected static final String NO_DATA = "No data available";
	protected static final String ERR_PRCS_RQST = "Error Processing request";
	protected static final String CONTENT_TYPE = "application/json";
	protected static final String authenticationHeader = "X-Authorization-Key";
	private String deleteOrigin;

	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;

	@Value("${endpointUrl}")
	private String endpointUrl;

	@Autowired
	protected ObjectMapper mapper;

	@Resource(name = "patientServiceProxy")
	protected PatientWebService patientService;

	@Value("${phrManagerendpointUrl}")
	private String phrManagerendpointUrl;

	@Value("${phrmgr.xauth.key}")
	private String authenticationHeaderValue;

	@Value("${appContextroot}")
	private String appContextRoot;

	protected WebClient getWebClient() {
		log.debug("Health History endpoint##:");
		log.debug(endpointUrl);
		return WebClient.create(endpointUrl);
	}

	protected WebClient getPHRManagerWebClient() {
		log.debug("PHR Manager endpoint##:");
		log.debug(phrManagerendpointUrl);
		return WebClient.create(getPhrManagerendpointUrl());
	}

	protected Gson getGsonTimeStamp() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").serializeNulls().create();
	}

	protected Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").serializeNulls().create();
	}

	protected Gson getGsonWithoutDateFormat() {
		return new GsonBuilder().serializeNulls().create();
	}

	protected Gson getGsonTimeMilli() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS a").serializeNulls().create();
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		return context;
	}

	public void findUser() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {

		}
		if (user != null) {
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}

	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}

	protected PatientDTO getPatient(Long userProfileid) {
		log.debug("Inside Get patient");
		PatientDTO patientDTO = null;

		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();

		try {
			String patientJson = (String) session.getAttribute(LIFERAY_SESSION_PATIENT_DTO,
					PortletSession.APPLICATION_SCOPE);
			if (patientJson != null) {
				patientDTO = mapper.readValue(patientJson, PatientDTO.class);
			} else {

				patientDTO = this.patientService.getPatientByUserProfileId(userProfileid);
				if (patientDTO != null) {
					session.setAttribute(LIFERAY_SESSION_PATIENT_DTO, mapper.writeValueAsString(patientDTO));
				}

			}
		} catch (MHVException e) {
			log.error("Error in Get Patient", e.getFailureMessage());
			WebServiceClientUtil.showErrorMessage();
			throw new RuntimeException(WebServiceClientUtil.formatErrorMessage(e));
		} catch (Exception e) {
			WebServiceClientUtil.showErrorMessage();
			throw new RuntimeException(e);
		}

		return patientDTO;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	protected void resetMessages() {
		saveMessage = false;
		saveAndAddMessage = false;
		deleteMessage = false;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}

	public String getDeleteOrigin() {
		return deleteOrigin;
	}

	public void setDeleteOrigin(String deleteOrigin) {
		this.deleteOrigin = deleteOrigin;
	}

	public PatientWebService getPatientService() {
		return patientService;
	}

	public String getPhrManagerendpointUrl() {
		return phrManagerendpointUrl;
	}

	public void setPhrManagerendpointUrl(String phrManagerendpointUrl) {
		this.phrManagerendpointUrl = phrManagerendpointUrl;
	}

	public String getAuthenticationHeaderValue() {
		return authenticationHeaderValue;
	}

	public void setAuthenticationHeaderValue(String authenticationHeaderValue) {
		this.authenticationHeaderValue = authenticationHeaderValue;
	}

	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}

}
