package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.MilitaryHistoryConverter;
import gov.va.med.mhv.health.dto.MilitaryHistoryDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.MilitaryHistory;
import gov.va.med.mhv.health.repository.MilitaryHistoryRepository;
import gov.va.med.mhv.health.service.MilitaryHistoryService;
import gov.va.med.mhv.health.validator.MilitaryHistoryValidator;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MilitaryHistoryServiceImpl  implements MilitaryHistoryService{
	
	private static Logger log = LogManager.getLogger(MilitaryHistoryServiceImpl.class);
	
	@Autowired
	private MilitaryHistoryRepository militaryHistoryRepository;
	
	@Autowired
	private MilitaryHistoryValidator validator;

	@Override
	public ResponseUtil save(MilitaryHistoryDTO militaryHistoryDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.militaryHistoryValidations(response, militaryHistoryDTO);
		if(response.getValidationErrors().size() == 0){
			MilitaryHistory militaryHistory = MilitaryHistoryConverter.convertMilitaryHistoryDTO(militaryHistoryDTO);
			try {
				
				militaryHistoryRepository.save(militaryHistory);	
				
				}
			catch (Exception e ) {
				response.setFailure(true);
				response.setSuccess(false);
				log.debug("Exception thrown on save=" + e.toString());
			}
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Military History record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		militaryHistoryRepository.delete(id);
		response.setSuccess(true);
		
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		MilitaryHistory militaryHistory = militaryHistoryRepository.findOne(id);
		if(militaryHistory != null){
			MilitaryHistoryDTO militaryHistoryRecordDTO = MilitaryHistoryConverter.convertMilitaryHistoryRecordDomain(militaryHistory);
			response.setPojoObject(militaryHistoryRecordDTO);
			response.setSuccess(true);
		}else{
			log.debug("Military History record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil findMilitaryHistoryForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<MilitaryHistory> militaryHistories=militaryHistoryRepository.getMilitaryHistoryForUser(userprofileid);
				
		if(militaryHistories != null){
			List<MilitaryHistoryDTO> dtos = MilitaryHistoryConverter.convertMilitaryHistoryRecords(militaryHistories);
			response.setPojoObject(dtos);
		}else{
			log.debug("Military History Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}
	
	
	

}
