package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.MedicalEventConverter;
import gov.va.med.mhv.health.dto.MedicalEventDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.MedicalEvent;
import gov.va.med.mhv.health.repository.MedicalEventRepository;
import gov.va.med.mhv.health.service.MedicalEventService;
import gov.va.med.mhv.health.validator.MedicalEventValidator;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class MedicalEventServiceImpl  implements MedicalEventService{
	
	private static Logger log = LogManager.getLogger(MedicalEventServiceImpl.class);
	
	@Autowired
	private MedicalEventRepository medicalEventRepository;
	
	
	@Autowired
	private MedicalEventValidator validator;


	@Override
	public ResponseUtil save(MedicalEventDTO medicalEventDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.medicalEventValidations(response, medicalEventDTO);
		if(response.getValidationErrors().size() == 0){
			MedicalEvent medicalEvent = MedicalEventConverter.convertMedicalEventDTO(medicalEventDTO);
			medicalEventRepository.save(medicalEvent);
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Medical Event record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		medicalEventRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		MedicalEvent medicalEvent = medicalEventRepository.findOne(id);
		if(medicalEvent != null){
			MedicalEventDTO medicalEventDTO = MedicalEventConverter.convertMedicalEventDomain(medicalEvent);
			response.setPojoObject(medicalEventDTO);
			response.setSuccess(true);
		}else{
			log.debug("Medical Event record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil findMedicalEventsForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<MedicalEvent> medicalEvents=medicalEventRepository.getMedicalEventsForUser(userprofileid);
		if(medicalEvents != null){
			List<MedicalEventDTO> dtos = MedicalEventConverter.convertMedicalEventRecords(medicalEvents);
			response.setPojoObject(dtos);
		}else{
			log.debug("Medical Event Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findDashBoardMedicalEventsForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		Pageable topFive = new  PageRequest(0,5);
		List<MedicalEvent> medicalEvents=medicalEventRepository.getDashBoardMedicalEventsForUser(userprofileid, topFive);
		if(medicalEvents != null){
			List<MedicalEventDTO> dtos = MedicalEventConverter.convertMedicalEventRecords(medicalEvents);
			response.setPojoObject(dtos);
		}else{
			log.debug("Dash board Medical Event Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

}
