package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.ImmunizationConverter;
import gov.va.med.mhv.health.dto.ImmunizationDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.Immunization;
import gov.va.med.mhv.health.model.ImmunizationReaction;
import gov.va.med.mhv.health.repository.ImmunizationReactionsRepository;
import gov.va.med.mhv.health.repository.ImmunizationRepository;
import gov.va.med.mhv.health.service.ImmunizationService;
import gov.va.med.mhv.health.validator.ImmunizationValidator;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ImmunizationServiceImpl implements ImmunizationService{
	
	private static Logger log = LogManager.getLogger(ImmunizationServiceImpl.class);
	
	@Autowired
	private ImmunizationRepository immunizationRepository;
	
	@Autowired
	private ImmunizationReactionsRepository reactionRepository;

	
	@Autowired
	private ImmunizationValidator validator;


	@Override
	@Transactional
	public ResponseUtil save(ImmunizationDTO immunizationDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.immunizationValidations(response, immunizationDTO);
		if(response.getValidationErrors().size() == 0){
			Immunization immunization = ImmunizationConverter.convertImmunizationDTO(immunizationDTO);
			if(immunization.getId() != null){
				List<ImmunizationReaction> reactionList =reactionRepository.getImmunizationReactions(immunization.getId());
				if(reactionList != null){
				   reactionRepository.deleteInBatch(reactionList);
				}
			}
			immunizationRepository.save(immunization);
			response.setSuccess(true);
		}else{
			log.debug("Validation Errors in Immunization record save:");
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		immunizationRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		Immunization immunization = immunizationRepository.findOne(id);
		if(immunization != null){
			ImmunizationDTO immunizationDTO = ImmunizationConverter.convertImmunizationDomain(immunization);
			response.setPojoObject(immunizationDTO);
			response.setSuccess(true);
		}else{
			log.debug("Immunization Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil findImmunizationsForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<Immunization> immunizations=immunizationRepository.getImmunizationsForUser(userprofileid);
		if(immunizations != null){
			List<ImmunizationDTO> dtos = ImmunizationConverter.convertImmunizationRecords(immunizations);
			response.setPojoObject(dtos);
		}else{
			log.debug("Immunization Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findDashBoardImmunizationsForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		Pageable topFive = new  PageRequest(0,5);
		List<Immunization> immunizations=immunizationRepository.getDashBoardImmunizationsForUser(userprofileid, topFive);
		if(immunizations != null){
			List<ImmunizationDTO> dtos = ImmunizationConverter.convertImmunizationRecords(immunizations);
			response.setPojoObject(dtos);
		}else{
			log.debug("Dash board Immunization Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

}
