package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.HealthHistoryRecordConverter;
import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.OtherHealthIssueDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.HealthHistoryRecord;
import gov.va.med.mhv.health.model.ImmunizationReaction;
import gov.va.med.mhv.health.model.OtherHealthIssue;
import gov.va.med.mhv.health.repository.HealthHistoryRecordRepository;
import gov.va.med.mhv.health.repository.OtherHealthIssueRepository;
import gov.va.med.mhv.health.service.HealthHistoryService;
import gov.va.med.mhv.health.validator.FamilyValidator;
import gov.va.med.mhv.health.validator.ImmunizationValidator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class HealthHistoryServiceImpl  implements HealthHistoryService{
	
	private static Logger log = LogManager.getLogger(HealthHistoryServiceImpl.class);
	
	@Autowired
	private OtherHealthIssueRepository otherHealthHistoryRepository;
	
	@Autowired
	private HealthHistoryRecordRepository healthHistoryRecordRepository;
	
	@Autowired
	private FamilyValidator validator;

	@Override
	@Transactional
	public ResponseUtil save(HealthHistoryRecordDTO healthHistoryRecordDTO) {
		ResponseUtil response = new ResponseUtil();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.familyValidations(response, healthHistoryRecordDTO);
		if (response.getValidationErrors().size() == 0) {
			HealthHistoryRecord healthHistoryRecord = HealthHistoryRecordConverter.convertHealthHistoryRecordDTO(healthHistoryRecordDTO);
			
			if (null != healthHistoryRecord.getOtherHealthIssues()) {
				for(OtherHealthIssue healthIssue: healthHistoryRecord.getOtherHealthIssues()) {
					healthIssue.setHealthHistoryRecord(healthHistoryRecord);
				}
			}
			
			try {
				/*if (healthHistoryRecord.getId() != null) {
					List<OtherHealthIssue> otherHealthIssueList = otherHealthHistoryRepository.getOtherHealthIssues(healthHistoryRecord.getId());
					
					if (otherHealthIssueList != null && otherHealthIssueList.size() > 0) {
						otherHealthHistoryRepository.deleteInBatch(otherHealthIssueList);
					}
				}*/
				
				healthHistoryRecord = healthHistoryRecordRepository.save(healthHistoryRecord);
				response.setSuccess(true);
				response.setPojoObject(HealthHistoryRecordConverter.convertHealthHistoryRecordDomain(healthHistoryRecord));
			} catch (Exception e ) {
				response.setFailure(true);
				response.setSuccess(false);
				log.debug("Exception thrown on save=" + e.toString());
			}
		}	
		else {
			log.debug("Validation Errors in Health History record save:");
		}
				
		return response;
	}
		

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		healthHistoryRecordRepository.delete(id);
		response.setSuccess(true);
		return response;
	}
	
	@Override
	public ResponseUtil deleteHealthIssue(Long id) {
		ResponseUtil response = new ResponseUtil();
		OtherHealthIssue otherHealthIssue = null;
		HealthHistoryRecord healthHist = null;
		Long healthHistId = null;
		
		try {
			otherHealthIssue = otherHealthHistoryRepository.findOne(id);
			healthHistId = otherHealthIssue.getHealthHistId();
			healthHist = healthHistoryRecordRepository.findOne(healthHistId);
			healthHist.getOtherHealthIssues().remove(otherHealthIssue);
			healthHistoryRecordRepository.save(healthHist);
		} catch (Exception e) {
			response.setFailure(true);
			response.setSuccess(false);
			log.debug("Exception thrown on deleteHealthIssue=" + e.toString());
		}
		
		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(HealthHistoryRecordConverter.convertHealthHistoryRecordDomain(healthHist));
		
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		HealthHistoryRecord healthHistoryRecord = healthHistoryRecordRepository.findOne(id);
		if(healthHistoryRecord != null){
			HealthHistoryRecordDTO healthHistoryRecordDTO = HealthHistoryRecordConverter.convertHealthHistoryRecordDomain(healthHistoryRecord);
			response.setPojoObject(healthHistoryRecordDTO);
			response.setSuccess(true);
		}else{
			log.debug("Health History record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil findHealthHistoryForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<HealthHistoryRecord> healthHistoryRecords=healthHistoryRecordRepository.getHealthHistoryRecordsForUser(userprofileid);
		if(healthHistoryRecords != null){
			List<HealthHistoryRecordDTO> dtos = HealthHistoryRecordConverter.convertHealthHistoryRecords(healthHistoryRecords);
			response.setPojoObject(dtos);
		}else{
			log.debug("Health History Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}
}
