package gov.va.med.mhv.health.service.impl;

import gov.va.med.mhv.health.converter.ChemistryLabConverter;
import gov.va.med.mhv.health.dto.ChemistryLabDTO;
import gov.va.med.mhv.health.dto.ChemistryPanelDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.model.ChemistryLab;
import gov.va.med.mhv.health.model.ChemistryPanel;
import gov.va.med.mhv.health.repository.ChemistryLabRepository;
import gov.va.med.mhv.health.repository.ChemistryPanelRepository;
import gov.va.med.mhv.health.service.ChemistryLabService;

import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ChemistryLabServiceImpl  implements  ChemistryLabService{
	
private static Logger log = LogManager.getLogger(ChemistryLabServiceImpl.class);
	
	@Autowired
	private ChemistryLabRepository chemLabRepository;
	
	@Autowired
	private ChemistryPanelRepository chempanelRepository;


	@Override
	public ResponseUtil findChemLabsForPatient(Long patientId) {
		ResponseUtil response = new ResponseUtil();
		List<ChemistryLab> chemlabs=chemLabRepository.getChemLabsForPatient(patientId);
		if(chemlabs != null){
			List<ChemistryLabDTO> dtos = ChemistryLabConverter.convertChemLabRecords(chemlabs);
			response.setPojoObject(dtos);
		}else{
			log.debug("Chemistry Lab Records not found for Patient:");
			log.debug(patientId);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findChemPanelForPatient(Long patientId, Long chemlabId) {
		ResponseUtil response = new ResponseUtil();
		List<ChemistryPanel> chempanelList=chempanelRepository.getChemPanelForPatient(patientId, chemlabId);
		if(chempanelList != null){
			List<ChemistryPanelDTO> chempanelDTOs = ChemistryLabConverter.convertChemPanelRecords(chempanelList);
			response.setPojoObject(chempanelDTOs);
		}else{
			log.debug("Chemistry Panel Record not found for Patient:");
			log.debug(patientId);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findDashboardChemLabsForPatient(Long patientId) {
		ResponseUtil response = new ResponseUtil();
		Pageable topFive = new  PageRequest(0,6);
		List<ChemistryLab> chemlabs=chemLabRepository.getDashboardChemLabsForPatient(patientId, topFive);
		if(chemlabs != null){
			List<ChemistryLabDTO> dtos = ChemistryLabConverter.convertChemLabRecords(chemlabs);
			response.setPojoObject(dtos);
		}else{
			log.debug("Chemistry Lab dash board Records not found for Patient:");
			log.debug(patientId);
		}
		response.setSuccess(true);
		return response;
	}

}
