package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.VAAllergyDTO;
import gov.va.med.mhv.health.model.VAAllergy;

import java.util.ArrayList;
import java.util.List;

public class VAAllergyConverter {
	
	public static VAAllergyDTO  convertAllergyDomain(VAAllergy allergy ){
		VAAllergyDTO dto = new VAAllergyDTO();
		dto.setAllergyType(allergy.getAllergyType());
		dto.setComments(allergy.getComments());
		dto.setDrugClass(allergy.getDrugClass());
		dto.setFacilityInfoId(allergy.getFacilityInfoId());
		dto.setFacilityName(allergy.getFacilityName());
		dto.setObservationDate(allergy.getObservationDate());
		dto.setObservationDateImprecise(allergy.getObservationDateImprecise());
		dto.setObserved(allergy.getObserved());
		dto.setPatientId(allergy.getPatientId());
		dto.setPhrFacilityControlId(allergy.getPhrFacilityControlId());
		dto.setReactant(allergy.getReactant());
		dto.setReaction(allergy.getReaction());
		dto.setRecordId(allergy.getRecordId());
		dto.setStationNumber(allergy.getStationNumber());
		dto.setVaAllergyId(allergy.getId());
		return dto;
		
	}
	
	
	public static VAAllergy convertAllergyDTO(VAAllergyDTO dto){
		VAAllergy vaAllergy = new VAAllergy();
		vaAllergy.setAllergyType(dto.getAllergyType());
		vaAllergy.setComments(dto.getComments());
		vaAllergy.setDrugClass(dto.getDrugClass());
		vaAllergy.setFacilityInfoId(dto.getFacilityInfoId());
		vaAllergy.setFacilityName(dto.getFacilityName());
		vaAllergy.setId(dto.getVaAllergyId());
		vaAllergy.setObservationDate(dto.getObservationDate());
		vaAllergy.setObservationDateImprecise(dto.getObservationDateImprecise());
		vaAllergy.setObserved(dto.getObserved());
		vaAllergy.setOplock(0);
		vaAllergy.setPatientId(dto.getPatientId());
		vaAllergy.setPhrFacilityControlId(dto.getPhrFacilityControlId());
		vaAllergy.setReactant(dto.getReactant());
		vaAllergy.setReaction(dto.getReaction());
		vaAllergy.setRecordId(dto.getRecordId());
		vaAllergy.setStationNumber(dto.getStationNumber());
		return vaAllergy;
	}
	
	
	public static List<VAAllergyDTO>  convertAllergiesRecords( List<VAAllergy> allergies ){
		List<VAAllergyDTO> dtos = new ArrayList<VAAllergyDTO>();
		for(VAAllergy allergy : allergies){
			VAAllergyDTO dto = convertAllergyDomain(allergy);
			dtos.add(dto);
		}
		return dtos;
	}

}
