package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.MilitaryHistoryDTO;
import gov.va.med.mhv.health.model.MilitaryHistory;
import java.util.ArrayList;
import java.util.List;

public class MilitaryHistoryConverter {
	
	public static MilitaryHistoryDTO  convertMilitaryHistoryRecordDomain( MilitaryHistory militaryHistory ){
		
		MilitaryHistoryDTO dto = new MilitaryHistoryDTO();
		dto.setId(militaryHistory.getId());
		dto.setEventTitle(militaryHistory.getEventTitle());
		dto.setEventDate(militaryHistory.getEventDate());
		dto.setServiceBranch(militaryHistory.getServiceBranch());
		dto.setRank(militaryHistory.getRank());
		dto.setServiceLocation(militaryHistory.getServiceLocation());
		dto.setAboardShip(militaryHistory.getAboardShip());
		dto.setOccupationSpecialty(militaryHistory.getOccupationSpecialty());
		dto.setServiceAssignment(militaryHistory.getServiceAssignment());	
		dto.setExposures(militaryHistory.getExposures());
		dto.setExperience(militaryHistory.getExperience());
		dto.setOplock(1);
		dto.setUserprofileId(militaryHistory.getUserprofileId());
		return dto;
	}

	
	public static MilitaryHistory convertMilitaryHistoryDTO(MilitaryHistoryDTO dto){
		MilitaryHistory militaryHistory = new MilitaryHistory();
		militaryHistory.setId(dto.getId());
		militaryHistory.setEventTitle(dto.getEventTitle());
		militaryHistory.setEventDate(dto.getEventDate());
		militaryHistory.setServiceBranch(dto.getServiceBranch());
		militaryHistory.setRank(dto.getRank());
		militaryHistory.setServiceLocation(dto.getServiceLocation());
		militaryHistory.setAboardShip(dto.getAboardShip());
		militaryHistory.setOccupationSpecialty(dto.getOccupationSpecialty());
		militaryHistory.setServiceAssignment(dto.getServiceAssignment());	
		militaryHistory.setExposures(dto.getExposures());
		militaryHistory.setExperience(dto.getExperience());
		militaryHistory.setOplock(1);
		militaryHistory.setUserprofileId(dto.getUserprofileId());	
				
		return militaryHistory;
	}

	

	public static List<MilitaryHistoryDTO>  convertMilitaryHistoryRecords( List<MilitaryHistory> militaryHistoryRecords ){
		List<MilitaryHistoryDTO> dtos = new ArrayList<MilitaryHistoryDTO>();
		for(MilitaryHistory militaryHistoryRecord : militaryHistoryRecords){
			MilitaryHistoryDTO dto = convertMilitaryHistoryRecordDomain(militaryHistoryRecord);
			dtos.add(dto);
		}
		return dtos;
	}
	
	

}
