package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.MedicalEventDTO;
import gov.va.med.mhv.health.model.MedicalEvent;

import java.util.ArrayList;
import java.util.List;

public class MedicalEventConverter {
	
	public static MedicalEventDTO  convertMedicalEventDomain( MedicalEvent medicalEvent ){
		MedicalEventDTO dto = new MedicalEventDTO();
		dto.setComments(medicalEvent.getComments());
		dto.setMedicalEvent(medicalEvent.getMedicalEvent());
		dto.setMedicalEventId(medicalEvent.getId());
		dto.setResponse(medicalEvent.getResponse());
		dto.setStartDate(medicalEvent.getStartDate());
		dto.setStopDate(medicalEvent.getStopDate());
		dto.setUserprofileId(medicalEvent.getUserprofileId());
		return dto;
	}

	public static MedicalEvent convertMedicalEventDTO(MedicalEventDTO dto){
		MedicalEvent medicalEvent = new MedicalEvent();
		medicalEvent.setComments(dto.getComments());
		medicalEvent.setId(dto.getMedicalEventId());
		medicalEvent.setMedicalEvent(dto.getMedicalEvent());
		medicalEvent.setOplock(0);
		medicalEvent.setResponse(dto.getResponse());
		medicalEvent.setStartDate(dto.getStartDate());
		medicalEvent.setStopDate(dto.getStopDate());
		medicalEvent.setUserprofileId(dto.getUserprofileId());
		return medicalEvent;
	}
	

	public static List<MedicalEventDTO>  convertMedicalEventRecords( List<MedicalEvent> medicalEvents ){
		List<MedicalEventDTO> dtos = new ArrayList<MedicalEventDTO>();
		for(MedicalEvent medicalEvent : medicalEvents){
			MedicalEventDTO dto = convertMedicalEventDomain(medicalEvent);
			dtos.add(dto);
		}
		return dtos;
	}

}
