package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.OtherHealthIssueDTO;
import gov.va.med.mhv.health.model.HealthHistoryRecord;
import gov.va.med.mhv.health.model.OtherHealthIssue;

import java.util.ArrayList;
import java.util.List;

public class HealthHistoryRecordConverter {
	
	public static HealthHistoryRecordDTO  convertHealthHistoryRecordDomain(HealthHistoryRecord source ){
		
		HealthHistoryRecordDTO target = new HealthHistoryRecordDTO();
		
		target.setId(source.getId());
		target.setRelationship(source.getRelationship());
		target.setFirstName(source.getFirstName());
		target.setLastName(source.getLastName());
		target.setLiving(convertToBoolean(source.getLiving()));
		target.setComments(source.getComments());
		target.setAwAsthma(convertToBoolean(source.getAwAsthma()));
		target.setAwBronchitis(convertToBoolean(source.getAwBronchitis()));
		target.setAwCOPD(convertToBoolean(source.getAwCOPD()));
		target.setAwEmphysema(convertToBoolean(source.getAwEmphysema()));
		target.setAwPneumonia(convertToBoolean(source.getAwPneumonia())); 
		target.setAwSoB(convertToBoolean(source.getAwSoB()));
		target.setAwTuberculosis(convertToBoolean(source.getAwTuberculosis()));
		target.setAwOther(convertToBoolean(source.getAwOther()));
		target.setAlAllergies(convertToBoolean(source.getAlAllergies()));
		target.setAlLupus(convertToBoolean(source.getAlLupus())); 
		target.setAlOther(convertToBoolean(source.getAlOther()));
		target.setAlcSocial(convertToBoolean(source.getAlcSocial()));
		target.setAlcOneDrink(convertToBoolean(source.getAlcOneDrink()));
		target.setAlcSixDrinks(convertToBoolean(source.getAlcSixDrinks()));
		target.setAlcTwoShots(convertToBoolean(source.getAlcTwoShots()));
		target.setBlAnemia(convertToBoolean(source.getBlAnemia()));
		target.setBlBruising(convertToBoolean(source.getBlBruising()));
		target.setBlClotting(convertToBoolean(source.getBlClotting()));
		target.setBlLeukemia(convertToBoolean(source.getBlLeukemia()));
		target.setBlSickleCell(convertToBoolean(source.getBlSickleCell()));
		target.setBlOther(convertToBoolean(source.getBlOther()));
		target.setBaArthritis(convertToBoolean(source.getBaArthritis()));
		target.setBaFibromyalgia(convertToBoolean(source.getBaFibromyalgia()));
		target.setBaJointPain(convertToBoolean(source.getBaJointPain()));
		target.setBaLymeDisease(convertToBoolean(source.getBaLymeDisease()));
		target.setBaOther(convertToBoolean(source.getBaOther()));
		target.setCaBreast(convertToBoolean(source.getCaBreast()));
		target.setCaBowel(convertToBoolean(source.getCaBowel()));
		target.setCaColon(convertToBoolean(source.getCaColon()));
		target.setCaLung(convertToBoolean(source.getCaLung()));
		target.setCaOvarian(convertToBoolean(source.getCaOvarian()));
		target.setCaSkin(convertToBoolean(source.getCaSkin()));
		target.setCaStomach(convertToBoolean(source.getCaStomach()));
		target.setCaProstate(convertToBoolean(source.getCaProstate()));
		target.setCaOther(convertToBoolean(source.getCaOther()));
		target.setChChickenPox(convertToBoolean(source.getChChickenPox()));
		target.setChDiphtheria(convertToBoolean(source.getChDiphtheria()));
		target.setChMeasles(convertToBoolean(source.getChMeasles()));
		target.setChMumps(convertToBoolean(source.getChMumps()));
		target.setChWhoopingCough(convertToBoolean(source.getChWhoopingCough()));
		target.setChOther(convertToBoolean(source.getChOther()));
		target.setDbType1(convertToBoolean(source.getDbType1()));
		target.setDbType2(convertToBoolean(source.getDbType2()));
		target.setDbType3(convertToBoolean(source.getDbType3()));
		target.setGbDisease(convertToBoolean(source.getGbDisease()));
		target.setGbStones(convertToBoolean(source.getGbStones()));
		target.setGbOther(convertToBoolean(source.getGbOther()));
		target.setHntCataracts(convertToBoolean(source.getHntCataracts()));
		target.setHntDizziness(convertToBoolean(source.getHntDizziness()));
		target.setHntDyslexia(convertToBoolean(source.getHntDyslexia()));
		target.setHntGlaucoma(convertToBoolean(source.getHntGlaucoma()));
		target.setHntHearingLoss(convertToBoolean(source.getHntHearingLoss()));
		target.setHntMigraineHeadaches(convertToBoolean(source.getHntMigraineHeadaches()));
		target.setHntRetinitisPigmentosa(convertToBoolean(source.getHntRetinitisPigmentosa()));
		target.setHntOther(convertToBoolean(source.getHntOther()));
		target.setHeAngina(convertToBoolean(source.getHeAngina()));
		target.setHeCongestiveFailure(convertToBoolean(source.getHeCongestiveFailure()));
		target.setHeAttack(convertToBoolean(source.getHeAttack()));
		target.setHeMurmur(convertToBoolean(source.getHeMurmur()));
		target.setHeHighCholesterol(convertToBoolean(source.getHeHighCholesterol()));
		target.setHeHighPressure(convertToBoolean(source.getHeHighPressure()));
		target.setHeMitralValveProlapse(convertToBoolean(source.getHeMitralValveProlapse()));
		target.setHeRhythmAbnormality(convertToBoolean(source.getHeRhythmAbnormality()));
		target.setHeStroke(convertToBoolean(source.getHeStroke()));
		target.setHeOther(convertToBoolean(source.getHeOther()));
		target.setKiInfections(convertToBoolean(source.getKiInfections()));
		target.setKiStones(convertToBoolean(source.getKiStones()));
		target.setKiRenalFailure(convertToBoolean(source.getKiRenalFailure()));
		target.setKiOther(convertToBoolean(source.getKiOther()));
		target.setKiOther(convertToBoolean(source.getKiOther()));
		target.setLiHepatitisA(convertToBoolean(source.getLiHepatitisA()));
		target.setLiHepatitisB(convertToBoolean(source.getLiHepatitisB()));
		target.setLiHepatitisC(convertToBoolean(source.getLiHepatitisC()));
		target.setLiCirrhosis(convertToBoolean(source.getLiCirrhosis()));
		target.setLiOther(convertToBoolean(source.getLiOther()));
		target.setMdAnxiety(convertToBoolean(source.getMdAnxiety()));
		target.setMdBipolar(convertToBoolean(source.getMdBipolar()));
		target.setMdDepression(convertToBoolean(source.getMdDepression()));
		target.setMdParanoia(convertToBoolean(source.getMdParanoia()));
		target.setMdPTSD(convertToBoolean(source.getMdPTSD()));
		target.setMdSchizophrenia(convertToBoolean(source.getMdSchizophrenia()));
		target.setMdOther(convertToBoolean(source.getMdOther()));
		target.setNvEpilepsy(convertToBoolean(source.getNvEpilepsy()));
		target.setNvMultipleSclerosis(convertToBoolean(source.getNvMultipleSclerosis()));
		target.setNvNumbness(convertToBoolean(source.getNvNumbness()));
		target.setNvParalysis(convertToBoolean(source.getNvParalysis()));
		target.setNvSeizures(convertToBoolean(source.getNvSeizures()));
		target.setNvOther(convertToBoolean(source.getNvOther()));
		target.setNbOnePerMonth(convertToBoolean(source.getNbOnePerMonth()));
		target.setNbOnePerWeek(convertToBoolean(source.getNbOnePerWeek()));
		target.setNbOnePerDay(convertToBoolean(source.getNbOnePerDay()));
		target.setPnBack(convertToBoolean(source.getPnBack()));
		target.setPnJoint(convertToBoolean(source.getPnJoint()));
		target.setPnMuscle(convertToBoolean(source.getPnMuscle()));
		target.setPnLeg(convertToBoolean(source.getPnLeg()));
		target.setPnOther(convertToBoolean(source.getPnOther()));
		target.setSkEczema(convertToBoolean(source.getSkEczema()));
		target.setSkPsoriasis(convertToBoolean(source.getSkPsoriasis()));
		target.setSkOther(convertToBoolean(source.getSkOther()));
		target.setSlInsomnia(convertToBoolean(source.getSlInsomnia()));
		target.setSlApnea(convertToBoolean(source.getSlApnea()));
		target.setSlOther(convertToBoolean(source.getSlOther()));
		target.setSmCurrent(convertToBoolean(source.getSmCurrent()));
		target.setSmOnePackPerDay(convertToBoolean(source.getSmOnePackPerDay()));
		target.setSmTenYears(convertToBoolean(source.getSmTenYears()));
		target.setSmTwentyYears(convertToBoolean(source.getSmTwentyYears()));
		target.setStdChlamydia(convertToBoolean(source.getStdChlamydia()));
		target.setStdGonorrhea(convertToBoolean(source.getStdGonorrhea()));
		target.setStdHerpes(convertToBoolean(source.getStdHerpes()));
		target.setStdSyphilis(convertToBoolean(source.getStdSyphilis()));
		target.setStdOther(convertToBoolean(source.getStdOther()));
		target.setStmIBS(convertToBoolean(source.getStmIBS()));
		target.setStmNausea(convertToBoolean(source.getStmNausea()));
		target.setStmPain(convertToBoolean(source.getStmPain()));
		target.setStmSevereIndigestion(convertToBoolean(source.getStmSevereIndigestion()));
		target.setStmUlcers(convertToBoolean(source.getStmUlcers()));
		target.setStmOther(convertToBoolean(source.getStmOther()));
		target.setThGoiter(convertToBoolean(source.getThGoiter()));
		target.setThTumor(convertToBoolean(source.getThTumor()));
		target.setThOther(convertToBoolean(source.getThOther()));
		target.setWtOverweight(convertToBoolean(source.getWtOverweight()));
		target.setWtUnderweight(convertToBoolean(source.getWtUnderweight()));
		
		target.setOplock(0);		
		target.setUserprofileId(source.getUserprofileId());
		target.setOtherHealthIssues(setOtherHealthIssuesDTOS(target, source));
		
		return target;
	}

	private static List<OtherHealthIssueDTO> setOtherHealthIssuesDTOS(HealthHistoryRecordDTO dto, HealthHistoryRecord healthHistoryRecord) {

		List<OtherHealthIssue> issues=healthHistoryRecord.getOtherHealthIssues();

		List<OtherHealthIssueDTO> dtos = new ArrayList<OtherHealthIssueDTO>();
		if(issues != null){
			for(OtherHealthIssue issue : issues){
				OtherHealthIssueDTO otherHealthIssueDTO = new OtherHealthIssueDTO();
				otherHealthIssueDTO.setId(issue.getId());
				otherHealthIssueDTO.setIssue(issue.getIssue());
				otherHealthIssueDTO.setOplock(0);
				otherHealthIssueDTO.setHealthHistId(issue.getHealthHistId());
				dtos.add(otherHealthIssueDTO);
			}
		}
		dto.setOtherHealthIssues(dtos);

		return dtos;
	}

	public static HealthHistoryRecord convertHealthHistoryRecordDTO(HealthHistoryRecordDTO source){
		HealthHistoryRecord target = new HealthHistoryRecord();
	
		target.setId(source.getId());
		target.setRelationship(source.getRelationship());
		target.setFirstName(source.getFirstName());
		target.setLastName(source.getLastName());
		target.setLiving(source.getLiving());
		target.setComments(source.getComments());
		target.setAwAsthma(source.getAwAsthma());
		target.setAwBronchitis(source.getAwBronchitis());
		target.setAwCOPD(source.getAwCOPD());
		target.setAwEmphysema(source.getAwEmphysema());
		target.setAwPneumonia(source.getAwPneumonia()); 
		target.setAwSoB(source.getAwSoB());
		target.setAwTuberculosis(source.getAwTuberculosis());
		target.setAwOther(source.getAwOther());
		target.setAlAllergies(source.getAlAllergies());
		target.setAlLupus(source.getAlLupus()); 
		target.setAlOther(source.getAlOther());
		target.setAlcSocial(source.getAlcSocial());
		target.setAlcOneDrink(source.getAlcOneDrink());
		target.setAlcSixDrinks(source.getAlcSixDrinks());
		target.setAlcTwoShots(source.getAlcTwoShots());
		target.setBlAnemia(source.getBlAnemia());
		target.setBlBruising(source.getBlBruising());
		target.setBlClotting(source.getBlClotting());
		target.setBlLeukemia(source.getBlLeukemia());
		target.setBlSickleCell(source.getBlSickleCell());
		target.setBlOther(source.getBlOther());
		target.setBaArthritis(source.getBaArthritis());
		target.setBaFibromyalgia(source.getBaFibromyalgia());
		target.setBaJointPain(source.getBaJointPain());
		target.setBaLymeDisease(source.getBaLymeDisease());
		target.setBaOther(source.getBaOther());
		target.setCaBreast(source.getCaBreast());
		target.setCaBowel(source.getCaBowel());
		target.setCaColon(source.getCaColon());
		target.setCaLung(source.getCaLung());
		target.setCaOvarian(source.getCaOvarian());
		target.setCaSkin(source.getCaSkin());
		target.setCaStomach(source.getCaStomach());
		target.setCaProstate(source.getCaProstate());
		target.setCaOther(source.getCaOther());
		target.setChChickenPox(source.getChChickenPox());
		target.setChDiphtheria(source.getChDiphtheria());
		target.setChMeasles(source.getChMeasles());
		target.setChMumps(source.getChMumps());
		target.setChWhoopingCough(source.getChWhoopingCough());
		target.setChOther(source.getChOther());
		target.setDbType1(source.getDbType1());
		target.setDbType2(source.getDbType2());
		target.setDbType3(source.getDbType3());
		target.setGbDisease(source.getGbDisease());
		target.setGbStones(source.getGbStones());
		target.setGbOther(source.getGbOther());
		target.setHntCataracts(source.getHntCataracts());
		target.setHntDizziness(source.getHntDizziness());
		target.setHntDyslexia(source.getHntDyslexia());
		target.setHntGlaucoma(source.getHntGlaucoma());
		target.setHntHearingLoss(source.getHntHearingLoss());
		target.setHntMigraineHeadaches(source.getHntMigraineHeadaches());
		target.setHntRetinitisPigmentosa(source.getHntRetinitisPigmentosa());
		target.setHntOther(source.getHntOther());
		target.setHeAngina(source.getHeAngina());
		target.setHeCongestiveFailure(source.getHeCongestiveFailure());
		target.setHeAttack(source.getHeAttack());
		target.setHeMurmur(source.getHeMurmur());
		target.setHeHighCholesterol(source.getHeHighCholesterol());
		target.setHeHighPressure(source.getHeHighPressure());
		target.setHeMitralValveProlapse(source.getHeMitralValveProlapse());
		target.setHeRhythmAbnormality(source.getHeRhythmAbnormality());
		target.setHeStroke(source.getHeStroke());
		target.setHeOther(source.getHeOther());
		target.setKiInfections(source.getKiInfections());
		target.setKiStones(source.getKiStones());
		target.setKiRenalFailure(source.getKiRenalFailure());
		target.setKiOther(source.getKiOther());
		target.setKiOther(source.getKiOther());
		target.setLiHepatitisA(source.getLiHepatitisA());
		target.setLiHepatitisB(source.getLiHepatitisB());
		target.setLiHepatitisC(source.getLiHepatitisC());
		target.setLiCirrhosis(source.getLiCirrhosis());
		target.setLiOther(source.getLiOther());
		target.setMdAnxiety(source.getMdAnxiety());
		target.setMdBipolar(source.getMdBipolar());
		target.setMdDepression(source.getMdDepression());
		target.setMdParanoia(source.getMdParanoia());
		target.setMdPTSD(source.getMdPTSD());
		target.setMdSchizophrenia(source.getMdSchizophrenia());
		target.setMdOther(source.getMdOther());
		target.setNvEpilepsy(source.getNvEpilepsy());
		target.setNvMultipleSclerosis(source.getNvMultipleSclerosis());
		target.setNvNumbness(source.getNvNumbness());
		target.setNvParalysis(source.getNvParalysis());
		target.setNvSeizures(source.getNvSeizures());
		target.setNvOther(source.getNvOther());
		target.setNbOnePerMonth(source.getNbOnePerMonth());
		target.setNbOnePerWeek(source.getNbOnePerWeek());
		target.setNbOnePerDay(source.getNbOnePerDay());
		target.setPnBack(source.getPnBack());
		target.setPnJoint(source.getPnJoint());
		target.setPnMuscle(source.getPnMuscle());
		target.setPnLeg(source.getPnLeg());
		target.setPnOther(source.getPnOther());
		target.setSkEczema(source.getSkEczema());
		target.setSkPsoriasis(source.getSkPsoriasis());
		target.setSkOther(source.getSkOther());
		target.setSlInsomnia(source.getSlInsomnia());
		target.setSlApnea(source.getSlApnea());
		target.setSlOther(source.getSlOther());
		target.setSmCurrent(source.getSmCurrent());
		target.setSmOnePackPerDay(source.getSmOnePackPerDay());
		target.setSmTenYears(source.getSmTenYears());
		target.setSmTwentyYears(source.getSmTwentyYears());
		target.setStdChlamydia(source.getStdChlamydia());
		target.setStdGonorrhea(source.getStdGonorrhea());
		target.setStdHerpes(source.getStdHerpes());
		target.setStdSyphilis(source.getStdSyphilis());
		target.setStdOther(source.getStdOther());
		target.setStmIBS(source.getStmIBS());
		target.setStmNausea(source.getStmNausea());
		target.setStmPain(source.getStmPain());
		target.setStmSevereIndigestion(source.getStmSevereIndigestion());
		target.setStmUlcers(source.getStmUlcers());
		target.setStmOther(source.getStmOther());
		target.setThGoiter(source.getThGoiter());
		target.setThTumor(source.getThTumor());
		target.setThOther(source.getThOther());
		target.setWtOverweight(source.getWtOverweight());
		target.setWtUnderweight(source.getWtUnderweight());
		
		target.setOplock(0);
		target.setUserprofileId(source.getUserprofileId());
		setOtherHealthIssues(target, source);	

		return target;
	}
	
	private static void setOtherHealthIssues(HealthHistoryRecord healthHistoryRecord, HealthHistoryRecordDTO dto) {
		List<OtherHealthIssue> issues =new ArrayList<OtherHealthIssue>();	
		
		for (OtherHealthIssueDTO otherHealthIssue: dto.getOtherHealthIssues())  {
			OtherHealthIssue newIssue = new OtherHealthIssue();
			newIssue.setId(otherHealthIssue.getId());
			newIssue.setOplock(0);
			newIssue.setIssue(otherHealthIssue.getIssue());
			newIssue.setHealthHistId(otherHealthIssue.getHealthHistId());
			newIssue.setHealthHistoryRecord(healthHistoryRecord);
			issues.add(newIssue);
		}
		healthHistoryRecord.setOtherHealthIssues(issues);
	}
		
	@SuppressWarnings("unused")
	private static List<OtherHealthIssue> convertToOtherList(HealthHistoryRecordDTO dto) {
		List<OtherHealthIssue> convList = new ArrayList <OtherHealthIssue>(0);
		for (OtherHealthIssueDTO issueDTO: dto.getOtherHealthIssues()) {
			OtherHealthIssue issue = new OtherHealthIssue(); 
			issue.setId(issueDTO.getId());
			issue.setIssue(issueDTO.getIssue());
			issue.setOplock(issueDTO.getOplock());
			convList.add(issue);
		}
		return convList;
	}
	
	public static List<HealthHistoryRecordDTO> convertHealthHistoryRecords(List<HealthHistoryRecord> healthHistoryRecords) {
		List<HealthHistoryRecordDTO> dtos = new ArrayList<HealthHistoryRecordDTO>();
		for (HealthHistoryRecord healthHistoryRecord : healthHistoryRecords) {
			HealthHistoryRecordDTO dto = convertHealthHistoryRecordDomain(healthHistoryRecord);
			dtos.add(dto);
		}
		return dtos;
	}
	
	public static Boolean convertToBoolean(Integer value) {
		if (value == null || value == 0) {
			return new Boolean("false");
		} else {
			return new Boolean("true");
		}

	}
	
	public static Integer convertToInteger(Boolean value) {
		if (value == null || value == false) {
			return 0;
		} else {
			return 1;
		}
	}
}
