package gov.va.med.mhv.health.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="PHR_CHEM_TEST")
public class ChemistryTest implements Serializable {

	private static final long serialVersionUID = 8883388974329048109L;
	
	@Id
	@Column(name="PHR_CHEM_TEST_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@ManyToOne
	@JoinColumn(name="PHR_CHEM_PANEL_ID")
	private ChemistryPanel chemistryPanel;
	
	@Column(name="OPLOCK")
	private Integer oplock;
			
	@Column(name="RESULT")
	private String result;
	
	@Column(name="RESULT_INDICATOR")
	private String resultIndicator;
	
	@Column(name="UNITS")
	private String units;
	
	@Column(name="REFERENCE_RANGE")
	private String referenceRange;
	
	@Column(name="LAB_TEST_NAME")
	private String  labTestName;
	
	@Column(name="PERFORMING_LOCATION")
	private String performingLocation;
	
	@Column(name="STATION_NUMBER")
	private String stationNumber;
	
	@Column(name="STATUS")
	private String status;
	
	@Lob
	@Column(name="INTERPRETATION")
	private String  interpretation;
	
	@Column(name="PERFORMING_LOCATION_NAME")
	private String performingLoctaionName;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	
	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getResultIndicator() {
		return resultIndicator;
	}

	public void setResultIndicator(String resultIndicator) {
		this.resultIndicator = resultIndicator;
	}

	public String getUnits() {
		return units;
	}

	public void setUnits(String units) {
		this.units = units;
	}

	public String getReferenceRange() {
		return referenceRange;
	}

	public void setReferenceRange(String referenceRange) {
		this.referenceRange = referenceRange;
	}

	public String getLabTestName() {
		return labTestName;
	}

	public void setLabTestName(String labTestName) {
		this.labTestName = labTestName;
	}

	public String getPerformingLocation() {
		return performingLocation;
	}

	public void setPerformingLocation(String performingLocation) {
		this.performingLocation = performingLocation;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getStatus() {
		return status;
	}

	public ChemistryPanel getChemistryPanel() {
		return chemistryPanel;
	}

	public void setChemistryPanel(ChemistryPanel chemistryPanel) {
		this.chemistryPanel = chemistryPanel;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(String interpretation) {
		this.interpretation = interpretation;
	}

	public String getPerformingLoctaionName() {
		return performingLoctaionName;
	}

	public void setPerformingLoctaionName(String performingLoctaionName) {
		this.performingLoctaionName = performingLoctaionName;
	}

}
