package gov.va.med.mhv.getcare.web.dao;

import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityResponse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.ws.rs.core.MediaType;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;

@Component
public class TreatmentFacilityDaoImpl implements TreatmentFacilityDao, Serializable {
	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthCareProviderDaoImpl.class);

	@Value("${endpointUrl}")
	private String endpointUrl;

	private static final String TREATMENTFACILITY_WS = "treatmentfacility";
	
	@Override
	public List<TreatmentFacilityDTO> findByProfileId(String userProfileId) {
		List<Object> providers = new ArrayList<Object>();
        providers.add( new JacksonJaxbJsonProvider() );
        
		WebClient client = WebClient.create(endpointUrl, providers).path(TREATMENTFACILITY_WS).path("get/{id}", userProfileId)
				.accept(MediaType.APPLICATION_JSON).type(MediaType.APPLICATION_JSON);
		
		logger.debug("findByProfileId: " + client.getCurrentURI());

		Collection<? extends TreatmentFacilityDTO> c = client.getCollection(TreatmentFacilityDTO.class);
		
		List<TreatmentFacilityDTO> dtoList = new ArrayList<TreatmentFacilityDTO>();
		dtoList.addAll(c);
		
		if (logger.isDebugEnabled()) {
			if (dtoList != null && dtoList.size() > 0)
				logger.debug(Arrays.toString(dtoList.toArray()));
			else
				logger.debug("no results");
		}

		return dtoList;
	}

	@Override
	public String ping(String message) {
		
		WebClient client = WebClient.create(endpointUrl).path(TREATMENTFACILITY_WS).path("ping/{msg}", message)
				.accept(MediaType.TEXT_PLAIN);
		logger.debug("ping: " + client.getCurrentURI());

		String result = client.get(String.class);

		logger.debug(result);

		return result;
	}

	@Override
	public TreatmentFacilityResponse save(TreatmentFacilityDTO dto) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TreatmentFacilityResponse delete(TreatmentFacilityDTO dto) {
		// TODO Auto-generated method stub
		return null;
	}

}
