package gov.va.med.mhv.getcare.web.dao;

import gov.va.med.mhv.getcare.common.dto.HealthInsuranceDTO;
import gov.va.med.mhv.getcare.common.dto.HealthInsuranceResponse;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

@Component
public class HealthInsuranceDaoImpl implements HealthInsuranceDao, Serializable {

	private static final long serialVersionUID = 1L;

	private static Logger logger = LogManager.getLogger(HealthInsuranceDaoImpl.class);

	@Value("${endpointUrl}")
	private String endpointUrl;
	
	private static final String HEALTHCARE_INSURANCE_WS = "healthinsurance";
	
	@Override
	public List<HealthInsuranceDTO> findByProfileId(String userProfileId) {
		Reader responseReader = null;
		List<HealthInsuranceDTO> dtoList = null;

		logger.debug("creating gson");
		Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();

		logger.debug("creating client " + endpointUrl);
		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_INSURANCE_WS).path("get/{id}", userProfileId)
				.accept(MediaType.APPLICATION_JSON);

		logger.debug("reading stream");
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());

		logger.debug("converting");
		Type type = new TypeToken<List<HealthInsuranceDTO>>() {
		}.getType();
		dtoList = gson.fromJson(responseReader, type);

		if (dtoList != null && dtoList.size() > 0)
			logger.debug(Arrays.toString(dtoList.toArray()));
		else
			logger.debug("no results");

		return dtoList;
	}

	@Override
	public HealthInsuranceResponse save(HealthInsuranceDTO dto) {
		logger.debug("Saving: " + dto);
		HealthInsuranceResponse result = null;

		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_INSURANCE_WS).path("save")
				.accept(MediaType.APPLICATION_JSON).type(MediaType.APPLICATION_JSON);

		logger.debug("Saving gson");
		Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();

		String dtoJSON = gson.toJson(dto);

		logger.debug("posting");
		Response r = client.post(dtoJSON);

		Reader responseReader = new InputStreamReader((InputStream) r.getEntity());

		logger.debug("saved");
		result = gson.fromJson(responseReader, HealthInsuranceResponse.class);
		logger.debug(result);

		return result;
	}

	@Override
	public HealthInsuranceResponse delete(HealthInsuranceDTO dto) {
		logger.debug("Deleting: " + dto);
		
		HealthInsuranceResponse result = new HealthInsuranceResponse();
		result.setDTO(dto);

		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_INSURANCE_WS).path("delete")
				.accept(MediaType.APPLICATION_JSON).type(MediaType.APPLICATION_JSON);

		logger.debug("Deleting gson");
		Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();;

		String dtoJSON = gson.toJson(dto);

		logger.debug("posting");
		Response r = client.post(dtoJSON);

		Reader responseReader = new InputStreamReader((InputStream) r.getEntity());

		logger.debug("deleted");
		result = gson.fromJson(responseReader, HealthInsuranceResponse.class);
		logger.debug(result);

		return result;
	}

	@Override
	public String ping(String message) {
		logger.debug("creating client " + endpointUrl);
		WebClient client = WebClient.create(endpointUrl).path(HEALTHCARE_INSURANCE_WS).path("ping/{msg}", message)
				.accept(MediaType.TEXT_PLAIN);

		String result = client.get(String.class);

		logger.debug(result);

		return result;
	}

}
